/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContextBasedSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LM_OTS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LmsUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;

public class LMSPrivateKeyParameters
extends LMSKeyParameters
implements LMSContextBasedSigner {
    private static CacheKey T1;
    private static CacheKey[] internedKeys;
    private final byte[] I;
    private final LMSigParameters parameters;
    private final LMOtsParameters otsParameters;
    private final int maxQ;
    private final byte[] masterSecret;
    private final Map<CacheKey, byte[]> tCache;
    private final int maxCacheR;
    private final Digest tDigest;
    private int q;
    private LMSPublicKeyParameters publicKey;

    public LMSPrivateKeyParameters(LMSigParameters lMSigParameters, LMOtsParameters lMOtsParameters, int n3, byte[] byArray, int n4, byte[] byArray2) {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        super(true);
        this.parameters = lMSigParameters;
        this.otsParameters = lMOtsParameters;
        this.q = n3;
        this.I = Arrays.clone(byArray);
        this.maxQ = n4;
        this.masterSecret = Arrays.clone(byArray2);
        lMSPrivateKeyParameters.maxCacheR = 1 << lMSigParameters.getH() + 1;
        lMSPrivateKeyParameters.tCache = new WeakHashMap<CacheKey, byte[]>();
        this.tDigest = DigestUtil.getDigest(lMSigParameters.getDigestOID());
    }

    private LMSPrivateKeyParameters(LMSPrivateKeyParameters lMSPrivateKeyParameters, int n3, int n4) {
        LMSigParameters lMSigParameters;
        LMSPrivateKeyParameters lMSPrivateKeyParameters2 = this;
        super(true);
        this.parameters = lMSigParameters = lMSPrivateKeyParameters.parameters;
        this.otsParameters = lMSPrivateKeyParameters.otsParameters;
        this.q = n3;
        this.I = lMSPrivateKeyParameters.I;
        this.maxQ = n4;
        this.masterSecret = lMSPrivateKeyParameters.masterSecret;
        this.maxCacheR = 1 << lMSigParameters.getH();
        lMSPrivateKeyParameters2.tCache = lMSPrivateKeyParameters.tCache;
        lMSPrivateKeyParameters2.tDigest = DigestUtil.getDigest(lMSigParameters.getDigestOID());
        this.publicKey = lMSPrivateKeyParameters.publicKey;
    }

    public static LMSPrivateKeyParameters getInstance(byte[] byArray, byte[] byArray2) {
        LMSPrivateKeyParameters.getInstance(byArray).publicKey = LMSPublicKeyParameters.getInstance(byArray2);
        return LMSPrivateKeyParameters.getInstance(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LMSPrivateKeyParameters getInstance(Object object) {
        if (object instanceof LMSPrivateKeyParameters) {
            return (LMSPrivateKeyParameters)object;
        }
        if (object instanceof DataInputStream) {
            if (((DataInputStream)(object = (DataInputStream)object)).readInt() != 0) {
                throw new IllegalStateException("expected version 0 lms private key");
            }
            Object object2 = object;
            LMSigParameters lMSigParameters = LMSigParameters.getParametersForType(((DataInputStream)object2).readInt());
            LMOtsParameters lMOtsParameters = LMOtsParameters.getParametersForType(((DataInputStream)object2).readInt());
            byte[] byArray = new byte[16];
            ((DataInputStream)object2).readFully(byArray);
            int n3 = ((DataInputStream)object2).readInt();
            int n4 = ((DataInputStream)object2).readInt();
            int n5 = ((DataInputStream)object2).readInt();
            if (n5 < 0) {
                throw new IllegalStateException("secret length less than zero");
            }
            if (n5 <= ((InputStream)object).available()) {
                Object object3 = object;
                byte[] byArray2 = new byte[n5];
                object = byArray2;
                ((DataInputStream)object3).readFully(byArray2);
                return new LMSPrivateKeyParameters(lMSigParameters, lMOtsParameters, n3, byArray, n4, (byte[])object);
            }
            throw new IOException(b.b.a("secret length exceeded ").append(((InputStream)object).available()).toString());
        }
        if (object instanceof byte[]) {
            void var0_3;
            InputStream inputStream;
            block13: {
                LMSPrivateKeyParameters lMSPrivateKeyParameters;
                DataInputStream dataInputStream;
                inputStream = null;
                DataInputStream dataInputStream2 = dataInputStream;
                try {
                    dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                }
                catch (Throwable throwable) {
                    // empty catch block
                    break block13;
                }
                try {
                    lMSPrivateKeyParameters = LMSPrivateKeyParameters.getInstance(dataInputStream);
                }
                catch (Throwable throwable) {
                    inputStream = dataInputStream2;
                    break block13;
                }
                ((InputStream)dataInputStream2).close();
                return lMSPrivateKeyParameters;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            throw var0_3;
        }
        if (object instanceof InputStream) {
            return LMSPrivateKeyParameters.getInstance(Streams.readAll((InputStream)object));
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] findT(CacheKey cacheKey) {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        Map<CacheKey, byte[]> map = lMSPrivateKeyParameters.tCache;
        synchronized (map) {
            byte[] byArray = lMSPrivateKeyParameters.tCache.get(cacheKey);
            if (byArray != null) {
                return byArray;
            }
            byArray = this.calcT(cacheKey.index);
            Map<CacheKey, byte[]> map2 = map;
            this.tCache.put(cacheKey, byArray);
            // ** MonitorExit[v1] (shouldn't be in output)
            return byArray;
        }
    }

    private byte[] calcT(int n3) {
        int n4 = 1 << this.getSigParameters().getH();
        if (n3 >= n4) {
            LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
            LMSPrivateKeyParameters lMSPrivateKeyParameters2 = this;
            LmsUtils.byteArray(lMSPrivateKeyParameters2.getI(), this.tDigest);
            LmsUtils.u32str(n3, lMSPrivateKeyParameters2.tDigest);
            LmsUtils.u16str((short)-32126, lMSPrivateKeyParameters.tDigest);
            byte[] byArray = this.getI();
            n4 = n3 - n4;
            byte[] byArray2 = this.getMasterSecret();
            LmsUtils.byteArray(LM_OTS.lms_ots_generatePublicKey(lMSPrivateKeyParameters.getOtsParameters(), byArray, n4, byArray2), this.tDigest);
            byte[] byArray3 = new byte[lMSPrivateKeyParameters.tDigest.getDigestSize()];
            this.tDigest.doFinal(byArray3, 0);
            return byArray3;
        }
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        int n5 = n3 * 2;
        byte[] byArray = this.findT(n5);
        byte[] byArray4 = lMSPrivateKeyParameters.findT(n5 + 1);
        LMSPrivateKeyParameters lMSPrivateKeyParameters3 = this;
        LMSPrivateKeyParameters lMSPrivateKeyParameters4 = this;
        LmsUtils.byteArray(lMSPrivateKeyParameters4.getI(), this.tDigest);
        LmsUtils.u32str(n3, lMSPrivateKeyParameters4.tDigest);
        LmsUtils.u16str((short)-31869, lMSPrivateKeyParameters3.tDigest);
        LmsUtils.byteArray(byArray, lMSPrivateKeyParameters3.tDigest);
        LmsUtils.byteArray(byArray4, this.tDigest);
        byte[] byArray5 = new byte[lMSPrivateKeyParameters.tDigest.getDigestSize()];
        this.tDigest.doFinal(byArray5, 0);
        return byArray5;
    }

    static {
        CacheKey cacheKey;
        CacheKey cacheKey2 = cacheKey;
        T1 = new CacheKey(1);
        CacheKey[] cacheKeyArray = new CacheKey[129];
        internedKeys = cacheKeyArray;
        cacheKeyArray[1] = cacheKey2;
        int n3 = 2;
        while (true) {
            CacheKey cacheKey3;
            Object object = internedKeys;
            if (n3 >= internedKeys.length) break;
            CacheKey[] cacheKeyArray2 = object;
            object = cacheKey3;
            cacheKey3 = new CacheKey(n3);
            cacheKeyArray2[n3] = object;
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LMOtsPrivateKey getCurrentOTSKey() {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        synchronized (lMSPrivateKeyParameters) {
            LMOtsPrivateKey lMOtsPrivateKey;
            int n3 = lMSPrivateKeyParameters.q;
            if (n3 >= this.maxQ) throw new ExhaustedPrivateKeyException("ots private keys expired");
            LMOtsPrivateKey lMOtsPrivateKey2 = lMOtsPrivateKey;
            LMSPrivateKeyParameters lMSPrivateKeyParameters2 = this;
            LMSPrivateKeyParameters lMSPrivateKeyParameters3 = this;
            LMSPrivateKeyParameters lMSPrivateKeyParameters4 = lMSPrivateKeyParameters3;
            LMSPrivateKeyParameters lMSPrivateKeyParameters5 = lMSPrivateKeyParameters3;
            LMOtsParameters lMOtsParameters = lMSPrivateKeyParameters3.otsParameters;
            byte[] byArray = lMSPrivateKeyParameters5.I;
            byte[] byArray2 = lMSPrivateKeyParameters4.masterSecret;
            lMOtsPrivateKey2(lMOtsParameters, byArray, n3, byArray2);
            // ** MonitorExit[v4] (shouldn't be in output)
            return lMOtsPrivateKey;
        }
    }

    public synchronized int getIndex() {
        return this.q;
    }

    public synchronized void incIndex() {
        ++this.q;
    }

    @Override
    public LMSContext generateLMSContext() {
        int n3 = this.getSigParameters().getH();
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        int n4 = lMSPrivateKeyParameters.getIndex();
        LMOtsPrivateKey lMOtsPrivateKey = lMSPrivateKeyParameters.getNextOtsPrivateKey();
        n4 = (1 << n3) + n4;
        byte[][] byArrayArray = new byte[n3][];
        for (int i3 = 0; i3 < n3; ++i3) {
            byArrayArray[i3] = this.findT(n4 / (1 << i3) ^ 1);
        }
        return lMOtsPrivateKey.getSignatureContext(this.getSigParameters(), byArrayArray);
    }

    @Override
    public byte[] generateSignature(LMSContext lMSContext) {
        try {
            return LMS.generateSign(lMSContext).getEncoded();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, b.b.a("unable to encode signature: ")), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LMOtsPrivateKey getNextOtsPrivateKey() {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        synchronized (lMSPrivateKeyParameters) {
            LMOtsPrivateKey lMOtsPrivateKey;
            int n3 = lMSPrivateKeyParameters.q;
            if (n3 >= this.maxQ) throw new ExhaustedPrivateKeyException("ots private key exhausted");
            Object object = lMOtsPrivateKey;
            LMSPrivateKeyParameters lMSPrivateKeyParameters2 = this;
            LMSPrivateKeyParameters lMSPrivateKeyParameters3 = lMSPrivateKeyParameters2;
            LMSPrivateKeyParameters lMSPrivateKeyParameters4 = lMSPrivateKeyParameters2;
            LMOtsPrivateKey lMOtsPrivateKey2 = object;
            LMSPrivateKeyParameters lMSPrivateKeyParameters5 = this;
            LMSPrivateKeyParameters lMSPrivateKeyParameters6 = lMSPrivateKeyParameters5;
            LMSPrivateKeyParameters lMSPrivateKeyParameters7 = lMSPrivateKeyParameters5;
            object = lMSPrivateKeyParameters5.otsParameters;
            byte[] byArray = lMSPrivateKeyParameters7.I;
            byte[] byArray2 = lMSPrivateKeyParameters6.masterSecret;
            lMOtsPrivateKey2((LMOtsParameters)object, byArray, n3, byArray2);
            lMSPrivateKeyParameters3.incIndex();
            // ** MonitorExit[v5] (shouldn't be in output)
            return lMOtsPrivateKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LMSPrivateKeyParameters extractKeyShard(int n3) {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        synchronized (lMSPrivateKeyParameters) {
            LMSPrivateKeyParameters lMSPrivateKeyParameters2;
            int n4 = lMSPrivateKeyParameters.q;
            if (n4 + n3 >= this.maxQ) throw new IllegalArgumentException("usageCount exceeds usages remaining");
            LMSPrivateKeyParameters lMSPrivateKeyParameters3 = lMSPrivateKeyParameters2;
            LMSPrivateKeyParameters lMSPrivateKeyParameters4 = this;
            lMSPrivateKeyParameters3(this, n4, n4 + n3);
            int n5 = lMSPrivateKeyParameters4.q;
            lMSPrivateKeyParameters4.q = n5 + n3;
            // ** MonitorExit[v3] (shouldn't be in output)
            return lMSPrivateKeyParameters2;
        }
    }

    public LMSigParameters getSigParameters() {
        return this.parameters;
    }

    public LMOtsParameters getOtsParameters() {
        return this.otsParameters;
    }

    public byte[] getI() {
        return Arrays.clone(this.I);
    }

    public byte[] getMasterSecret() {
        return Arrays.clone(this.masterSecret);
    }

    @Override
    public long getUsagesRemaining() {
        return this.maxQ - this.q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LMSPublicKeyParameters getPublicKey() {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        synchronized (lMSPrivateKeyParameters) {
            if (lMSPrivateKeyParameters.publicKey == null) {
                LMSPrivateKeyParameters lMSPrivateKeyParameters2 = this;
                LMSigParameters lMSigParameters = lMSPrivateKeyParameters2.parameters;
                LMOtsParameters lMOtsParameters = lMSPrivateKeyParameters2.otsParameters;
                byte[] byArray = lMSPrivateKeyParameters2.findT(T1);
                byte[] byArray2 = lMSPrivateKeyParameters2.I;
                this.publicKey = new LMSPublicKeyParameters(lMSigParameters, lMOtsParameters, byArray, byArray2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.publicKey;
        }
    }

    public byte[] findT(int n3) {
        if (n3 < this.maxCacheR) {
            Object object;
            Object object2 = internedKeys;
            if (n3 < internedKeys.length) {
                object = object2[n3];
            } else {
                CacheKey cacheKey;
                object2 = cacheKey;
                cacheKey = new CacheKey(n3);
                object = object2;
            }
            return this.findT((CacheKey)object);
        }
        return this.calcT(n3);
    }

    public boolean equals(Object object) {
        if (lMSKeyParameters == object) {
            return true;
        }
        if (object != null && lMSKeyParameters.getClass() == object.getClass()) {
            object = (LMSPrivateKeyParameters)object;
            if (((LMSPrivateKeyParameters)lMSKeyParameters).q != ((LMSPrivateKeyParameters)object).q) {
                return false;
            }
            if (((LMSPrivateKeyParameters)lMSKeyParameters).maxQ != ((LMSPrivateKeyParameters)object).maxQ) {
                return false;
            }
            if (!Arrays.areEqual(((LMSPrivateKeyParameters)lMSKeyParameters).I, ((LMSPrivateKeyParameters)object).I)) {
                return false;
            }
            Object object2 = ((LMSPrivateKeyParameters)lMSKeyParameters).parameters;
            if (object2 != null ? !object2.equals(((LMSPrivateKeyParameters)object).parameters) : ((LMSPrivateKeyParameters)object).parameters != null) {
                return false;
            }
            object2 = ((LMSPrivateKeyParameters)lMSKeyParameters).otsParameters;
            if (object2 != null ? !object2.equals(((LMSPrivateKeyParameters)object).otsParameters) : ((LMSPrivateKeyParameters)object).otsParameters != null) {
                return false;
            }
            if (!Arrays.areEqual(((LMSPrivateKeyParameters)lMSKeyParameters).masterSecret, ((LMSPrivateKeyParameters)object).masterSecret)) {
                return false;
            }
            LMSKeyParameters lMSKeyParameters = ((LMSPrivateKeyParameters)lMSKeyParameters).publicKey;
            if (lMSKeyParameters != null && (object = ((LMSPrivateKeyParameters)object).publicKey) != null) {
                return ((LMSPublicKeyParameters)lMSKeyParameters).equals(object);
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        LMSPrivateKeyParameters lMSPrivateKeyParameters = this;
        int n3 = lMSPrivateKeyParameters.q * 31;
        n3 = (Arrays.hashCode(lMSPrivateKeyParameters.I) + n3) * 31;
        LMSigParameters lMSigParameters = lMSPrivateKeyParameters.parameters;
        int n4 = lMSigParameters != null ? lMSigParameters.hashCode() : 0;
        n3 = (n3 + n4) * 31;
        LMOtsParameters lMOtsParameters = this.otsParameters;
        int n5 = lMOtsParameters != null ? lMOtsParameters.hashCode() : 0;
        LMSPrivateKeyParameters lMSPrivateKeyParameters2 = this;
        int n6 = ((n3 + n5) * 31 + this.maxQ) * 31;
        n6 = (Arrays.hashCode(lMSPrivateKeyParameters2.masterSecret) + n6) * 31;
        LMSPublicKeyParameters lMSPublicKeyParameters = lMSPrivateKeyParameters2.publicKey;
        int n7 = lMSPublicKeyParameters != null ? lMSPublicKeyParameters.hashCode() : 0;
        return n6 + n7;
    }

    @Override
    public byte[] getEncoded() {
        return Composer.compose().u32str(0).u32str(this.parameters.getType()).u32str(this.otsParameters.getType()).bytes(this.I).u32str(this.q).u32str(this.maxQ).u32str(this.masterSecret.length).bytes(this.masterSecret).build();
    }

    public static class CacheKey {
        private final int index;

        public CacheKey(int n3) {
            this.index = n3;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object object) {
            if (object instanceof CacheKey) {
                return ((CacheKey)object).index == this.index;
            }
            return false;
        }
    }
}

