/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class LMSigParameters {
    public static final LMSigParameters lms_sha256_n32_h5;
    public static final LMSigParameters lms_sha256_n32_h10;
    public static final LMSigParameters lms_sha256_n32_h15;
    public static final LMSigParameters lms_sha256_n32_h20;
    public static final LMSigParameters lms_sha256_n32_h25;
    private static Map<Object, LMSigParameters> paramBuilders;
    private final int type;
    private final int m;
    private final int h;
    private final ASN1ObjectIdentifier digestOid;

    public LMSigParameters(int n3, int n4, int n5, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.type = n3;
        this.m = n4;
        this.h = n5;
        this.digestOid = aSN1ObjectIdentifier;
    }

    public static LMSigParameters getParametersForType(int n3) {
        return paramBuilders.get(n3);
    }

    static {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha256;
        lms_sha256_n32_h5 = new LMSigParameters(5, 32, 5, aSN1ObjectIdentifier);
        lms_sha256_n32_h10 = new LMSigParameters(6, 32, 10, aSN1ObjectIdentifier);
        lms_sha256_n32_h15 = new LMSigParameters(7, 32, 15, aSN1ObjectIdentifier);
        lms_sha256_n32_h20 = new LMSigParameters(8, 32, 20, aSN1ObjectIdentifier);
        lms_sha256_n32_h25 = new LMSigParameters(9, 32, 25, aSN1ObjectIdentifier);
        paramBuilders = new HashMap<Object, LMSigParameters>(){
            {
                1 v02 = object;
                Object object = lms_sha256_n32_h5;
                ((AbstractMap)v02).put(((LMSigParameters)object).type, object);
                object = lms_sha256_n32_h10;
                ((AbstractMap)v02).put(((LMSigParameters)object).type, object);
                object = lms_sha256_n32_h15;
                ((AbstractMap)v02).put(((LMSigParameters)object).type, object);
                object = lms_sha256_n32_h20;
                ((AbstractMap)v02).put(((LMSigParameters)object).type, object);
                object = lms_sha256_n32_h25;
                ((AbstractMap)v02).put(((LMSigParameters)object).type, object);
            }
        };
    }

    public int getType() {
        return this.type;
    }

    public int getH() {
        return this.h;
    }

    public int getM() {
        return this.m;
    }

    public ASN1ObjectIdentifier getDigestOID() {
        return this.digestOid;
    }
}

