/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMOtsSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSContext;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSException;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LmsUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.SeedDerive;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

class LM_OTS {
    private static final short D_PBLC = -32640;
    private static final int ITER_K = 20;
    private static final int ITER_PREV = 23;
    private static final int ITER_J = 22;
    public static final int SEED_RANDOMISER_INDEX = -3;
    public static final int SEED_LEN = 32;
    public static final int MAX_HASH = 32;
    public static final short D_MESG = -32383;

    public static int coef(byte[] byArray, int n3, int n4) {
        int n5 = n3;
        int n6 = n5 * n4 / 8;
        n3 = 8 / n4;
        n3 = n4 * (~n5 & n3 - 1);
        int n7 = n6;
        n6 = (1 << n4) - 1;
        return byArray[n7] >>> n3 & n6;
    }

    public static int cksm(byte[] byArray, int n3, LMOtsParameters lMOtsParameters) {
        int n4 = 0;
        int n5 = (1 << lMOtsParameters.getW()) - 1;
        for (int i3 = 0; i3 < n3 * 8 / lMOtsParameters.getW(); ++i3) {
            n4 = n4 + n5 - LM_OTS.coef(byArray, i3, lMOtsParameters.getW());
        }
        return n4 << lMOtsParameters.getLs();
    }

    public static LMOtsPublicKey lms_ots_generatePublicKey(LMOtsPrivateKey object) {
        LMOtsPrivateKey lMOtsPrivateKey = object;
        byte[] byArray = lMOtsPrivateKey.getI();
        int n3 = lMOtsPrivateKey.getQ();
        byte[] byArray2 = lMOtsPrivateKey.getMasterSecret();
        byArray = LM_OTS.lms_ots_generatePublicKey(((LMOtsPrivateKey)object).getParameter(), byArray, n3, byArray2);
        LMOtsPrivateKey lMOtsPrivateKey2 = object;
        object = lMOtsPrivateKey2.getParameter();
        byte[] byArray3 = lMOtsPrivateKey2.getI();
        int n4 = lMOtsPrivateKey2.getQ();
        return new LMOtsPublicKey((LMOtsParameters)object, byArray3, n4, byArray);
    }

    public static byte[] lms_ots_generatePublicKey(LMOtsParameters lMOtsParameters, byte[] byArray, int n3, byte[] byArray2) {
        SeedDerive seedDerive;
        LMOtsParameters lMOtsParameters2 = lMOtsParameters;
        Digest digest = DigestUtil.getDigest(lMOtsParameters2.getDigestOID());
        byte[] byArray3 = Composer.compose().bytes(byArray).u32str(n3).u16str(-32640).padUntil(0, 22).build();
        digest.update(byArray3, 0, byArray3.length);
        Digest digest2 = DigestUtil.getDigest(lMOtsParameters2.getDigestOID());
        byte[] byArray4 = Composer.compose().bytes(byArray).u32str(n3).padUntil(0, digest2.getDigestSize() + 23).build();
        SeedDerive seedDerive2 = seedDerive;
        seedDerive2(byArray, byArray2, DigestUtil.getDigest(lMOtsParameters.getDigestOID()));
        seedDerive.setQ(n3);
        seedDerive.setJ(0);
        int n4 = lMOtsParameters2.getP();
        int n5 = lMOtsParameters2.getN();
        n3 = (1 << lMOtsParameters2.getW()) - 1;
        for (int i3 = 0; i3 < n4; ++i3) {
            int n6 = i3 < n4 - 1 ? 1 : 0;
            seedDerive2.deriveSeed(byArray4, n6 != 0, 23);
            Pack.shortToBigEndian((short)i3, byArray4, 20);
            for (n6 = 0; n6 < n3; ++n6) {
                Digest digest3 = digest2;
                byArray4[22] = (byte)n6;
                int n7 = byArray4.length;
                digest3.update(byArray4, 0, n7);
                digest3.doFinal(byArray4, 23);
            }
            digest.update(byArray4, 23, n5);
        }
        byte[] byArray5 = new byte[digest.getDigestSize()];
        digest.doFinal(byArray5, 0);
        return byArray5;
    }

    public static LMOtsSignature lm_ots_generate_signature(LMSigParameters object, LMOtsPrivateKey lMOtsPrivateKey, byte[][] byArray, byte[] byArray2, boolean bl) {
        byte[] byArray3 = new byte[34];
        if (!bl) {
            LMSContext lMSContext = lMOtsPrivateKey.getSignatureContext((LMSigParameters)object, byArray);
            object = lMSContext;
            LmsUtils.byteArray(byArray2, 0, byArray2.length, (Digest)object);
            object = lMSContext.getC();
            byArray3 = lMSContext.getQ();
        } else {
            object = new byte[32];
            int n3 = lMOtsPrivateKey.getParameter().getN();
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
        }
        return LM_OTS.lm_ots_generate_signature(lMOtsPrivateKey, byArray3, (byte[])object);
    }

    public static LMOtsSignature lm_ots_generate_signature(LMOtsPrivateKey lMOtsPrivateKey, byte[] byArray, byte[] byArray2) {
        LMOtsPrivateKey lMOtsPrivateKey2 = lMOtsPrivateKey;
        LMOtsParameters lMOtsParameters = lMOtsPrivateKey2.getParameter();
        int n3 = lMOtsParameters.getN();
        int n4 = lMOtsParameters.getP();
        int n5 = lMOtsParameters.getW();
        byte[] byArray3 = new byte[n4 * n3];
        Digest digest = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
        SeedDerive seedDerive = lMOtsPrivateKey2.getDerivationFunction();
        int n6 = LM_OTS.cksm(byArray, n3, lMOtsParameters);
        int n7 = n6;
        byArray[n3] = (byte)(n7 >>> 8 & 0xFF);
        n7 = n3 + 1;
        byArray[n7] = (byte)n6;
        int n8 = n3 + 23;
        byte[] byArray4 = Composer.compose().bytes(lMOtsPrivateKey.getI()).u32str(lMOtsPrivateKey.getQ()).padUntil(0, n8).build();
        seedDerive.setJ(0);
        for (int i3 = 0; i3 < n4; ++i3) {
            Pack.shortToBigEndian((short)i3, byArray4, 20);
            int n9 = i3 < n4 - 1 ? 1 : 0;
            seedDerive.deriveSeed(byArray4, n9 != 0, 23);
            n9 = LM_OTS.coef(byArray, i3, n5);
            for (int i4 = 0; i4 < n9; ++i4) {
                Digest digest2 = digest;
                byArray4[22] = (byte)i4;
                digest2.update(byArray4, 0, n8);
                digest2.doFinal(byArray4, 23);
            }
            n9 = n3 * i3;
            System.arraycopy(byArray4, 23, byArray3, n9, n3);
        }
        return new LMOtsSignature(lMOtsParameters, byArray2, byArray3);
    }

    public static boolean lm_ots_validate_signature(LMOtsPublicKey lMOtsPublicKey, LMOtsSignature lMOtsSignature, byte[] byArray, boolean bl) {
        if (lMOtsSignature.getType().equals(lMOtsPublicKey.getParameter())) {
            return Arrays.areEqual(LM_OTS.lm_ots_validate_signature_calculate(lMOtsPublicKey, lMOtsSignature, byArray), lMOtsPublicKey.getK());
        }
        throw new LMSException("public key and signature ots types do not match");
    }

    public static byte[] lm_ots_validate_signature_calculate(LMOtsPublicKey object, LMOtsSignature lMOtsSignature, byte[] byArray) {
        object = ((LMOtsPublicKey)object).createOtsContext(lMOtsSignature);
        LmsUtils.byteArray(byArray, (Digest)object);
        return LM_OTS.lm_ots_validate_signature_calculate((LMSContext)object);
    }

    public static byte[] lm_ots_validate_signature_calculate(LMSContext lMSContext) {
        LMSContext lMSContext2 = lMSContext;
        LMOtsPublicKey lMOtsPublicKey = lMSContext2.getPublicKey();
        Object object = lMOtsPublicKey.getParameter();
        Object object2 = lMSContext2.getSignature();
        object2 = object2 instanceof LMSSignature ? ((LMSSignature)object2).getOtsSignature() : (LMOtsSignature)object2;
        LMOtsParameters lMOtsParameters = object;
        LMOtsPublicKey lMOtsPublicKey2 = lMOtsPublicKey;
        LMOtsParameters lMOtsParameters2 = object;
        int n3 = lMOtsParameters2.getN();
        int n4 = lMOtsParameters2.getW();
        int n5 = lMOtsParameters2.getP();
        byte[] byArray = lMSContext.getQ();
        byte[] byArray2 = byArray;
        int n6 = LM_OTS.cksm(byArray, n3, (LMOtsParameters)object);
        int n7 = n6;
        byArray2[n3] = (byte)(n7 >>> 8 & 0xFF);
        n7 = n3 + 1;
        byArray[n7] = (byte)n6;
        byte[] byArray3 = lMOtsPublicKey2.getI();
        int n8 = lMOtsPublicKey2.getQ();
        object = DigestUtil.getDigest(((LMOtsParameters)object).getDigestOID());
        LmsUtils.byteArray(byArray3, (Digest)object);
        LmsUtils.u32str(n8, (Digest)object);
        LmsUtils.u16str((short)-32640, (Digest)object);
        int n9 = n3 + 23;
        byte[] byArray4 = Composer.compose().bytes(byArray3).u32str(n8).padUntil(0, n9).build();
        int n10 = (1 << n4) - 1;
        byte[] byArray5 = ((LMOtsSignature)object2).getY();
        Digest digest = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
        for (int i3 = 0; i3 < n5; ++i3) {
            Pack.shortToBigEndian((short)i3, byArray4, 20);
            System.arraycopy(byArray5, i3 * n3, byArray4, 23, n3);
            for (int i4 = LM_OTS.coef(byArray2, i3, n4); i4 < n10; ++i4) {
                Digest digest2 = digest;
                byArray4[22] = (byte)i4;
                digest2.update(byArray4, 0, n9);
                digest2.doFinal(byArray4, 23);
            }
            object.update(byArray4, 23, n3);
        }
        byte[] byArray6 = new byte[n3];
        object.doFinal(byArray6, 0);
        return byArray6;
    }
}

