/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSigParameters;

class LmsUtils {
    public static void u32str(int n3, Digest digest) {
        digest.update((byte)(n3 >>> 24));
        digest.update((byte)(n3 >>> 16));
        digest.update((byte)(n3 >>> 8));
        digest.update((byte)n3);
    }

    public static void u16str(short s2, Digest digest) {
        digest.update((byte)(s2 >>> 8));
        digest.update((byte)s2);
    }

    public static void byteArray(byte[] byArray, Digest digest) {
        int n3 = byArray.length;
        digest.update(byArray, 0, n3);
    }

    public static void byteArray(byte[] byArray, int n3, int n4, Digest digest) {
        digest.update(byArray, n3, n4);
    }

    public static int calculateStrength(LMSParameters lMSParameters) {
        if (lMSParameters != null) {
            LMSigParameters lMSigParameters = lMSParameters.getLMSigParam();
            int n3 = 1 << lMSigParameters.getH();
            return lMSigParameters.getM() * n3;
        }
        throw new NullPointerException("lmsParameters cannot be null");
    }
}

