/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.BigIntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;
import java.math.BigInteger;

final class Conversions {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    private Conversions() {
    }

    public static GF2Vector encode(int n3, int n4, byte[] object) {
        if (n3 >= n4) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = IntegerFunctions.binomial(n3, n4);
            BigInteger bigInteger3 = bigInteger;
            bigInteger3(1, (byte[])object);
            if (bigInteger.compareTo(bigInteger2) < 0) {
                GF2Vector gF2Vector;
                object = gF2Vector;
                gF2Vector = new GF2Vector(n3);
                int n5 = n3;
                for (int i3 = 0; i3 < n3; ++i3) {
                    bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(n5 - n4)).divide(BigInteger.valueOf(n5));
                    --n5;
                    if (bigInteger2.compareTo(bigInteger3) > 0) continue;
                    ((GF2Vector)object).setBit(i3);
                    bigInteger3 = bigInteger3.subtract(bigInteger2);
                    bigInteger2 = n5 == (n4 += -1) ? ONE : bigInteger2.multiply(BigInteger.valueOf(n4 + 1)).divide(BigInteger.valueOf(n5 - n4));
                }
                return object;
            }
            throw new IllegalArgumentException("Encoded number too large.");
        }
        throw new IllegalArgumentException("n < t");
    }

    public static byte[] decode(int n3, int n4, GF2Vector object) {
        if (((Vector)object).getLength() == n3 && ((GF2Vector)object).getHammingWeight() == n4) {
            object = ((GF2Vector)object).getVecArray();
            BigInteger bigInteger = IntegerFunctions.binomial(n3, n4);
            BigInteger bigInteger2 = ZERO;
            int n5 = n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                bigInteger = bigInteger.multiply(BigInteger.valueOf(n5 - n4)).divide(BigInteger.valueOf(n5));
                --n5;
                if ((object[i3 >> 5] & 1 << (i3 & 0x1F)) == 0) continue;
                bigInteger2 = bigInteger2.add(bigInteger);
                bigInteger = n5 == (n4 += -1) ? ONE : bigInteger.multiply(BigInteger.valueOf(n4 + 1)).divide(BigInteger.valueOf(n5 - n4));
            }
            return BigIntUtils.toMinimalByteArray(bigInteger2);
        }
        throw new IllegalArgumentException("vector has wrong length or hamming weight");
    }

    public static byte[] signConversion(int n3, int n4, byte[] byArray) {
        if (n3 >= n4) {
            BigInteger bigInteger = IntegerFunctions.binomial(n3, n4);
            int n5 = bigInteger.bitLength() - 1;
            int n6 = n5 >> 3;
            int n7 = n5 & 7;
            if (n7 == 0) {
                --n6;
                n7 = 8;
            }
            int n8 = n3;
            int n9 = n8 >> 3;
            int n10 = n8 & 7;
            if (n10 == 0) {
                --n9;
                n10 = 8;
            }
            int n11 = n9 + 1;
            byte[] byArray2 = new byte[n11];
            if (byArray.length < n11) {
                int n12 = byArray.length;
                System.arraycopy(byArray, 0, byArray2, 0, n12);
                for (n12 = byArray.length; n12 < n11; ++n12) {
                    byArray2[n12] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, n9);
                byArray2[n9] = (byte)((1 << n10) - 1 & byArray[n9]);
            }
            Object object = ZERO;
            n10 = n3;
            for (n9 = 0; n9 < n3; ++n9) {
                int n13 = n9;
                bigInteger = bigInteger.multiply(new BigInteger(Integer.toString(n10 - n4))).divide(new BigInteger(Integer.toString(n10)));
                --n10;
                n11 = n13 >>> 3;
                if ((byte)(1 << (n13 & 7) & byArray2[n11]) == 0) continue;
                object = ((BigInteger)object).add(bigInteger);
                bigInteger = n10 == (n4 += -1) ? ONE : bigInteger.multiply(new BigInteger(Integer.toString(n4 + 1))).divide(new BigInteger(Integer.toString(n10 - n4)));
            }
            n3 = n6 + 1;
            byte[] byArray3 = new byte[n3];
            byte[] byArray4 = ((BigInteger)object).toByteArray();
            object = byArray4;
            if (byArray4.length < n3) {
                Object object2 = object;
                int n14 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray3, 0, n14);
                for (n14 = ((Object)(v1272921)).length; n14 < n3; ++n14) {
                    byArray3[n14] = 0;
                }
            } else {
                System.arraycopy(object, 0, byArray3, 0, n6);
                byArray3[n6] = (byte)((1 << n7) - 1 & object[n6]);
            }
            return byArray3;
        }
        throw new IllegalArgumentException("n < t");
    }
}

