/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageEncryptor;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GoppaCode;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;
import java.security.SecureRandom;

public class McElieceCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.1";
    private SecureRandom sr;
    private int n;
    private int k;
    private int t;
    public int maxPlainTextSize;
    public int cipherTextSize;
    private McElieceKeyParameters key;
    private boolean forEncryption;

    private void initCipherEncrypt(McEliecePublicKeyParameters mcEliecePublicKeyParameters) {
        McElieceCipher mcElieceCipher = this;
        this.n = mcEliecePublicKeyParameters.getN();
        this.k = mcEliecePublicKeyParameters.getK();
        mcElieceCipher.t = mcEliecePublicKeyParameters.getT();
        mcElieceCipher.cipherTextSize = mcElieceCipher.n >> 3;
        mcElieceCipher.maxPlainTextSize = mcElieceCipher.k >> 3;
    }

    private void initCipherDecrypt(McEliecePrivateKeyParameters mcEliecePrivateKeyParameters) {
        this.n = mcEliecePrivateKeyParameters.getN();
        this.k = mcEliecePrivateKeyParameters.getK();
        this.maxPlainTextSize = this.k >> 3;
        this.cipherTextSize = this.n >> 3;
    }

    private GF2Vector computeMessageRepresentative(byte[] byArray) {
        McElieceCipher mcElieceCipher = object;
        int n3 = mcElieceCipher.maxPlainTextSize;
        int n4 = (mcElieceCipher.k & 7) != 0 ? 1 : 0;
        McElieceCipher mcElieceCipher2 = object;
        byte[] byArray2 = new byte[n3 + n4];
        Object object = byArray2;
        int n5 = byArray.length;
        System.arraycopy(byArray, 0, object, 0, n5);
        byArray2[byArray.length] = 1;
        return GF2Vector.OS2VP(mcElieceCipher2.k, (byte[])object);
    }

    private byte[] computeMessage(GF2Vector gF2Vector) {
        int n3;
        Object object = gF2Vector.getEncoded();
        for (n3 = (v1273391).length - 1; n3 >= 0 && object[n3] == false; --n3) {
        }
        if (n3 >= 0 && object[n3] == true) {
            byte[] byArray = new byte[n3];
            System.arraycopy(object, 0, byArray, 0, n3);
            return byArray;
        }
        throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        Object object;
        ((McElieceCipher)object).forEncryption = bl;
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                McElieceCipher mcElieceCipher = object;
                object = (ParametersWithRandom)cipherParameters;
                mcElieceCipher.sr = ((ParametersWithRandom)object).getRandom();
                object = (McEliecePublicKeyParameters)((ParametersWithRandom)object).getParameters();
                mcElieceCipher.key = object;
                mcElieceCipher.initCipherEncrypt((McEliecePublicKeyParameters)object);
            } else {
                McElieceCipher mcElieceCipher = object;
                ((McElieceCipher)object).sr = CryptoServicesRegistrar.getSecureRandom();
                object = (McEliecePublicKeyParameters)cipherParameters;
                mcElieceCipher.key = object;
                mcElieceCipher.initCipherEncrypt((McEliecePublicKeyParameters)object);
            }
        } else {
            McElieceCipher mcElieceCipher = object;
            object = (McEliecePrivateKeyParameters)cipherParameters;
            mcElieceCipher.key = object;
            mcElieceCipher.initCipherDecrypt((McEliecePrivateKeyParameters)object);
        }
    }

    public int getKeySize(McElieceKeyParameters mcElieceKeyParameters) {
        if (mcElieceKeyParameters instanceof McEliecePublicKeyParameters) {
            return ((McEliecePublicKeyParameters)mcElieceKeyParameters).getN();
        }
        if (mcElieceKeyParameters instanceof McEliecePrivateKeyParameters) {
            return ((McEliecePrivateKeyParameters)mcElieceKeyParameters).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    @Override
    public byte[] messageEncrypt(byte[] object) {
        if (this.forEncryption) {
            GF2Vector gF2Vector;
            McElieceCipher mcElieceCipher = this;
            object = mcElieceCipher.computeMessageRepresentative((byte[])object);
            GF2Vector gF2Vector2 = gF2Vector;
            McElieceCipher mcElieceCipher2 = this;
            int n3 = mcElieceCipher2.n;
            int n4 = mcElieceCipher2.t;
            SecureRandom secureRandom = mcElieceCipher2.sr;
            gF2Vector = new GF2Vector(n3, n4, secureRandom);
            return ((GF2Vector)((McEliecePublicKeyParameters)mcElieceCipher.key).getG().leftMultiply((Vector)object).add(gF2Vector2)).getEncoded();
        }
        throw new IllegalStateException("cipher initialised for decryption");
    }

    @Override
    public byte[] messageDecrypt(byte[] object) {
        if (!this.forEncryption) {
            McElieceCipher mcElieceCipher = this;
            object = GF2Vector.OS2VP(mcElieceCipher.n, object);
            McEliecePrivateKeyParameters mcEliecePrivateKeyParameters = (McEliecePrivateKeyParameters)mcElieceCipher.key;
            Object object2 = mcEliecePrivateKeyParameters;
            Object object3 = mcEliecePrivateKeyParameters.getField();
            PolynomialGF2mSmallM polynomialGF2mSmallM = mcEliecePrivateKeyParameters.getGoppaPoly();
            byte[] byArray = object;
            Permutation permutation = ((McEliecePrivateKeyParameters)object2).getP1();
            object = permutation;
            McEliecePrivateKeyParameters mcEliecePrivateKeyParameters2 = object2;
            object2 = mcEliecePrivateKeyParameters2.getP2();
            GF2Matrix gF2Matrix = mcEliecePrivateKeyParameters2.getH();
            PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = mcEliecePrivateKeyParameters2.getQInv();
            object2 = permutation.rightMultiply((Permutation)object2);
            GF2Vector gF2Vector = (GF2Vector)byArray.multiply(((Permutation)object2).computeInverse());
            object3 = GoppaCode.syndromeDecode((GF2Vector)gF2Matrix.rightMultiply(gF2Vector), (GF2mField)object3, polynomialGF2mSmallM, polynomialGF2mSmallMArray);
            GF2Vector cfr_ignored_0 = (GF2Vector)((GF2Vector)object3).multiply((Permutation)object2);
            return mcElieceCipher.computeMessage((GF2Vector)mcEliecePrivateKeyParameters.getSInv().leftMultiply(((GF2Vector)((GF2Vector)gF2Vector.add((Vector)object3)).multiply((Permutation)object)).extractRightVector(this.k)));
        }
        throw new IllegalStateException("cipher initialised for decryption");
    }
}

