/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA1Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageEncryptor;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.Conversions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Primitives;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import java.security.SecureRandom;

public class McEliecePointchevalCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.2";
    private Digest messDigest;
    private SecureRandom sr;
    private int n;
    private int k;
    private int t;
    public McElieceCCA2KeyParameters key;
    private boolean forEncryption;

    private void initCipherEncrypt(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.messDigest = Utils.getDigest(mcElieceCCA2PublicKeyParameters.getDigest());
        this.n = mcElieceCCA2PublicKeyParameters.getN();
        this.k = mcElieceCCA2PublicKeyParameters.getK();
        this.t = mcElieceCCA2PublicKeyParameters.getT();
    }

    private void initCipherDecrypt(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.messDigest = Utils.getDigest(mcElieceCCA2PrivateKeyParameters.getDigest());
        this.n = mcElieceCCA2PrivateKeyParameters.getN();
        this.k = mcElieceCCA2PrivateKeyParameters.getK();
        this.t = mcElieceCCA2PrivateKeyParameters.getT();
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        Object object;
        ((McEliecePointchevalCipher)object).forEncryption = bl;
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                McEliecePointchevalCipher mcEliecePointchevalCipher = object;
                object = (ParametersWithRandom)cipherParameters;
                mcEliecePointchevalCipher.sr = ((ParametersWithRandom)object).getRandom();
                object = (McElieceCCA2PublicKeyParameters)((ParametersWithRandom)object).getParameters();
                mcEliecePointchevalCipher.key = object;
                mcEliecePointchevalCipher.initCipherEncrypt((McElieceCCA2PublicKeyParameters)object);
            } else {
                McEliecePointchevalCipher mcEliecePointchevalCipher = object;
                ((McEliecePointchevalCipher)object).sr = CryptoServicesRegistrar.getSecureRandom();
                object = (McElieceCCA2PublicKeyParameters)cipherParameters;
                mcEliecePointchevalCipher.key = object;
                mcEliecePointchevalCipher.initCipherEncrypt((McElieceCCA2PublicKeyParameters)object);
            }
        } else {
            McEliecePointchevalCipher mcEliecePointchevalCipher = object;
            object = (McElieceCCA2PrivateKeyParameters)cipherParameters;
            mcEliecePointchevalCipher.key = object;
            mcEliecePointchevalCipher.initCipherDecrypt((McElieceCCA2PrivateKeyParameters)object);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters mcElieceCCA2KeyParameters) {
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    public int decryptOutputSize(int n3) {
        return 0;
    }

    public int encryptOutputSize(int n3) {
        return 0;
    }

    @Override
    public byte[] messageEncrypt(byte[] byArray) {
        if (((McEliecePointchevalCipher)object2).forEncryption) {
            int n3;
            DigestRandomGenerator digestRandomGenerator;
            GF2Vector gF2Vector;
            McEliecePointchevalCipher mcEliecePointchevalCipher = object2;
            int n4 = ((McEliecePointchevalCipher)object2).k >> 3;
            byte[] byArray2 = new byte[n4];
            ((McEliecePointchevalCipher)object2).sr.nextBytes(byArray2);
            Object object = gF2Vector;
            McEliecePointchevalCipher mcEliecePointchevalCipher2 = object2;
            int n5 = mcEliecePointchevalCipher2.k;
            byte[] byArray3 = new GF2Vector(n5, mcEliecePointchevalCipher2.sr).getEncoded();
            byte[] byArray4 = ByteUtils.concatenate(byArray, byArray2);
            mcEliecePointchevalCipher.messDigest.update(byArray4, 0, byArray4.length);
            byArray4 = new byte[mcEliecePointchevalCipher.messDigest.getDigestSize()];
            mcEliecePointchevalCipher.messDigest.doFinal(byArray4, 0);
            Object object2 = Conversions.encode(mcEliecePointchevalCipher.n, ((McEliecePointchevalCipher)object2).t, byArray4);
            object2 = McElieceCCA2Primitives.encryptionPrimitive((McElieceCCA2PublicKeyParameters)mcEliecePointchevalCipher.key, (GF2Vector)object, (GF2Vector)object2).getEncoded();
            object = digestRandomGenerator;
            ((DigestRandomGenerator)object)(new SHA1Digest());
            ((DigestRandomGenerator)object).addSeedMaterial(byArray3);
            byte[] byArray5 = new byte[byArray.length + n4];
            object = byArray5;
            digestRandomGenerator.nextBytes(byArray5);
            for (n3 = 0; n3 < byArray.length; ++n3) {
                object[n3] = (byte)(object[n3] ^ byArray[n3]);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                Object object3 = object;
                int n6 = byArray.length + n3;
                object3[n6] = (byte)(object3[n6] ^ byArray2[n3]);
            }
            return ByteUtils.concatenate((byte[])object2, (byte[])object);
        }
        throw new IllegalStateException("cipher initialised for decryption");
    }

    @Override
    public byte[] messageDecrypt(byte[] byArray) {
        if (!this.forEncryption) {
            DigestRandomGenerator digestRandomGenerator;
            McEliecePointchevalCipher mcEliecePointchevalCipher = this;
            int n3 = this.n + 7 >> 3;
            int n4 = byArray.length - n3;
            byte[][] byArray2 = ByteUtils.split(byArray, n3);
            Object object = byArray2[0];
            byte[] byArray3 = byArray2[1];
            object = GF2Vector.OS2VP(mcEliecePointchevalCipher.n, object);
            GF2Vector[] gF2VectorArray = McElieceCCA2Primitives.decryptionPrimitive((McElieceCCA2PrivateKeyParameters)mcEliecePointchevalCipher.key, (GF2Vector)object);
            object = gF2VectorArray[0].getEncoded();
            GF2Vector gF2Vector = gF2VectorArray[1];
            DigestRandomGenerator digestRandomGenerator2 = digestRandomGenerator;
            digestRandomGenerator2(new SHA1Digest());
            digestRandomGenerator2.addSeedMaterial((byte[])object);
            object = new byte[n4];
            digestRandomGenerator.nextBytes((byte[])object);
            for (int i3 = 0; i3 < n4; ++i3) {
                object[i3] = (byte)(object[i3] ^ byArray3[i3]);
            }
            McEliecePointchevalCipher mcEliecePointchevalCipher2 = this;
            mcEliecePointchevalCipher2.messDigest.update((byte[])object, 0, n4);
            byArray3 = new byte[mcEliecePointchevalCipher2.messDigest.getDigestSize()];
            mcEliecePointchevalCipher2.messDigest.doFinal(byArray3, 0);
            if (Conversions.encode(mcEliecePointchevalCipher2.n, this.t, byArray3).equals(gF2Vector)) {
                return ByteUtils.split(object, n4 - (this.k >> 3))[0];
            }
            throw new InvalidCipherTextException("Bad Padding: Invalid ciphertext.");
        }
        throw new IllegalStateException("cipher initialised for decryption");
    }
}

