/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA3Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.ErrorCorrection;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.Poly;
import java.security.SecureRandom;

class NewHope {
    private static final boolean STATISTICAL_TEST = false;
    public static final int AGREEMENT_SIZE = 32;
    public static final int POLY_SIZE = 1024;
    public static final int SENDA_BYTES = 1824;
    public static final int SENDB_BYTES = 2048;

    public static void keygen(SecureRandom object, byte[] byArray, short[] sArray) {
        byte[] byArray2 = byArray;
        SecureRandom secureRandom = object;
        byArray = new byte[32];
        ((SecureRandom)object).nextBytes(byArray);
        NewHope.sha3(byArray);
        short[] sArray2 = new short[1024];
        object = sArray2;
        NewHope.generateA(sArray2, byArray);
        Object[] objectArray = new byte[32];
        secureRandom.nextBytes((byte[])objectArray);
        Poly.getNoise(sArray, objectArray, (byte)0);
        Poly.toNTT(sArray);
        short[] sArray3 = new short[1024];
        Poly.getNoise(sArray3, objectArray, (byte)1);
        Poly.toNTT(sArray3);
        short[] sArray4 = new short[1024];
        objectArray = sArray4;
        Poly.pointWise((short[])object, sArray, objectArray);
        object = new short[1024];
        Poly.add(sArray4, sArray3, (short[])object);
        NewHope.encodeA(byArray2, (short[])object, byArray);
    }

    public static void sharedB(SecureRandom object, byte[] byArray, byte[] objectArray, byte[] objectArray2) {
        byte[] byArray2 = objectArray;
        SecureRandom secureRandom = object;
        short[] sArray = new short[1024];
        object = sArray;
        byArray = new byte[32];
        NewHope.decodeA(sArray, byArray, objectArray2);
        short[] sArray2 = new short[1024];
        objectArray = sArray2;
        NewHope.generateA(sArray2, byArray);
        byArray = new byte[32];
        secureRandom.nextBytes(byArray);
        short[] sArray3 = new short[1024];
        objectArray2 = sArray3;
        Poly.getNoise(sArray3, byArray, (byte)0);
        Poly.toNTT(sArray3);
        short[] sArray4 = new short[1024];
        Poly.getNoise(sArray4, byArray, (byte)1);
        Poly.toNTT(sArray4);
        short[] sArray5 = new short[1024];
        Poly.pointWise(objectArray, objectArray2, sArray5);
        Poly.add(sArray5, sArray4, sArray5);
        short[] sArray6 = new short[1024];
        objectArray = sArray6;
        Poly.pointWise((short[])object, objectArray2, objectArray);
        Poly.fromNTT(sArray6);
        short[] sArray7 = new short[1024];
        object = sArray7;
        Poly.getNoise(sArray7, byArray, (byte)2);
        Poly.add(sArray6, (short[])object, objectArray);
        short[] sArray8 = new short[1024];
        object = sArray8;
        ErrorCorrection.helpRec(sArray8, objectArray, byArray, (byte)3);
        NewHope.encodeB(byArray2, sArray5, (short[])object);
        ErrorCorrection.rec(byArray, objectArray, (short[])object);
        NewHope.sha3(byArray);
    }

    public static void sharedA(byte[] objectArray, short[] sArray, byte[] objectArray2) {
        short[] sArray2 = new short[1024];
        objectArray = sArray2;
        short[] sArray3 = new short[1024];
        NewHope.decodeB(sArray2, sArray3, objectArray2);
        short[] sArray4 = new short[1024];
        objectArray2 = sArray4;
        Poly.pointWise(sArray, objectArray, objectArray2);
        Poly.fromNTT(sArray4);
        ErrorCorrection.rec(objectArray, objectArray2, sArray3);
        NewHope.sha3(objectArray);
    }

    public static void decodeA(short[] sArray, byte[] byArray, byte[] byArray2) {
        Poly.fromBytes(sArray, byArray2);
        System.arraycopy(byArray2, 1792, byArray, 0, 32);
    }

    public static void decodeB(short[] sArray, short[] sArray2, byte[] byArray) {
        Poly.fromBytes(sArray, byArray);
        int n3 = 0;
        while (n3 < 256) {
            int n4;
            int n5 = n3++;
            int n6 = n5 * 4;
            int n7 = byArray[n5 + 1792] & 0xFF;
            int n8 = n4 = n7;
            int n9 = n4;
            int n10 = n4;
            n4 = n6 + 0;
            sArray2[n4] = (short)(n10 & 3);
            n4 = n6 + 1;
            sArray2[n4] = (short)(n9 >>> 2 & 3);
            n4 = n6 + 2;
            sArray2[n4] = (short)(n8 >>> 4 & 3);
            sArray2[n6 += 3] = (short)(n7 >>> 6);
        }
    }

    public static void encodeA(byte[] byArray, short[] sArray, byte[] byArray2) {
        Poly.toBytes(byArray, sArray);
        System.arraycopy(byArray2, 0, byArray, 1792, 32);
    }

    public static void encodeB(byte[] byArray, short[] sArray, short[] sArray2) {
        Poly.toBytes(byArray, sArray);
        int n3 = 0;
        while (n3 < 256) {
            int n4 = n3++;
            int n5 = n4 * 4;
            int n6 = n4 + 1792;
            byArray[n6] = (byte)(sArray2[n5] | sArray2[n5 + 1] << 2 | sArray2[n5 + 2] << 4 | sArray2[n5 + 3] << 6);
        }
    }

    public static void generateA(short[] sArray, byte[] byArray) {
        Poly.uniform(sArray, byArray);
    }

    public static void sha3(byte[] byArray) {
        SHA3Digest sHA3Digest = new SHA3Digest(256);
        sHA3Digest.update(byArray, 0, 32);
        sHA3Digest.doFinal(byArray, 0);
    }
}

