/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.EncodableDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUEncryptionParameters;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;

public class NTRUEncryptionKeyGenerationParameters
extends KeyGenerationParameters
implements Cloneable {
    public static final NTRUEncryptionKeyGenerationParameters EES1087EP2;
    public static final NTRUEncryptionKeyGenerationParameters EES1171EP1;
    public static final NTRUEncryptionKeyGenerationParameters EES1499EP1;
    public static final NTRUEncryptionKeyGenerationParameters APR2011_439;
    public static final NTRUEncryptionKeyGenerationParameters APR2011_439_FAST;
    public static final NTRUEncryptionKeyGenerationParameters APR2011_743;
    public static final NTRUEncryptionKeyGenerationParameters APR2011_743_FAST;
    public int N;
    public int q;
    public int df;
    public int df1;
    public int df2;
    public int df3;
    public int dr;
    public int dr1;
    public int dr2;
    public int dr3;
    public int dg;
    public int llen;
    public int maxMsgLenBytes;
    public int db;
    public int bufferLenBits;
    public int bufferLenTrits;
    public int dm0;
    public int pkLen;
    public int c;
    public int minCallsR;
    public int minCallsMask;
    public boolean hashSeed;
    public byte[] oid;
    public boolean sparse;
    public boolean fastFp;
    public int polyType;
    public Digest hashAlg;

    public NTRUEncryptionKeyGenerationParameters(int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, byte[] byArray, boolean bl2, boolean bl3, Digest digest, SecureRandom secureRandom) {
        if (secureRandom == null) {
            secureRandom = CryptoServicesRegistrar.getSecureRandom();
        }
        NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters = this;
        super(secureRandom, n7);
        nTRUEncryptionKeyGenerationParameters.N = n3;
        nTRUEncryptionKeyGenerationParameters.q = n4;
        nTRUEncryptionKeyGenerationParameters.df = n5;
        nTRUEncryptionKeyGenerationParameters.db = n7;
        nTRUEncryptionKeyGenerationParameters.dm0 = n6;
        nTRUEncryptionKeyGenerationParameters.c = n8;
        nTRUEncryptionKeyGenerationParameters.minCallsR = n9;
        nTRUEncryptionKeyGenerationParameters.minCallsMask = n10;
        nTRUEncryptionKeyGenerationParameters.hashSeed = bl;
        nTRUEncryptionKeyGenerationParameters.oid = byArray;
        nTRUEncryptionKeyGenerationParameters.sparse = bl2;
        nTRUEncryptionKeyGenerationParameters.fastFp = bl3;
        nTRUEncryptionKeyGenerationParameters.polyType = 0;
        nTRUEncryptionKeyGenerationParameters.hashAlg = digest;
        nTRUEncryptionKeyGenerationParameters.init();
    }

    public NTRUEncryptionKeyGenerationParameters(int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, byte[] byArray, boolean bl2, boolean bl3, Digest digest) {
        this(n3, n4, n5, n6, n7, n8, n9, n10, bl, byArray, bl2, bl3, digest, null);
    }

    public NTRUEncryptionKeyGenerationParameters(int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl, byte[] byArray, boolean bl2, boolean bl3, Digest digest, SecureRandom secureRandom) {
        if (secureRandom == null) {
            secureRandom = CryptoServicesRegistrar.getSecureRandom();
        }
        NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters = this;
        super(secureRandom, n9);
        nTRUEncryptionKeyGenerationParameters.N = n3;
        nTRUEncryptionKeyGenerationParameters.q = n4;
        nTRUEncryptionKeyGenerationParameters.df1 = n5;
        nTRUEncryptionKeyGenerationParameters.df2 = n6;
        nTRUEncryptionKeyGenerationParameters.df3 = n7;
        nTRUEncryptionKeyGenerationParameters.db = n9;
        nTRUEncryptionKeyGenerationParameters.dm0 = n8;
        nTRUEncryptionKeyGenerationParameters.c = n10;
        nTRUEncryptionKeyGenerationParameters.minCallsR = n11;
        nTRUEncryptionKeyGenerationParameters.minCallsMask = n12;
        nTRUEncryptionKeyGenerationParameters.hashSeed = bl;
        nTRUEncryptionKeyGenerationParameters.oid = byArray;
        nTRUEncryptionKeyGenerationParameters.sparse = bl2;
        nTRUEncryptionKeyGenerationParameters.fastFp = bl3;
        nTRUEncryptionKeyGenerationParameters.polyType = 1;
        nTRUEncryptionKeyGenerationParameters.hashAlg = digest;
        nTRUEncryptionKeyGenerationParameters.init();
    }

    public NTRUEncryptionKeyGenerationParameters(int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl, byte[] byArray, boolean bl2, boolean bl3, Digest digest) {
        this(n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, bl, byArray, bl2, bl3, digest, null);
    }

    private void init() {
        NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters = this;
        nTRUEncryptionKeyGenerationParameters.dr = nTRUEncryptionKeyGenerationParameters.df;
        nTRUEncryptionKeyGenerationParameters.dr1 = nTRUEncryptionKeyGenerationParameters.df1;
        nTRUEncryptionKeyGenerationParameters.dr2 = nTRUEncryptionKeyGenerationParameters.df2;
        nTRUEncryptionKeyGenerationParameters.dr3 = nTRUEncryptionKeyGenerationParameters.df3;
        int n3 = nTRUEncryptionKeyGenerationParameters.N;
        NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters2 = this;
        nTRUEncryptionKeyGenerationParameters2.dg = n3 / 3;
        nTRUEncryptionKeyGenerationParameters2.llen = 1;
        int n4 = this.db;
        this.maxMsgLenBytes = n3 * 3 / 2 / 8 - 1 - n4 / 8 - 1;
        this.bufferLenBits = (n3 * 3 / 2 + 7) / 8 * 8 + 1;
        nTRUEncryptionKeyGenerationParameters.bufferLenTrits = n3 - 1;
        nTRUEncryptionKeyGenerationParameters.pkLen = n4;
    }

    public NTRUEncryptionKeyGenerationParameters(InputStream object) {
        super(CryptoServicesRegistrar.getSecureRandom(), -1);
        DataInputStream dataInputStream;
        DataInputStream dataInputStream2;
        DataInputStream dataInputStream3 = dataInputStream2 = dataInputStream;
        NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters = this;
        DataInputStream dataInputStream4 = dataInputStream2;
        dataInputStream4((InputStream)object);
        this.N = dataInputStream4.readInt();
        this.q = dataInputStream2.readInt();
        this.df = dataInputStream2.readInt();
        this.df1 = dataInputStream2.readInt();
        this.df2 = dataInputStream2.readInt();
        this.df3 = dataInputStream2.readInt();
        this.db = dataInputStream2.readInt();
        this.dm0 = dataInputStream2.readInt();
        this.c = dataInputStream2.readInt();
        this.minCallsR = dataInputStream2.readInt();
        this.minCallsMask = dataInputStream2.readInt();
        nTRUEncryptionKeyGenerationParameters.hashSeed = dataInputStream2.readBoolean();
        byte[] byArray = new byte[3];
        object = byArray;
        nTRUEncryptionKeyGenerationParameters.oid = byArray;
        dataInputStream3.readFully((byte[])object);
        this.sparse = dataInputStream3.readBoolean();
        this.fastFp = dataInputStream2.readBoolean();
        this.polyType = ((InputStream)dataInputStream2).read();
        object = dataInputStream.readUTF();
        if ("SHA-512".equals(object)) {
            SHA512Digest sHA512Digest;
            object = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            this.hashAlg = object;
        } else if ("SHA-256".equals(object)) {
            SHA256Digest sHA256Digest;
            object = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            this.hashAlg = object;
        }
        this.init();
    }

    static {
        SHA512Digest sHA512Digest;
        SHA512Digest sHA512Digest2;
        SHA256Digest sHA256Digest;
        SHA256Digest sHA256Digest2;
        SHA512Digest sHA512Digest3;
        SHA512Digest sHA512Digest4;
        SHA512Digest sHA512Digest5;
        byte[] byArray = new byte[3];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray[1] = 6;
        byArray[2] = 3;
        EncodableDigest encodableDigest = sHA512Digest5;
        sHA512Digest5 = new SHA512Digest();
        EES1087EP2 = new NTRUEncryptionKeyGenerationParameters(1087, 2048, 120, 120, 256, 13, 25, 14, true, byArray2, true, false, (Digest)((Object)encodableDigest));
        byte[] byArray3 = new byte[3];
        byArray2 = byArray3;
        byArray3[0] = 0;
        byArray3[1] = 6;
        byArray3[2] = 4;
        encodableDigest = sHA512Digest4;
        sHA512Digest4 = new SHA512Digest();
        EES1171EP1 = new NTRUEncryptionKeyGenerationParameters(1171, 2048, 106, 106, 256, 13, 20, 15, true, byArray2, true, false, (Digest)((Object)encodableDigest));
        byte[] byArray4 = new byte[3];
        byArray2 = byArray4;
        byArray4[0] = 0;
        byArray4[1] = 6;
        byArray4[2] = 5;
        encodableDigest = sHA512Digest3;
        sHA512Digest3 = new SHA512Digest();
        EES1499EP1 = new NTRUEncryptionKeyGenerationParameters(1499, 2048, 79, 79, 256, 13, 17, 19, true, byArray2, true, false, (Digest)((Object)encodableDigest));
        byte[] byArray5 = new byte[3];
        byArray2 = byArray5;
        byArray5[0] = 0;
        byArray5[1] = 7;
        byArray5[2] = 101;
        encodableDigest = sHA256Digest2;
        sHA256Digest2 = new SHA256Digest();
        APR2011_439 = new NTRUEncryptionKeyGenerationParameters(439, 2048, 146, 130, 128, 9, 32, 9, true, byArray2, true, false, (Digest)((Object)encodableDigest));
        byte[] byArray6 = new byte[3];
        byArray2 = byArray6;
        byArray6[0] = 0;
        byArray6[1] = 7;
        byArray6[2] = 101;
        encodableDigest = sHA256Digest;
        sHA256Digest = new SHA256Digest();
        APR2011_439_FAST = new NTRUEncryptionKeyGenerationParameters(439, 2048, 9, 8, 5, 130, 128, 9, 32, 9, true, byArray2, true, true, (Digest)((Object)encodableDigest));
        byte[] byArray7 = new byte[3];
        byArray2 = byArray7;
        byArray7[0] = 0;
        byArray7[1] = 7;
        byArray7[2] = 105;
        encodableDigest = sHA512Digest2;
        sHA512Digest2 = new SHA512Digest();
        APR2011_743 = new NTRUEncryptionKeyGenerationParameters(743, 2048, 248, 220, 256, 10, 27, 14, true, byArray2, false, false, (Digest)((Object)encodableDigest));
        byte[] byArray8 = new byte[3];
        byArray2 = byArray8;
        byArray8[0] = 0;
        byArray8[1] = 7;
        byArray8[2] = 105;
        encodableDigest = sHA512Digest;
        sHA512Digest = new SHA512Digest();
        APR2011_743_FAST = new NTRUEncryptionKeyGenerationParameters(743, 2048, 11, 11, 15, 220, 256, 10, 27, 14, true, byArray2, false, true, (Digest)((Object)encodableDigest));
    }

    public NTRUEncryptionParameters getEncryptionParameters() {
        if (this.polyType == 0) {
            NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters = this;
            int n3 = nTRUEncryptionKeyGenerationParameters.N;
            int n4 = nTRUEncryptionKeyGenerationParameters.q;
            int n5 = nTRUEncryptionKeyGenerationParameters.df;
            int n6 = nTRUEncryptionKeyGenerationParameters.dm0;
            int n7 = nTRUEncryptionKeyGenerationParameters.db;
            int n8 = nTRUEncryptionKeyGenerationParameters.c;
            int n9 = nTRUEncryptionKeyGenerationParameters.minCallsR;
            int n10 = nTRUEncryptionKeyGenerationParameters.minCallsMask;
            boolean bl = nTRUEncryptionKeyGenerationParameters.hashSeed;
            byte[] byArray = nTRUEncryptionKeyGenerationParameters.oid;
            boolean bl2 = nTRUEncryptionKeyGenerationParameters.sparse;
            boolean bl3 = nTRUEncryptionKeyGenerationParameters.fastFp;
            Digest digest = nTRUEncryptionKeyGenerationParameters.hashAlg;
            return new NTRUEncryptionParameters(n3, n4, n5, n6, n7, n8, n9, n10, bl, byArray, bl2, bl3, digest);
        }
        NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters = this;
        int n11 = nTRUEncryptionKeyGenerationParameters.N;
        int n12 = nTRUEncryptionKeyGenerationParameters.q;
        int n13 = nTRUEncryptionKeyGenerationParameters.df1;
        int n14 = nTRUEncryptionKeyGenerationParameters.df2;
        int n15 = nTRUEncryptionKeyGenerationParameters.df3;
        int n16 = nTRUEncryptionKeyGenerationParameters.dm0;
        int n17 = nTRUEncryptionKeyGenerationParameters.db;
        int n18 = nTRUEncryptionKeyGenerationParameters.c;
        int n19 = nTRUEncryptionKeyGenerationParameters.minCallsR;
        int n20 = nTRUEncryptionKeyGenerationParameters.minCallsMask;
        boolean bl = nTRUEncryptionKeyGenerationParameters.hashSeed;
        byte[] byArray = nTRUEncryptionKeyGenerationParameters.oid;
        boolean bl4 = nTRUEncryptionKeyGenerationParameters.sparse;
        boolean bl5 = nTRUEncryptionKeyGenerationParameters.fastFp;
        Digest digest = nTRUEncryptionKeyGenerationParameters.hashAlg;
        return new NTRUEncryptionParameters(n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, bl, byArray, bl4, bl5, digest);
    }

    public NTRUEncryptionKeyGenerationParameters clone() {
        if (this.polyType == 0) {
            NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters = this;
            int n3 = nTRUEncryptionKeyGenerationParameters.N;
            int n4 = nTRUEncryptionKeyGenerationParameters.q;
            int n5 = nTRUEncryptionKeyGenerationParameters.df;
            int n6 = nTRUEncryptionKeyGenerationParameters.dm0;
            int n7 = nTRUEncryptionKeyGenerationParameters.db;
            int n8 = nTRUEncryptionKeyGenerationParameters.c;
            int n9 = nTRUEncryptionKeyGenerationParameters.minCallsR;
            int n10 = nTRUEncryptionKeyGenerationParameters.minCallsMask;
            boolean bl = nTRUEncryptionKeyGenerationParameters.hashSeed;
            byte[] byArray = nTRUEncryptionKeyGenerationParameters.oid;
            boolean bl2 = nTRUEncryptionKeyGenerationParameters.sparse;
            boolean bl3 = nTRUEncryptionKeyGenerationParameters.fastFp;
            Digest digest = nTRUEncryptionKeyGenerationParameters.hashAlg;
            return new NTRUEncryptionKeyGenerationParameters(n3, n4, n5, n6, n7, n8, n9, n10, bl, byArray, bl2, bl3, digest);
        }
        NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters = this;
        int n11 = nTRUEncryptionKeyGenerationParameters.N;
        int n12 = nTRUEncryptionKeyGenerationParameters.q;
        int n13 = nTRUEncryptionKeyGenerationParameters.df1;
        int n14 = nTRUEncryptionKeyGenerationParameters.df2;
        int n15 = nTRUEncryptionKeyGenerationParameters.df3;
        int n16 = nTRUEncryptionKeyGenerationParameters.dm0;
        int n17 = nTRUEncryptionKeyGenerationParameters.db;
        int n18 = nTRUEncryptionKeyGenerationParameters.c;
        int n19 = nTRUEncryptionKeyGenerationParameters.minCallsR;
        int n20 = nTRUEncryptionKeyGenerationParameters.minCallsMask;
        boolean bl = nTRUEncryptionKeyGenerationParameters.hashSeed;
        byte[] byArray = nTRUEncryptionKeyGenerationParameters.oid;
        boolean bl4 = nTRUEncryptionKeyGenerationParameters.sparse;
        boolean bl5 = nTRUEncryptionKeyGenerationParameters.fastFp;
        Digest digest = nTRUEncryptionKeyGenerationParameters.hashAlg;
        return new NTRUEncryptionKeyGenerationParameters(n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, bl, byArray, bl4, bl5, digest);
    }

    public int getMaxMessageLength() {
        return this.maxMsgLenBytes;
    }

    public void writeTo(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream2(outputStream);
        dataOutputStream2.writeInt(this.N);
        dataOutputStream2.writeInt(this.q);
        dataOutputStream2.writeInt(this.df);
        dataOutputStream2.writeInt(this.df1);
        dataOutputStream2.writeInt(this.df2);
        dataOutputStream2.writeInt(this.df3);
        dataOutputStream2.writeInt(this.db);
        dataOutputStream2.writeInt(this.dm0);
        dataOutputStream2.writeInt(this.c);
        dataOutputStream2.writeInt(this.minCallsR);
        dataOutputStream2.writeInt(this.minCallsMask);
        dataOutputStream2.writeBoolean(this.hashSeed);
        ((OutputStream)dataOutputStream2).write(this.oid);
        dataOutputStream2.writeBoolean(this.sparse);
        dataOutputStream2.writeBoolean(this.fastFp);
        dataOutputStream2.write(this.polyType);
        dataOutputStream.writeUTF(this.hashAlg.getAlgorithmName());
    }

    public int hashCode() {
        NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters = this;
        int n3 = (((((((((((((((31 + nTRUEncryptionKeyGenerationParameters.N) * 31 + this.bufferLenBits) * 31 + this.bufferLenTrits) * 31 + this.c) * 31 + this.db) * 31 + this.df) * 31 + this.df1) * 31 + this.df2) * 31 + this.df3) * 31 + this.dg) * 31 + this.dm0) * 31 + this.dr) * 31 + this.dr1) * 31 + this.dr2) * 31 + this.dr3) * 31;
        int n4 = nTRUEncryptionKeyGenerationParameters.fastFp ? 1231 : 1237;
        n3 = (n3 + n4) * 31;
        Digest digest = this.hashAlg;
        int n5 = digest == null ? 0 : digest.getAlgorithmName().hashCode();
        n3 = (n3 + n5) * 31;
        n5 = this.hashSeed ? 1231 : 1237;
        NTRUEncryptionKeyGenerationParameters nTRUEncryptionKeyGenerationParameters2 = this;
        n3 = (((((n3 + n5) * 31 + this.llen) * 31 + this.maxMsgLenBytes) * 31 + this.minCallsMask) * 31 + this.minCallsR) * 31;
        int n6 = ((((Arrays.hashCode(nTRUEncryptionKeyGenerationParameters2.oid) + n3) * 31 + this.pkLen) * 31 + this.polyType) * 31 + this.q) * 31;
        n3 = nTRUEncryptionKeyGenerationParameters2.sparse ? 1231 : 1237;
        return n6 + n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (NTRUEncryptionKeyGenerationParameters)object;
        if (this.N != ((NTRUEncryptionKeyGenerationParameters)object).N) {
            return false;
        }
        if (this.bufferLenBits != ((NTRUEncryptionKeyGenerationParameters)object).bufferLenBits) {
            return false;
        }
        if (this.bufferLenTrits != ((NTRUEncryptionKeyGenerationParameters)object).bufferLenTrits) {
            return false;
        }
        if (this.c != ((NTRUEncryptionKeyGenerationParameters)object).c) {
            return false;
        }
        if (this.db != ((NTRUEncryptionKeyGenerationParameters)object).db) {
            return false;
        }
        if (this.df != ((NTRUEncryptionKeyGenerationParameters)object).df) {
            return false;
        }
        if (this.df1 != ((NTRUEncryptionKeyGenerationParameters)object).df1) {
            return false;
        }
        if (this.df2 != ((NTRUEncryptionKeyGenerationParameters)object).df2) {
            return false;
        }
        if (this.df3 != ((NTRUEncryptionKeyGenerationParameters)object).df3) {
            return false;
        }
        if (this.dg != ((NTRUEncryptionKeyGenerationParameters)object).dg) {
            return false;
        }
        if (this.dm0 != ((NTRUEncryptionKeyGenerationParameters)object).dm0) {
            return false;
        }
        if (this.dr != ((NTRUEncryptionKeyGenerationParameters)object).dr) {
            return false;
        }
        if (this.dr1 != ((NTRUEncryptionKeyGenerationParameters)object).dr1) {
            return false;
        }
        if (this.dr2 != ((NTRUEncryptionKeyGenerationParameters)object).dr2) {
            return false;
        }
        if (this.dr3 != ((NTRUEncryptionKeyGenerationParameters)object).dr3) {
            return false;
        }
        if (this.fastFp != ((NTRUEncryptionKeyGenerationParameters)object).fastFp) {
            return false;
        }
        Digest digest = this.hashAlg;
        if (digest == null ? ((NTRUEncryptionKeyGenerationParameters)object).hashAlg != null : !digest.getAlgorithmName().equals(((NTRUEncryptionKeyGenerationParameters)object).hashAlg.getAlgorithmName())) {
            return false;
        }
        if (this.hashSeed != ((NTRUEncryptionKeyGenerationParameters)object).hashSeed) {
            return false;
        }
        if (this.llen != ((NTRUEncryptionKeyGenerationParameters)object).llen) {
            return false;
        }
        if (this.maxMsgLenBytes != ((NTRUEncryptionKeyGenerationParameters)object).maxMsgLenBytes) {
            return false;
        }
        if (this.minCallsMask != ((NTRUEncryptionKeyGenerationParameters)object).minCallsMask) {
            return false;
        }
        if (this.minCallsR != ((NTRUEncryptionKeyGenerationParameters)object).minCallsR) {
            return false;
        }
        if (!Arrays.equals(this.oid, ((NTRUEncryptionKeyGenerationParameters)object).oid)) {
            return false;
        }
        if (this.pkLen != ((NTRUEncryptionKeyGenerationParameters)object).pkLen) {
            return false;
        }
        if (this.polyType != ((NTRUEncryptionKeyGenerationParameters)object).polyType) {
            return false;
        }
        if (this.q != ((NTRUEncryptionKeyGenerationParameters)object).q) {
            return false;
        }
        return this.sparse == ((NTRUEncryptionKeyGenerationParameters)object).sparse;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(b.a("EncryptionParameters(N=").append(this.N).append(" q=").append(this.q).toString());
        if (this.polyType == 0) {
            stringBuilder2.append(b.a(" polyType=SIMPLE df=").append(this.df).toString());
        } else {
            stringBuilder2.append(b.a(" polyType=PRODUCT df1=").append(this.df1).append(" df2=").append(this.df2).append(" df3=").append(this.df3).toString());
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(b.a(" dm0=").append(this.dm0).append(" db=").append(this.db).append(" c=").append(this.c).append(" minCallsR=").append(this.minCallsR).append(" minCallsMask=").append(this.minCallsMask).append(" hashSeed=").append(this.hashSeed).append(" hashAlg=").append(this.hashAlg).append(" oid=").append(Arrays.toString(this.oid)).append(" sparse=").append(this.sparse).append(")").toString());
        return stringBuilder3.toString();
    }
}

