/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUEncryptionKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUEncryptionParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class NTRUEncryptionPrivateKeyParameters
extends NTRUEncryptionKeyParameters {
    public Polynomial t;
    public IntegerPolynomial fp;
    public IntegerPolynomial h;

    public NTRUEncryptionPrivateKeyParameters(IntegerPolynomial integerPolynomial, Polynomial polynomial, IntegerPolynomial integerPolynomial2, NTRUEncryptionParameters nTRUEncryptionParameters) {
        super(true, nTRUEncryptionParameters);
        this.h = integerPolynomial;
        this.t = polynomial;
        this.fp = integerPolynomial2;
    }

    public NTRUEncryptionPrivateKeyParameters(byte[] byArray, NTRUEncryptionParameters nTRUEncryptionParameters) {
        ByteArrayInputStream byteArrayInputStream;
        NTRUEncryptionPrivateKeyParameters nTRUEncryptionPrivateKeyParameters = byteArrayInputStream2;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        nTRUEncryptionPrivateKeyParameters(byteArrayInputStream2, nTRUEncryptionParameters);
    }

    public NTRUEncryptionPrivateKeyParameters(InputStream inputStream, NTRUEncryptionParameters object) {
        super(true, (NTRUEncryptionParameters)object);
        if (((NTRUEncryptionParameters)object).polyType == 1) {
            NTRUEncryptionParameters nTRUEncryptionParameters = object;
            int n3 = nTRUEncryptionParameters.N;
            int n4 = nTRUEncryptionParameters.df1;
            int n5 = nTRUEncryptionParameters.df2;
            int n6 = nTRUEncryptionParameters.df3;
            int n7 = nTRUEncryptionParameters.fastFp ? n6 : n6 - 1;
            this.h = IntegerPolynomial.fromBinary(inputStream, n3, ((NTRUEncryptionParameters)object).q);
            this.t = ProductFormPolynomial.fromBinary(inputStream, n3, n4, n5, n6, n7);
        } else {
            NTRUEncryptionParameters nTRUEncryptionParameters = object;
            int n8 = nTRUEncryptionParameters.N;
            this.h = IntegerPolynomial.fromBinary(inputStream, n8, nTRUEncryptionParameters.q);
            IntegerPolynomial integerPolynomial = IntegerPolynomial.fromBinary3Tight(inputStream, ((NTRUEncryptionParameters)object).N);
            if (((NTRUEncryptionParameters)object).sparse) {
                SparseTernaryPolynomial sparseTernaryPolynomial;
                object = sparseTernaryPolynomial;
                sparseTernaryPolynomial = new SparseTernaryPolynomial(integerPolynomial);
            } else {
                DenseTernaryPolynomial denseTernaryPolynomial;
                object = denseTernaryPolynomial;
                denseTernaryPolynomial = new DenseTernaryPolynomial(integerPolynomial);
            }
            this.t = object;
        }
        this.init();
    }

    private void init() {
        if (this.params.fastFp) {
            IntegerPolynomial integerPolynomial;
            IntegerPolynomial integerPolynomial2 = integerPolynomial;
            this.fp = new IntegerPolynomial(this.params.N);
            integerPolynomial2.coeffs[0] = 1;
        } else {
            this.fp = this.t.toIntegerPolynomial().invertF3();
        }
    }

    public byte[] getEncoded() {
        NTRUEncryptionPrivateKeyParameters nTRUEncryptionPrivateKeyParameters = object;
        Object object = nTRUEncryptionPrivateKeyParameters.h.toBinary(((NTRUEncryptionKeyParameters)object).params.q);
        Object object2 = nTRUEncryptionPrivateKeyParameters.t;
        object2 = object2 instanceof ProductFormPolynomial ? (Object)((ProductFormPolynomial)object2).toBinary() : (Object)object2.toIntegerPolynomial().toBinary3Tight();
        byte[] byArray = new byte[((Object)object).length + ((Object)object2).length];
        Object object3 = object2;
        Object object4 = object;
        int n3 = ((Object)object4).length;
        System.arraycopy(object4, 0, byArray, 0, n3);
        n3 = ((Object)object4).length;
        int n4 = ((Object)object3).length;
        System.arraycopy(object3, 0, byArray, n3, n4);
        return byArray;
    }

    public void writeTo(OutputStream outputStream) {
        outputStream.write(this.getEncoded());
    }

    public int hashCode() {
        int n3 = 31;
        NTRUEncryptionParameters nTRUEncryptionParameters = this.params;
        int n4 = nTRUEncryptionParameters == null ? 0 : nTRUEncryptionParameters.hashCode();
        n3 = (n3 + n4) * 31;
        Polynomial polynomial = this.t;
        int n5 = polynomial == null ? 0 : polynomial.hashCode();
        int n6 = (n3 + n5) * 31;
        IntegerPolynomial integerPolynomial = this.h;
        int n7 = integerPolynomial == null ? 0 : integerPolynomial.hashCode();
        return n6 + n7;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof NTRUEncryptionPrivateKeyParameters)) {
            return false;
        }
        object = (NTRUEncryptionPrivateKeyParameters)object;
        Object object2 = this.params;
        if (object2 == null ? ((NTRUEncryptionKeyParameters)object).params != null : !((NTRUEncryptionParameters)object2).equals(((NTRUEncryptionKeyParameters)object).params)) {
            return false;
        }
        object2 = this.t;
        if (object2 == null ? ((NTRUEncryptionPrivateKeyParameters)object).t != null : !object2.equals(((NTRUEncryptionPrivateKeyParameters)object).t)) {
            return false;
        }
        return this.h.equals(((NTRUEncryptionPrivateKeyParameters)object).h);
    }
}

