/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.IndexGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUEncryptionParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class NTRUEngine
implements AsymmetricBlockCipher {
    private boolean forEncryption;
    private NTRUEncryptionParameters params;
    private NTRUEncryptionPublicKeyParameters pubKey;
    private NTRUEncryptionPrivateKeyParameters privKey;
    private SecureRandom random;

    private byte[] encrypt(byte[] byArray, NTRUEncryptionPublicKeyParameters object) {
        object = ((NTRUEncryptionPublicKeyParameters)object).h;
        NTRUEncryptionParameters nTRUEncryptionParameters = this.params;
        int n3 = nTRUEncryptionParameters.N;
        int n4 = nTRUEncryptionParameters.q;
        int n5 = nTRUEncryptionParameters.maxMsgLenBytes;
        NTRUEncryptionParameters nTRUEncryptionParameters2 = nTRUEncryptionParameters;
        int n6 = nTRUEncryptionParameters2.db;
        int n7 = nTRUEncryptionParameters2.bufferLenBits;
        int n8 = nTRUEncryptionParameters2.dm0;
        int n9 = nTRUEncryptionParameters2.pkLen;
        int n10 = nTRUEncryptionParameters2.minCallsMask;
        boolean bl = nTRUEncryptionParameters2.hashSeed;
        byte[] byArray2 = nTRUEncryptionParameters2.oid;
        int n11 = byArray.length;
        if (n5 <= 255) {
            if (n11 <= n5) {
                Object object2;
                IntegerPolynomial integerPolynomial;
                do {
                    int n12 = n6 / 8;
                    object2 = new byte[n12];
                    this.random.nextBytes((byte[])object2);
                    int n13 = n5 + 1 - n11;
                    byte[] byArray3 = new byte[n13];
                    byte[] byArray4 = new byte[n7 / 8];
                    System.arraycopy(object2, 0, byArray4, 0, n12);
                    byArray4[n12] = (byte)n11;
                    int n14 = byArray.length;
                    System.arraycopy(byArray, 0, byArray4, ++n12, n14);
                    System.arraycopy(byArray3, 0, byArray4, n12 += byArray.length, n13);
                    integerPolynomial = IntegerPolynomial.fromBinary3Sves(byArray4, n3);
                    NTRUEngine nTRUEngine = this;
                    byte[] byArray5 = ((IntegerPolynomial)object).toBinary(n4);
                    byArray5 = this.copyOf(byArray5, n9 / 8);
                    IntegerPolynomial integerPolynomial2 = nTRUEngine.generateBlindingPoly(nTRUEngine.buildSData(byArray2, byArray, n11, (byte[])object2, byArray5), byArray4).mult((IntegerPolynomial)object, n4);
                    object2 = integerPolynomial2;
                    IntegerPolynomial integerPolynomial3 = (IntegerPolynomial)integerPolynomial2.clone();
                    integerPolynomial3.modPositive(4);
                    integerPolynomial.add(nTRUEngine.MGF(integerPolynomial3.toBinary(4), n3, n10, bl));
                    integerPolynomial.mod3();
                } while (integerPolynomial.count(-1) < n8 || integerPolynomial.count(0) < n8 || integerPolynomial.count(1) < n8);
                ((IntegerPolynomial)object2).add(integerPolynomial, n4);
                ((IntegerPolynomial)object2).ensurePositive(n4);
                return ((IntegerPolynomial)object2).toBinary(n4);
            }
            throw new DataLengthException("Message too long: " + n11 + ">" + n5);
        }
        throw new IllegalArgumentException("llen values bigger than 1 are not supported");
    }

    private byte[] buildSData(byte[] byArray, byte[] byArray2, int n3, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[byArray.length + n3 + byArray3.length + byArray4.length];
        Object object = byArray5;
        int n4 = byArray.length;
        System.arraycopy(byArray, 0, object, 0, n4);
        n4 = byArray.length;
        n3 = byArray2.length;
        System.arraycopy(byArray2, 0, object, n4, n3);
        n4 = byArray.length + byArray2.length;
        n3 = byArray3.length;
        System.arraycopy(byArray3, 0, object, n4, n3);
        n4 = byArray.length + byArray2.length + byArray3.length;
        int n5 = byArray4.length;
        System.arraycopy(byArray4, 0, object, n4, n5);
        return byArray5;
    }

    private Polynomial generateBlindingPoly(byte[] object, byte[] object2) {
        IndexGenerator indexGenerator;
        object2 = indexGenerator;
        indexGenerator = new IndexGenerator((byte[])object, ((NTRUEngine)object3).params);
        NTRUEncryptionParameters nTRUEncryptionParameters = ((NTRUEngine)object3).params;
        object = nTRUEncryptionParameters;
        if (nTRUEncryptionParameters.polyType == 1) {
            SparseTernaryPolynomial sparseTernaryPolynomial;
            SparseTernaryPolynomial sparseTernaryPolynomial2;
            SparseTernaryPolynomial sparseTernaryPolynomial3;
            SparseTernaryPolynomial sparseTernaryPolynomial4 = sparseTernaryPolynomial3;
            sparseTernaryPolynomial3 = new SparseTernaryPolynomial(((NTRUEngine)object3).generateBlindingCoeffs((IndexGenerator)object2, object.dr1));
            object = sparseTernaryPolynomial2;
            sparseTernaryPolynomial2 = new SparseTernaryPolynomial(super.generateBlindingCoeffs((IndexGenerator)object2, ((NTRUEngine)object3).params.dr2));
            SparseTernaryPolynomial sparseTernaryPolynomial5 = sparseTernaryPolynomial;
            sparseTernaryPolynomial = new SparseTernaryPolynomial(super.generateBlindingCoeffs((IndexGenerator)object2, ((NTRUEngine)object3).params.dr3));
            return new ProductFormPolynomial(sparseTernaryPolynomial4, (SparseTernaryPolynomial)object, sparseTernaryPolynomial5);
        }
        int n3 = object.dr;
        Object object3 = ((NTRUEngine)object3).generateBlindingCoeffs((IndexGenerator)object2, n3);
        if (object.sparse) {
            return new SparseTernaryPolynomial((int[])object3);
        }
        return new DenseTernaryPolynomial((int[])object3);
    }

    private int[] generateBlindingCoeffs(IndexGenerator indexGenerator, int n3) {
        Object object = new int[((NTRUEngine)object).params.N];
        for (int i3 = -1; i3 <= 1; i3 += 2) {
            int n4 = 0;
            while (n4 < n3) {
                int n5 = indexGenerator.nextIndex();
                if (object[n5] != false) continue;
                object[n5] = i3;
                ++n4;
            }
        }
        return object;
    }

    private IntegerPolynomial MGF(byte[] byArray, int n3, int n4, boolean bl) {
        IntegerPolynomial integerPolynomial;
        int n5;
        int n6;
        Digest digest = this.params.hashAlg;
        int n7 = digest.getDigestSize();
        byte[] byArray2 = new byte[n4 * n7];
        if (bl) {
            byArray = this.calcHash(digest, byArray);
        }
        for (n6 = 0; n6 < n4; ++n6) {
            Digest digest2 = digest;
            digest2.update(byArray, 0, byArray.length);
            this.putInt(digest2, n6);
            n5 = n6 * n7;
            System.arraycopy(this.calcHash(digest), 0, byArray2, n5, n7);
        }
        IntegerPolynomial integerPolynomial2 = integerPolynomial;
        integerPolynomial = new IntegerPolynomial(n3);
        while (true) {
            n7 = 0;
            for (n5 = 0; n5 != byArray2.length; ++n5) {
                int n8 = byArray2[n5] & 0xFF;
                if (n8 >= 243) continue;
                for (int i3 = 0; i3 < 4; ++i3) {
                    int n9 = n8 % 3;
                    integerPolynomial2.coeffs[n7] = n9 - 1;
                    if (++n7 == n3) {
                        return integerPolynomial2;
                    }
                    n8 = (n8 - n9) / 3;
                }
                integerPolynomial2.coeffs[n7] = n8 - 1;
                if (++n7 != n3) continue;
                return integerPolynomial2;
            }
            if (n7 >= n3) {
                return integerPolynomial2;
            }
            NTRUEngine nTRUEngine = this;
            n7 = byArray.length;
            digest.update(byArray, 0, n7);
            nTRUEngine.putInt(digest, n6);
            byArray2 = nTRUEngine.calcHash(digest);
            ++n6;
        }
    }

    private void putInt(Digest digest, int n3) {
        digest.update((byte)(n3 >> 24));
        digest.update((byte)(n3 >> 16));
        digest.update((byte)(n3 >> 8));
        digest.update((byte)n3);
    }

    private byte[] calcHash(Digest digest) {
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        return byArray;
    }

    private byte[] calcHash(Digest digest, byte[] byArray) {
        byte[] byArray2 = new byte[digest.getDigestSize()];
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, 0);
        return byArray2;
    }

    private byte[] decrypt(byte[] byArray, NTRUEncryptionPrivateKeyParameters object) {
        NTRUEncryptionPrivateKeyParameters nTRUEncryptionPrivateKeyParameters = object;
        object = nTRUEncryptionPrivateKeyParameters.t;
        IntegerPolynomial integerPolynomial = nTRUEncryptionPrivateKeyParameters.fp;
        IntegerPolynomial integerPolynomial2 = nTRUEncryptionPrivateKeyParameters.h;
        NTRUEncryptionParameters nTRUEncryptionParameters = ((NTRUEngine)object5).params;
        int n3 = nTRUEncryptionParameters.N;
        int n4 = nTRUEncryptionParameters.q;
        int n5 = nTRUEncryptionParameters.db;
        int n6 = nTRUEncryptionParameters.maxMsgLenBytes;
        NTRUEncryptionParameters nTRUEncryptionParameters2 = nTRUEncryptionParameters;
        int n7 = nTRUEncryptionParameters2.dm0;
        int n8 = nTRUEncryptionParameters2.pkLen;
        int n9 = nTRUEncryptionParameters2.minCallsMask;
        boolean bl = nTRUEncryptionParameters2.hashSeed;
        byte[] byArray2 = nTRUEncryptionParameters2.oid;
        if (n6 <= 255) {
            int n10 = n5 / 8;
            Object object2 = IntegerPolynomial.fromBinary(byArray, n3, n4);
            object = ((NTRUEngine)object5).decrypt((IntegerPolynomial)object2, (Polynomial)object, integerPolynomial);
            if (((IntegerPolynomial)object).count(-1) >= n7) {
                if (((IntegerPolynomial)object).count(0) >= n7) {
                    if (((IntegerPolynomial)object).count(1) >= n7) {
                        Object object3 = object;
                        integerPolynomial = (IntegerPolynomial)((IntegerPolynomial)object2).clone();
                        integerPolynomial.sub((IntegerPolynomial)object);
                        integerPolynomial.modPositive(n4);
                        IntegerPolynomial integerPolynomial3 = (IntegerPolynomial)integerPolynomial.clone();
                        integerPolynomial3.modPositive(4);
                        ((IntegerPolynomial)object3).sub(((NTRUEngine)object5).MGF(integerPolynomial3.toBinary(4), n3, n9, bl));
                        ((IntegerPolynomial)object3).mod3();
                        byte[] byArray3 = ((IntegerPolynomial)object3).toBinary3Sves();
                        object = byArray3;
                        byte[] byArray4 = new byte[n10];
                        System.arraycopy(object, 0, byArray4, 0, n10);
                        n3 = byArray3[n10] & 0xFF;
                        if (n3 <= n6) {
                            Object object4 = object;
                            object2 = new byte[n3];
                            System.arraycopy(object4, ++n10, object2, 0, n3);
                            n6 = ((Object)object4).length - (n10 += n3);
                            byte[] byArray5 = new byte[n6];
                            System.arraycopy(object, n10, byArray5, 0, n6);
                            if (Arrays.constantTimeAreEqual(byArray5, new byte[n6])) {
                                NTRUEngine nTRUEngine = object5;
                                NTRUEngine nTRUEngine2 = object5;
                                Object object5 = integerPolynomial2.toBinary(n4);
                                object5 = nTRUEngine2.copyOf((byte[])object5, n8 / 8);
                                IntegerPolynomial integerPolynomial4 = nTRUEngine.generateBlindingPoly(nTRUEngine.buildSData(byArray2, (byte[])object2, n3, byArray4, (byte[])object5), (byte[])object2).mult(integerPolynomial2);
                                integerPolynomial4.modPositive(n4);
                                if (integerPolynomial4.equals(integerPolynomial)) {
                                    return object2;
                                }
                                throw new InvalidCipherTextException("Invalid message encoding");
                            }
                            throw new InvalidCipherTextException("The message is not followed by zeroes");
                        }
                        throw new InvalidCipherTextException("Message too long: " + n3 + ">" + n6);
                    }
                    throw new InvalidCipherTextException("Less than dm0 coefficients equal 1");
                }
                throw new InvalidCipherTextException("Less than dm0 coefficients equal 0");
            }
            throw new InvalidCipherTextException("Less than dm0 coefficients equal -1");
        }
        throw new DataLengthException("maxMsgLenBytes values bigger than 255 are not supported");
    }

    private byte[] copyOf(byte[] byArray, int n3) {
        Object object = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        if (n3 >= byArray.length) {
            n3 = byArray.length;
        }
        System.arraycopy(byArray, n4, object, n5, n3);
        return object;
    }

    private int log2(int n3) {
        if (n3 == 2048) {
            return 11;
        }
        throw new IllegalStateException("log2 not fully implemented");
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        ((NTRUEngine)((Object)nTRUEncryptionPrivateKeyParameters)).forEncryption = bl;
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                NTRUEngine nTRUEngine = nTRUEncryptionPrivateKeyParameters;
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                nTRUEngine.random = parametersWithRandom.getRandom();
                nTRUEngine.pubKey = (NTRUEncryptionPublicKeyParameters)parametersWithRandom.getParameters();
            } else {
                ((NTRUEngine)((Object)nTRUEncryptionPrivateKeyParameters)).random = CryptoServicesRegistrar.getSecureRandom();
                ((NTRUEngine)((Object)nTRUEncryptionPrivateKeyParameters)).pubKey = (NTRUEncryptionPublicKeyParameters)cipherParameters;
            }
            ((NTRUEngine)((Object)nTRUEncryptionPrivateKeyParameters)).params = ((NTRUEngine)((Object)nTRUEncryptionPrivateKeyParameters)).pubKey.getParameters();
        } else {
            NTRUEngine nTRUEngine = nTRUEncryptionPrivateKeyParameters;
            NTRUEncryptionPrivateKeyParameters nTRUEncryptionPrivateKeyParameters = (NTRUEncryptionPrivateKeyParameters)cipherParameters;
            nTRUEngine.privKey = nTRUEncryptionPrivateKeyParameters;
            nTRUEngine.params = nTRUEncryptionPrivateKeyParameters.getParameters();
        }
    }

    @Override
    public int getInputBlockSize() {
        return this.params.maxMsgLenBytes;
    }

    @Override
    public int getOutputBlockSize() {
        NTRUEncryptionParameters nTRUEncryptionParameters = this.params;
        return (nTRUEncryptionParameters.N * this.log2(nTRUEncryptionParameters.q) + 7) / 8;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n3, int n4) {
        byte[] byArray2 = byArray;
        byArray = new byte[n4];
        System.arraycopy(byArray2, n3, byArray, 0, n4);
        if (this.forEncryption) {
            return this.encrypt(byArray, this.pubKey);
        }
        return this.decrypt(byArray, this.privKey);
    }

    public IntegerPolynomial encrypt(IntegerPolynomial integerPolynomial, TernaryPolynomial ternaryPolynomial, IntegerPolynomial integerPolynomial2) {
        IntegerPolynomial integerPolynomial3 = ternaryPolynomial.mult(integerPolynomial2, this.params.q);
        integerPolynomial3.add(integerPolynomial, this.params.q);
        integerPolynomial3.ensurePositive(this.params.q);
        return integerPolynomial3;
    }

    public IntegerPolynomial decrypt(IntegerPolynomial integerPolynomial, Polynomial polynomial, IntegerPolynomial integerPolynomial2) {
        NTRUEncryptionParameters nTRUEncryptionParameters = this.params;
        if (nTRUEncryptionParameters.fastFp) {
            polynomial = polynomial.mult(integerPolynomial, nTRUEncryptionParameters.q);
            ((IntegerPolynomial)polynomial).mult(3);
            ((IntegerPolynomial)polynomial).add(integerPolynomial);
        } else {
            polynomial = polynomial.mult(integerPolynomial, nTRUEncryptionParameters.q);
        }
        Polynomial polynomial2 = polynomial;
        ((IntegerPolynomial)polynomial2).center0(this.params.q);
        ((IntegerPolynomial)polynomial2).mod3();
        if (!this.params.fastFp) {
            polynomial = new DenseTernaryPolynomial((IntegerPolynomial)polynomial).mult(integerPolynomial2, 3);
        }
        Polynomial polynomial3 = polynomial;
        ((IntegerPolynomial)polynomial3).center0(3);
        return polynomial3;
    }
}

