/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.euclid.BigIntEuclidean;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigDecimalPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Resultant;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NTRUSigningKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUSigningKeyGenerationParameters params;

    private void minimizeFG(IntegerPolynomial integerPolynomial, IntegerPolynomial integerPolynomial2, IntegerPolynomial integerPolynomial3, IntegerPolynomial integerPolynomial4, int n3) {
        int n4;
        int n5 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6 = n3 * 2;
            int n7 = integerPolynomial.coeffs[i3];
            n4 = n7 * n7;
            int n8 = integerPolynomial2.coeffs[i3];
            n5 = (n8 * n8 + n4) * n6 + n5;
        }
        n5 -= 4;
        IntegerPolynomial integerPolynomial5 = (IntegerPolynomial)integerPolynomial.clone();
        IntegerPolynomial integerPolynomial6 = (IntegerPolynomial)integerPolynomial2.clone();
        int n9 = 0;
        for (n4 = 0; n9 < n3 && n4 < n3; ++n4) {
            int n10 = 0;
            for (int i4 = 0; i4 < n3; ++i4) {
                int n11 = integerPolynomial4.coeffs[i4] * integerPolynomial2.coeffs[i4];
                int n12 = n3 * 4;
                n10 = (integerPolynomial3.coeffs[i4] * integerPolynomial.coeffs[i4] + n11) * n12 + n10;
            }
            int n13 = n10;
            n10 = integerPolynomial3.sumCoeffs();
            n10 = n13 - (integerPolynomial4.sumCoeffs() + n10) * 4;
            if (n10 > n5) {
                integerPolynomial3.sub(integerPolynomial5);
                integerPolynomial4.sub(integerPolynomial6);
                n4 = n9 + 1;
                int n14 = n9 = 0;
                n9 = n4;
                n4 = n14;
            } else if (n10 < -n5) {
                integerPolynomial3.add(integerPolynomial5);
                integerPolynomial4.add(integerPolynomial6);
                n4 = n9 + 1;
                int n15 = n9 = 0;
                n9 = n4;
                n4 = n15;
            }
            integerPolynomial5.rotate1();
            integerPolynomial6.rotate1();
        }
    }

    private FGBasis generateBasis() {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        Object object;
        BigIntEuclidean bigIntEuclidean;
        Resultant resultant;
        Object object2;
        Object object3;
        Polynomial polynomial;
        IntegerPolynomial integerPolynomial4;
        Object object4;
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = this.params;
        int n3 = nTRUSigningKeyGenerationParameters.N;
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters2 = nTRUSigningKeyGenerationParameters;
        int n4 = nTRUSigningKeyGenerationParameters2.q;
        int n5 = nTRUSigningKeyGenerationParameters2.d;
        int n6 = nTRUSigningKeyGenerationParameters2.d1;
        int n7 = nTRUSigningKeyGenerationParameters2.d2;
        int n8 = nTRUSigningKeyGenerationParameters2.d3;
        int n9 = nTRUSigningKeyGenerationParameters2.basisType;
        int n10 = n3 * 2 + 1;
        int n11 = nTRUSigningKeyGenerationParameters.primeCheck;
        do {
            if (this.params.polyType == 0) {
                int n12 = n5 + 1;
                object4 = CryptoServicesRegistrar.getSecureRandom();
                polynomial = DenseTernaryPolynomial.generateRandom(n3, n12, n5, (SecureRandom)object4);
            } else {
                int n13 = n8 + 1;
                object4 = CryptoServicesRegistrar.getSecureRandom();
                polynomial = ProductFormPolynomial.generateRandom(n3, n6, n7, n13, n8, (SecureRandom)object4);
            }
            object4 = polynomial.toIntegerPolynomial();
        } while (n11 != 0 && ((IntegerPolynomial)object4).resultant((int)n10).res.equals(BigInteger.ZERO) || (integerPolynomial4 = ((IntegerPolynomial)object4).invertFq(n4)) == null);
        Resultant resultant2 = ((IntegerPolynomial)object4).resultant();
        while (true) {
            if (this.params.polyType == 0) {
                int n14 = n5 + 1;
                object3 = CryptoServicesRegistrar.getSecureRandom();
                object2 = DenseTernaryPolynomial.generateRandom(n3, n14, n5, (SecureRandom)object3);
            } else {
                int n15 = n8 + 1;
                object3 = CryptoServicesRegistrar.getSecureRandom();
                object2 = ProductFormPolynomial.generateRandom(n3, n6, n7, n15, n8, (SecureRandom)object3);
            }
            object3 = object2.toIntegerPolynomial();
            if (n11 != 0 && ((IntegerPolynomial)object3).resultant((int)n10).res.equals(BigInteger.ZERO) || ((IntegerPolynomial)object3).invertFq(n4) == null) continue;
            resultant = ((IntegerPolynomial)object3).resultant();
            bigIntEuclidean = BigIntEuclidean.calculate(resultant2.res, resultant.res);
            if (bigIntEuclidean.gcd.equals(BigInteger.ONE)) break;
        }
        Object object5 = (BigIntPolynomial)resultant2.rho.clone();
        ((BigIntPolynomial)object5).mult(bigIntEuclidean.x.multiply(BigInteger.valueOf(n4)));
        BigIntPolynomial bigIntPolynomial = (BigIntPolynomial)resultant.rho.clone();
        bigIntPolynomial.mult(bigIntEuclidean.y.multiply(BigInteger.valueOf(-n4)));
        if (this.params.keyGenAlg == 0) {
            IntegerPolynomial integerPolynomial5;
            IntegerPolynomial integerPolynomial6;
            IntegerPolynomial integerPolynomial7;
            int n16 = n3;
            object = new int[n16];
            int[] nArray = new int[n16];
            Object object6 = nArray;
            object[0] = ((IntegerPolynomial)object4).coeffs[0];
            nArray[0] = ((IntegerPolynomial)object3).coeffs[0];
            for (n10 = 1; n10 < n3; ++n10) {
                n11 = n3 - n10;
                object[n10] = ((IntegerPolynomial)object4).coeffs[n11];
                object6[n10] = ((IntegerPolynomial)object3).coeffs[n11];
            }
            IntegerPolynomial integerPolynomial8 = integerPolynomial7 = integerPolynomial6;
            integerPolynomial8((int[])object);
            object = integerPolynomial5;
            integerPolynomial5 = new IntegerPolynomial((int[])object6);
            IntegerPolynomial integerPolynomial9 = polynomial.mult(integerPolynomial8);
            integerPolynomial9.add(object2.mult((IntegerPolynomial)object));
            object6 = integerPolynomial9.resultant();
            BigIntPolynomial bigIntPolynomial2 = integerPolynomial6.mult(bigIntPolynomial);
            bigIntPolynomial2.add(((IntegerPolynomial)object).mult((BigIntPolynomial)object5));
            object = bigIntPolynomial2.mult(object6.rho);
            ((BigIntPolynomial)object).div(object6.res);
        } else {
            n7 = 0;
            for (n8 = 1; n8 < n3; n8 *= 10) {
                ++n7;
            }
            object = resultant.rho.div(new BigDecimal(resultant.res), ((BigIntPolynomial)object5).getMaxCoeffLength() + 1 + n7);
            BigDecimalPolynomial bigDecimalPolynomial = resultant2.rho.div(new BigDecimal(resultant2.res), bigIntPolynomial.getMaxCoeffLength() + 1 + n7).mult(bigIntPolynomial);
            bigDecimalPolynomial.add(((BigDecimalPolynomial)object).mult((BigIntPolynomial)object5));
            bigDecimalPolynomial.halve();
            object = bigDecimalPolynomial.round();
        }
        BigIntPolynomial bigIntPolynomial3 = object5;
        object5 = (BigIntPolynomial)bigIntPolynomial.clone();
        ((BigIntPolynomial)object5).sub(polynomial.mult((BigIntPolynomial)object));
        bigIntPolynomial = (BigIntPolynomial)bigIntPolynomial3.clone();
        bigIntPolynomial.sub(object2.mult((BigIntPolynomial)object));
        object = integerPolynomial3;
        integerPolynomial3 = new IntegerPolynomial((BigIntPolynomial)object5);
        object5 = integerPolynomial2;
        integerPolynomial2 = new IntegerPolynomial(bigIntPolynomial);
        this.minimizeFG((IntegerPolynomial)object4, (IntegerPolynomial)object3, (IntegerPolynomial)object, (IntegerPolynomial)object5, n3);
        if (n9 == 0) {
            integerPolynomial = object2.mult(integerPolynomial4, n4);
            object2 = object;
        } else {
            integerPolynomial = ((IntegerPolynomial)object).mult(integerPolynomial4, n4);
        }
        integerPolynomial.modPositive(n4);
        NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters3 = this.params;
        return new FGBasis(polynomial, (Polynomial)object2, integerPolynomial, (IntegerPolynomial)object, (IntegerPolynomial)object5, nTRUSigningKeyGenerationParameters3);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.params = (NTRUSigningKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters;
        ArrayList arrayList;
        int n3;
        ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>> arrayList2;
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = null;
        Object object = Executors.newCachedThreadPool();
        ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>>();
        for (n3 = ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.B; n3 >= 0; --n3) {
            arrayList3.add(object.submit((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2).new BasisGenerationTask(null)));
        }
        object.shutdown();
        object = arrayList;
        arrayList = new ArrayList();
        for (n3 = ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.B; n3 >= 0; --n3) {
            NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters2;
            Future future = (Future)arrayList3.get(n3);
            try {
                ((ArrayList)object).add((NTRUSigningPrivateKeyParameters.Basis)future.get());
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
            if (n3 != ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.B) continue;
            nTRUSigningPublicKeyParameters = nTRUSigningPublicKeyParameters2;
            nTRUSigningPublicKeyParameters2 = new NTRUSigningPublicKeyParameters(((NTRUSigningPrivateKeyParameters.Basis)future.get()).h, ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.getSigningParameters());
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters2 = nTRUSigningPrivateKeyParameters;
        nTRUSigningPrivateKeyParameters = new NTRUSigningPrivateKeyParameters((List<NTRUSigningPrivateKeyParameters.Basis>)object, nTRUSigningPublicKeyParameters);
        return new AsymmetricCipherKeyPair(nTRUSigningPublicKeyParameters, nTRUSigningPrivateKeyParameters2);
    }

    public AsymmetricCipherKeyPair generateKeyPairSingleThread() {
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters;
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> arrayList;
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> arrayList2 = arrayList;
        arrayList = new ArrayList<NTRUSigningPrivateKeyParameters.Basis>();
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = null;
        for (int i3 = ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.B; i3 >= 0; --i3) {
            NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters2;
            NTRUSigningPrivateKeyParameters.Basis basis = ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).generateBoundedBasis();
            arrayList2.add(basis);
            if (i3 != 0) continue;
            nTRUSigningPublicKeyParameters = nTRUSigningPublicKeyParameters2;
            nTRUSigningPublicKeyParameters2 = new NTRUSigningPublicKeyParameters(basis.h, ((NTRUSigningKeyPairGenerator)((Object)nTRUSigningPrivateKeyParameters2)).params.getSigningParameters());
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters2 = nTRUSigningPrivateKeyParameters;
        nTRUSigningPrivateKeyParameters = new NTRUSigningPrivateKeyParameters(arrayList2, nTRUSigningPublicKeyParameters);
        return new AsymmetricCipherKeyPair(nTRUSigningPublicKeyParameters, nTRUSigningPrivateKeyParameters2);
    }

    public NTRUSigningPrivateKeyParameters.Basis generateBoundedBasis() {
        FGBasis fGBasis;
        while (!(fGBasis = this.generateBasis()).isNormOk()) {
        }
        return fGBasis;
    }

    public class FGBasis
    extends NTRUSigningPrivateKeyParameters.Basis {
        public IntegerPolynomial F;
        public IntegerPolynomial G;

        public FGBasis(Polynomial polynomial, Polynomial polynomial2, IntegerPolynomial integerPolynomial, IntegerPolynomial integerPolynomial2, IntegerPolynomial integerPolynomial3, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) {
            super(polynomial, polynomial2, integerPolynomial, nTRUSigningKeyGenerationParameters);
            this.F = integerPolynomial2;
            this.G = integerPolynomial3;
        }

        public boolean isNormOk() {
            FGBasis fGBasis = this;
            NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = fGBasis.params;
            double d3 = nTRUSigningKeyGenerationParameters.keyNormBoundSq;
            int n3 = nTRUSigningKeyGenerationParameters.q;
            return (double)fGBasis.F.centeredNormSq(n3) < d3 && (double)this.G.centeredNormSq(n3) < d3;
        }
    }

    public class BasisGenerationTask
    implements Callable<NTRUSigningPrivateKeyParameters.Basis> {
        private BasisGenerationTask() {
        }

        public /* synthetic */ BasisGenerationTask(1 var2_2) {
            this();
        }

        @Override
        public NTRUSigningPrivateKeyParameters.Basis call() {
            return NTRUSigningKeyPairGenerator.this.generateBoundedBasis();
        }
    }
}

