/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NTRUSigningPrivateKeyParameters
extends AsymmetricKeyParameter {
    private List<Basis> bases;
    private NTRUSigningPublicKeyParameters publicKey;

    public NTRUSigningPrivateKeyParameters(byte[] byArray, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) {
        ByteArrayInputStream byteArrayInputStream;
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters = byteArrayInputStream2;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        nTRUSigningPrivateKeyParameters(byteArrayInputStream2, nTRUSigningKeyGenerationParameters);
    }

    public NTRUSigningPrivateKeyParameters(InputStream inputStream, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) {
        super(true);
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters;
        ArrayList<Basis> arrayList;
        ArrayList<Basis> arrayList2 = arrayList;
        arrayList = new ArrayList<Basis>();
        ((NTRUSigningPrivateKeyParameters)asymmetricKeyParameter).bases = arrayList2;
        for (int i3 = 0; i3 <= nTRUSigningKeyGenerationParameters.B; ++i3) {
            boolean bl = i3 != 0;
            Basis basis = new Basis(inputStream, nTRUSigningKeyGenerationParameters, bl);
            ((NTRUSigningPrivateKeyParameters)asymmetricKeyParameter).add(basis);
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters = asymmetricKeyParameter;
        AsymmetricKeyParameter asymmetricKeyParameter = nTRUSigningPublicKeyParameters;
        nTRUSigningPublicKeyParameters = new NTRUSigningPublicKeyParameters(inputStream, nTRUSigningKeyGenerationParameters.getSigningParameters());
        nTRUSigningPrivateKeyParameters.publicKey = asymmetricKeyParameter;
    }

    public NTRUSigningPrivateKeyParameters(List<Basis> list, NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters) {
        super(true);
        ArrayList<Basis> arrayList;
        ArrayList<Basis> arrayList2 = arrayList;
        arrayList = new ArrayList<Basis>(list);
        v1.bases = arrayList2;
        v1.publicKey = nTRUSigningPublicKeyParameters;
    }

    private void add(Basis basis) {
        this.bases.add(basis);
    }

    public Basis getBasis(int n3) {
        return this.bases.get(n3);
    }

    public NTRUSigningPublicKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i3 = 0; i3 < this.bases.size(); ++i3) {
            Basis basis = this.bases.get(i3);
            boolean bl = i3 != 0;
            basis.encode(byteArrayOutputStream2, bl);
        }
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
        byteArrayOutputStream3.write(this.publicKey.getEncoded());
        return byteArrayOutputStream3.toByteArray();
    }

    public void writeTo(OutputStream outputStream) {
        outputStream.write(this.getEncoded());
    }

    public int hashCode() {
        int n3 = 31;
        List<Basis> list = this.bases;
        if (list == null) {
            return n3;
        }
        int n4 = list.hashCode() + n3;
        Iterator<Basis> iterator = this.bases.iterator();
        while (iterator.hasNext()) {
            n4 = iterator.next().hashCode() + n4;
        }
        return n4;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (NTRUSigningPrivateKeyParameters)object;
        List<Basis> list = this.bases;
        boolean bl2 = list == null;
        if (bl2 != (bl = ((NTRUSigningPrivateKeyParameters)object).bases == null)) {
            return false;
        }
        if (list == null) {
            return true;
        }
        if (list.size() != ((NTRUSigningPrivateKeyParameters)object).bases.size()) {
            return false;
        }
        for (int i3 = 0; i3 < this.bases.size(); ++i3) {
            Basis basis = this.bases.get(i3);
            Basis basis2 = ((NTRUSigningPrivateKeyParameters)object).bases.get(i3);
            if (!basis.f.equals(basis2.f)) {
                return false;
            }
            if (!basis.fPrime.equals(basis2.fPrime)) {
                return false;
            }
            if (i3 != 0 && !basis.h.equals(basis2.h)) {
                return false;
            }
            if (basis.params.equals(basis2.params)) continue;
            return false;
        }
        return true;
    }

    public static class Basis {
        public Polynomial f;
        public Polynomial fPrime;
        public IntegerPolynomial h;
        public NTRUSigningKeyGenerationParameters params;

        public Basis(Polynomial polynomial, Polynomial polynomial2, IntegerPolynomial integerPolynomial, NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters) {
            this.f = polynomial;
            this.fPrime = polynomial2;
            this.h = integerPolynomial;
            this.params = nTRUSigningKeyGenerationParameters;
        }

        public Basis(InputStream inputStream, NTRUSigningKeyGenerationParameters object, boolean bl) {
            NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = object;
            int n3 = nTRUSigningKeyGenerationParameters.N;
            int n4 = nTRUSigningKeyGenerationParameters.q;
            int n5 = nTRUSigningKeyGenerationParameters.d1;
            int n6 = nTRUSigningKeyGenerationParameters.d2;
            int n7 = nTRUSigningKeyGenerationParameters.d3;
            int n8 = nTRUSigningKeyGenerationParameters.sparse;
            this.params = nTRUSigningKeyGenerationParameters;
            if (((NTRUSigningKeyGenerationParameters)object).polyType == 1) {
                n8 = n7 + 1;
                this.f = ProductFormPolynomial.fromBinary(inputStream, n3, n5, n6, n8, n7);
            } else {
                TernaryPolynomial ternaryPolynomial;
                IntegerPolynomial integerPolynomial = IntegerPolynomial.fromBinary3Tight(inputStream, n3);
                if (n8 != 0) {
                    SparseTernaryPolynomial sparseTernaryPolynomial;
                    ternaryPolynomial = sparseTernaryPolynomial;
                    sparseTernaryPolynomial = new SparseTernaryPolynomial(integerPolynomial);
                } else {
                    DenseTernaryPolynomial denseTernaryPolynomial;
                    ternaryPolynomial = denseTernaryPolynomial;
                    denseTernaryPolynomial = new DenseTernaryPolynomial(integerPolynomial);
                }
                this.f = ternaryPolynomial;
            }
            if (((NTRUSigningKeyGenerationParameters)object).basisType == 0) {
                object = IntegerPolynomial.fromBinary(inputStream, n3, n4);
                n5 = 0;
                while (true) {
                    int[] nArray = ((IntegerPolynomial)object).coeffs;
                    if (n5 >= ((IntegerPolynomial)object).coeffs.length) break;
                    nArray[n5] = nArray[n5] - n4 / 2;
                    ++n5;
                }
                this.fPrime = object;
            } else if (((NTRUSigningKeyGenerationParameters)object).polyType == 1) {
                int n9 = n7 + 1;
                this.fPrime = ProductFormPolynomial.fromBinary(inputStream, n3, n5, n6, n9, n7);
            } else {
                this.fPrime = IntegerPolynomial.fromBinary3Tight(inputStream, n3);
            }
            if (bl) {
                this.h = IntegerPolynomial.fromBinary(inputStream, n3, n4);
            }
        }

        private byte[] getEncoded(Polynomial polynomial) {
            if (polynomial instanceof ProductFormPolynomial) {
                return ((ProductFormPolynomial)polynomial).toBinary();
            }
            return polynomial.toIntegerPolynomial().toBinary3Tight();
        }

        public void encode(OutputStream outputStream, boolean bl) {
            Basis basis = this;
            int n3 = basis.params.q;
            outputStream.write(basis.getEncoded(basis.f));
            if (this.params.basisType == 0) {
                IntegerPolynomial integerPolynomial = this.fPrime.toIntegerPolynomial();
                int n4 = 0;
                while (true) {
                    int[] nArray = integerPolynomial.coeffs;
                    if (n4 >= integerPolynomial.coeffs.length) break;
                    int n5 = nArray[n4];
                    nArray[n4] = n3 / 2 + n5;
                    ++n4;
                }
                outputStream.write(integerPolynomial.toBinary(n3));
            } else {
                Basis basis2 = this;
                outputStream.write(basis2.getEncoded(basis2.fPrime));
            }
            if (bl) {
                outputStream.write(this.h.toBinary(n3));
            }
        }

        public int hashCode() {
            int n3 = 31;
            Polynomial polynomial = this.f;
            int n4 = polynomial == null ? 0 : polynomial.hashCode();
            n3 = (n3 + n4) * 31;
            Polynomial polynomial2 = this.fPrime;
            int n5 = polynomial2 == null ? 0 : polynomial2.hashCode();
            n3 = (n3 + n5) * 31;
            IntegerPolynomial integerPolynomial = this.h;
            int n6 = integerPolynomial == null ? 0 : integerPolynomial.hashCode();
            int n7 = (n3 + n6) * 31;
            NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = this.params;
            int n8 = nTRUSigningKeyGenerationParameters == null ? 0 : nTRUSigningKeyGenerationParameters.hashCode();
            return n7 + n8;
        }

        public boolean equals(Object object) {
            if (nTRUSigningKeyGenerationParameters == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof Basis)) {
                return false;
            }
            object = (Basis)object;
            Polynomial polynomial = ((Basis)((Object)nTRUSigningKeyGenerationParameters)).f;
            if (polynomial == null ? ((Basis)object).f != null : !polynomial.equals(((Basis)object).f)) {
                return false;
            }
            polynomial = ((Basis)((Object)nTRUSigningKeyGenerationParameters)).fPrime;
            if (polynomial == null ? ((Basis)object).fPrime != null : !polynomial.equals(((Basis)object).fPrime)) {
                return false;
            }
            polynomial = ((Basis)((Object)nTRUSigningKeyGenerationParameters)).h;
            if (polynomial == null ? ((Basis)object).h != null : !((IntegerPolynomial)polynomial).equals(((Basis)object).h)) {
                return false;
            }
            NTRUSigningKeyGenerationParameters nTRUSigningKeyGenerationParameters = ((Basis)((Object)nTRUSigningKeyGenerationParameters)).params;
            return !(nTRUSigningKeyGenerationParameters == null ? ((Basis)object).params != null : !nTRUSigningKeyGenerationParameters.equals(((Basis)object).params));
        }
    }
}

