/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class Layer {
    private int vi;
    private int viNext;
    private int oi;
    private short[][][] coeff_alpha;
    private short[][][] coeff_beta;
    private short[][] coeff_gamma;
    private short[] coeff_eta;

    public Layer(byte by, byte by2, short[][][] sArray, short[][][] sArray2, short[][] sArray3, short[] sArray4) {
        int n3 = by & 0xFF;
        by = (byte)n3;
        this.vi = n3;
        int n4 = by2 & 0xFF;
        by2 = (byte)n4;
        this.viNext = by2;
        this.oi = n4 - by;
        this.coeff_alpha = sArray;
        this.coeff_beta = sArray2;
        this.coeff_gamma = sArray3;
        this.coeff_eta = sArray4;
    }

    public Layer(int n3, int n4, SecureRandom secureRandom) {
        int n5;
        int n6;
        Layer layer = this;
        this.vi = n3;
        this.viNext = n4;
        int n7 = this.oi = (n6 = n4 - n3);
        this.coeff_alpha = new short[n7][n7][n3];
        this.coeff_beta = new short[n6][n3][n3];
        layer.coeff_gamma = new short[n6][n4];
        layer.coeff_eta = new short[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            for (n4 = 0; n4 < this.oi; ++n4) {
                for (n5 = 0; n5 < this.vi; ++n5) {
                    this.coeff_alpha[n3][n4][n5] = (short)(secureRandom.nextInt() & 0xFF);
                }
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (n4 = 0; n4 < this.vi; ++n4) {
                for (n5 = 0; n5 < this.vi; ++n5) {
                    this.coeff_beta[n3][n4][n5] = (short)(secureRandom.nextInt() & 0xFF);
                }
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (n4 = 0; n4 < this.viNext; ++n4) {
                this.coeff_gamma[n3][n4] = (short)(secureRandom.nextInt() & 0xFF);
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            this.coeff_eta[n3] = (short)(secureRandom.nextInt() & 0xFF);
        }
    }

    public short[][] plugInVinegars(short[] sArray) {
        int n3;
        short s2;
        int n4;
        int n5;
        int n6;
        int n7 = this.oi;
        short[][] sArray2 = new short[n7][n7 + 1];
        short[] sArray3 = new short[n7];
        for (n6 = 0; n6 < this.oi; ++n6) {
            for (n5 = 0; n5 < this.vi; ++n5) {
                for (n4 = 0; n4 < this.vi; ++n4) {
                    s2 = GF2Field.multElem(GF2Field.multElem(this.coeff_beta[n6][n5][n4], sArray[n5]), sArray[n4]);
                    sArray3[n6] = GF2Field.addElem(sArray3[n6], s2);
                }
            }
        }
        for (n6 = 0; n6 < this.oi; ++n6) {
            for (n5 = 0; n5 < this.oi; ++n5) {
                for (n4 = 0; n4 < this.vi; ++n4) {
                    s2 = GF2Field.multElem(this.coeff_alpha[n6][n5][n4], sArray[n4]);
                    short[] sArray4 = sArray2[n6];
                    sArray4[n5] = GF2Field.addElem(sArray4[n5], s2);
                }
            }
        }
        for (n6 = 0; n6 < this.oi; ++n6) {
            for (n5 = 0; n5 < this.vi; ++n5) {
                n4 = GF2Field.multElem(this.coeff_gamma[n6][n5], sArray[n5]);
                sArray3[n6] = GF2Field.addElem(sArray3[n6], (short)n4);
            }
        }
        for (n3 = 0; n3 < this.oi; ++n3) {
            for (n6 = this.vi; n6 < this.viNext; ++n6) {
                short[] sArray5 = sArray2[n3];
                short[] sArray6 = sArray5;
                n4 = this.vi;
                sArray5[n6 - n4] = GF2Field.addElem(this.coeff_gamma[n3][n6], sArray6[n6 - n4]);
            }
        }
        for (n3 = 0; n3 < this.oi; ++n3) {
            sArray3[n3] = GF2Field.addElem(sArray3[n3], this.coeff_eta[n3]);
        }
        for (n3 = 0; n3 < (n6 = this.oi); ++n3) {
            sArray2[n3][n6] = sArray3[n3];
        }
        return sArray2;
    }

    public int getVi() {
        return this.vi;
    }

    public int getViNext() {
        return this.viNext;
    }

    public int getOi() {
        return this.oi;
    }

    public short[][][] getCoeffAlpha() {
        return this.coeff_alpha;
    }

    public short[][][] getCoeffBeta() {
        return this.coeff_beta;
    }

    public short[][] getCoeffGamma() {
        return this.coeff_gamma;
    }

    public short[] getCoeffEta() {
        return this.coeff_eta;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Layer) {
            return this.vi == ((Layer)(object = (Layer)object)).getVi() && this.viNext == ((Layer)object).getViNext() && this.oi == ((Layer)object).getOi() && RainbowUtil.equals(this.coeff_alpha, ((Layer)object).getCoeffAlpha()) && RainbowUtil.equals(this.coeff_beta, ((Layer)object).getCoeffBeta()) && RainbowUtil.equals(this.coeff_gamma, ((Layer)object).getCoeffGamma()) && RainbowUtil.equals(this.coeff_eta, ((Layer)object).getCoeffEta());
        }
        return false;
    }

    public int hashCode() {
        Layer layer = this;
        int n3 = ((layer.vi * 37 + this.viNext) * 37 + this.oi) * 37;
        n3 = (Arrays.hashCode(layer.coeff_alpha) + n3) * 37;
        n3 = (Arrays.hashCode(layer.coeff_beta) + n3) * 37;
        n3 = (Arrays.hashCode(layer.coeff_gamma) + n3) * 37;
        return Arrays.hashCode(layer.coeff_eta) + n3;
    }
}

