/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.Layer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import java.security.SecureRandom;

public class RainbowKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private boolean initialized = false;
    private SecureRandom sr;
    private RainbowKeyGenerationParameters rainbowParams;
    private short[][] A1;
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2;
    private short[][] A2inv;
    private short[] b2;
    private int numOfLayers;
    private Layer[] layers;
    private int[] vi;
    private short[][] pub_quadratic;
    private short[][] pub_singular;
    private short[] pub_scalar;

    private void initializeDefault() {
        RainbowParameters rainbowParameters;
        RainbowKeyGenerationParameters rainbowKeyGenerationParameters;
        RainbowKeyPairGenerator rainbowKeyPairGenerator = rainbowKeyGenerationParameters2;
        RainbowKeyGenerationParameters rainbowKeyGenerationParameters2 = rainbowKeyGenerationParameters;
        SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();
        RainbowParameters rainbowParameters2 = rainbowParameters;
        rainbowParameters = new RainbowParameters();
        rainbowKeyGenerationParameters = new RainbowKeyGenerationParameters(secureRandom, rainbowParameters2);
        rainbowKeyPairGenerator.initialize(rainbowKeyGenerationParameters2);
    }

    private void keygen() {
        RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
        rainbowKeyPairGenerator.generateL1();
        rainbowKeyPairGenerator.generateL2();
        rainbowKeyPairGenerator.generateF();
        rainbowKeyPairGenerator.computePublicKey();
    }

    private void generateL1() {
        ComputeInField computeInField;
        RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
        int[] nArray = rainbowKeyPairGenerator.vi;
        int n3 = rainbowKeyPairGenerator.vi[nArray.length - 1] - nArray[0];
        rainbowKeyPairGenerator.A1 = new short[n3][n3];
        rainbowKeyPairGenerator.A1inv = null;
        ComputeInField computeInField2 = computeInField;
        computeInField = new ComputeInField();
        while (this.A1inv == null) {
            for (int i3 = 0; i3 < n3; ++i3) {
                for (int i4 = 0; i4 < n3; ++i4) {
                    this.A1[i3][i4] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A1inv = computeInField2.inverse(this.A1);
        }
        this.b1 = new short[n3];
        for (int i5 = 0; i5 < n3; ++i5) {
            this.b1[i5] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateL2() {
        ComputeInField computeInField;
        RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
        int n3 = rainbowKeyPairGenerator.vi[rainbowKeyPairGenerator.vi.length - 1];
        rainbowKeyPairGenerator.A2 = new short[n3][n3];
        rainbowKeyPairGenerator.A2inv = null;
        ComputeInField computeInField2 = computeInField;
        computeInField = new ComputeInField();
        while (this.A2inv == null) {
            for (int i3 = 0; i3 < n3; ++i3) {
                for (int i4 = 0; i4 < n3; ++i4) {
                    this.A2[i3][i4] = (short)(this.sr.nextInt() & 0xFF);
                }
            }
            this.A2inv = computeInField2.inverse(this.A2);
        }
        this.b2 = new short[n3];
        for (int i5 = 0; i5 < n3; ++i5) {
            this.b2[i5] = (short)(this.sr.nextInt() & 0xFF);
        }
    }

    private void generateF() {
        this.layers = new Layer[this.numOfLayers];
        int n3 = 0;
        while (n3 < this.numOfLayers) {
            Layer layer;
            int n4 = n3;
            Layer layer2 = layer;
            RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
            int n5 = rainbowKeyPairGenerator.vi[n3];
            int n6 = rainbowKeyPairGenerator.vi[++n3];
            SecureRandom secureRandom = rainbowKeyPairGenerator.sr;
            layer = new Layer(n5, n6, secureRandom);
            this.layers[n4] = layer2;
        }
    }

    private void computePublicKey() {
        Object object;
        int n3;
        ComputeInField computeInField;
        ComputeInField computeInField2 = computeInField;
        computeInField = new ComputeInField();
        int[] nArray = this.vi;
        int n4 = nArray[nArray.length - 1] - nArray[0];
        int n5 = n3 = this.vi[nArray.length - 1];
        short[][][] sArray = new short[n4][n5][n5];
        this.pub_singular = new short[n4][n3];
        this.pub_scalar = new short[n4];
        int n6 = 0;
        short[] cfr_ignored_0 = new short[n3];
        int n7 = 0;
        while (true) {
            Object object2 = this.layers;
            if (n7 >= this.layers.length) break;
            object2 = object2[n7].getCoeffAlpha();
            short[][][] sArray2 = this.layers[n7].getCoeffBeta();
            RainbowKeyPairGenerator rainbowKeyPairGenerator = this;
            object = rainbowKeyPairGenerator.layers[n7].getCoeffGamma();
            short[] sArray3 = rainbowKeyPairGenerator.layers[n7].getCoeffEta();
            int n8 = ((Layer)object2[0]).length;
            int n9 = sArray2[0].length;
            for (int i3 = 0; i3 < n8; ++i3) {
                int n10;
                int n11;
                for (n11 = 0; n11 < n8; ++n11) {
                    for (n10 = 0; n10 < n9; ++n10) {
                        ComputeInField computeInField3 = computeInField2;
                        short s2 = n11 + n9;
                        short[] sArray4 = computeInField2.multVect((short)object2[i3][n11][n10], this.A2[s2]);
                        int n12 = n6 + i3;
                        short[][] sArray5 = sArray[n12];
                        sArray[n12] = computeInField3.addSquareMatrix(sArray5, computeInField3.multVects(sArray4, this.A2[n10]));
                        sArray4 = computeInField2.multVect(this.b2[n10], sArray4);
                        sArray5 = this.pub_singular;
                        this.pub_singular[n12] = computeInField2.addVect(sArray4, sArray5[n12]);
                        sArray4 = computeInField2.multVect((short)object2[i3][n11][n10], this.A2[n10]);
                        sArray4 = computeInField2.multVect(this.b2[s2], sArray4);
                        sArray5 = this.pub_singular;
                        this.pub_singular[n12] = computeInField2.addVect(sArray4, sArray5[n12]);
                        s2 = GF2Field.multElem((short)object2[i3][n11][n10], this.b2[s2]);
                        this.pub_scalar[n12] = GF2Field.addElem(this.pub_scalar[n12], GF2Field.multElem(s2, this.b2[n10]));
                    }
                }
                for (n11 = 0; n11 < n9; ++n11) {
                    for (n10 = 0; n10 < n9; ++n10) {
                        ComputeInField computeInField4 = computeInField2;
                        short[] sArray6 = computeInField2.multVect(sArray2[i3][n11][n10], this.A2[n11]);
                        int n13 = n6 + i3;
                        short[][] sArray7 = sArray[n13];
                        sArray[n13] = computeInField4.addSquareMatrix(sArray7, computeInField4.multVects(sArray6, this.A2[n10]));
                        sArray6 = computeInField2.multVect(this.b2[n10], sArray6);
                        sArray7 = this.pub_singular;
                        this.pub_singular[n13] = computeInField2.addVect(sArray6, sArray7[n13]);
                        sArray6 = computeInField2.multVect(sArray2[i3][n11][n10], this.A2[n10]);
                        sArray6 = computeInField2.multVect(this.b2[n11], sArray6);
                        sArray7 = this.pub_singular;
                        this.pub_singular[n13] = computeInField2.addVect(sArray6, sArray7[n13]);
                        short s3 = GF2Field.multElem(sArray2[i3][n11][n10], this.b2[n11]);
                        this.pub_scalar[n13] = GF2Field.addElem(this.pub_scalar[n13], GF2Field.multElem(s3, this.b2[n10]));
                    }
                }
                for (n11 = 0; n11 < n9 + n8; ++n11) {
                    RainbowKeyPairGenerator rainbowKeyPairGenerator2 = this;
                    short[] sArray8 = computeInField2.multVect(object[i3][n11], this.A2[n11]);
                    short[][] sArray9 = rainbowKeyPairGenerator2.pub_singular;
                    n10 = n6 + i3;
                    rainbowKeyPairGenerator2.pub_singular[n10] = computeInField2.addVect(sArray8, sArray9[n10]);
                    rainbowKeyPairGenerator2.pub_scalar[n10] = GF2Field.addElem(rainbowKeyPairGenerator2.pub_scalar[n10], GF2Field.multElem(object[i3][n11], this.b2[n11]));
                }
                n11 = n6 + i3;
                this.pub_scalar[n11] = GF2Field.addElem(this.pub_scalar[n11], sArray3[i3]);
            }
            n6 += n8;
            ++n7;
        }
        int n14 = n4;
        int n15 = n3;
        short[][][] sArray10 = new short[n14][n15][n15];
        short[][] sArray11 = new short[n14][n3];
        short[] sArray12 = new short[n14];
        for (int i4 = 0; i4 < n4; ++i4) {
            int n16 = 0;
            while (true) {
                object = this.A1;
                if (n16 >= this.A1.length) break;
                ComputeInField computeInField5 = computeInField2;
                ComputeInField computeInField6 = computeInField2;
                short[][] sArray13 = object;
                object = sArray10[i4];
                short s4 = sArray13[i4][n16];
                sArray10[i4] = computeInField6.addSquareMatrix((short[][])object, computeInField6.multMatrix(s4, sArray[n16]));
                object = sArray11[i4];
                sArray11[i4] = computeInField5.addVect((short[])object, computeInField5.multVect(this.A1[i4][n16], this.pub_singular[n16]));
                sArray12[i4] = GF2Field.addElem(sArray12[i4], GF2Field.multElem(this.A1[i4][n16], this.pub_scalar[n16]));
                ++n16;
            }
            sArray12[i4] = GF2Field.addElem(sArray12[i4], this.b1[i4]);
        }
        this.pub_singular = sArray11;
        this.pub_scalar = sArray12;
        this.compactPublicKey(sArray10);
    }

    private void compactPublicKey(short[][][] sArray) {
        int n3 = sArray.length;
        int n4 = sArray[0].length;
        this.pub_quadratic = new short[n3][(n4 + 1) * n4 / 2];
        for (int i3 = 0; i3 < n3; ++i3) {
            int n5 = 0;
            for (int i4 = 0; i4 < n4; ++i4) {
                for (int i5 = i4; i5 < n4; ++i5) {
                    if (i5 == i4) {
                        this.pub_quadratic[i3][n5] = sArray[i3][i4][i5];
                    } else {
                        short[][] sArray2 = sArray[i3];
                        this.pub_quadratic[i3][n5] = GF2Field.addElem(sArray2[i4][i5], sArray2[i5][i4]);
                    }
                    ++n5;
                }
            }
        }
    }

    public AsymmetricCipherKeyPair genKeyPair() {
        RainbowPublicKeyParameters rainbowPublicKeyParameters;
        RainbowPrivateKeyParameters rainbowPrivateKeyParameters;
        if (!((RainbowKeyPairGenerator)object3).initialized) {
            ((RainbowKeyPairGenerator)object3).initializeDefault();
        }
        ((RainbowKeyPairGenerator)object3).keygen();
        RainbowPrivateKeyParameters rainbowPrivateKeyParameters2 = rainbowPrivateKeyParameters;
        RainbowKeyPairGenerator rainbowKeyPairGenerator = object3;
        Object object = rainbowKeyPairGenerator.A1inv;
        Object object2 = rainbowKeyPairGenerator.b1;
        short[][] sArray = rainbowKeyPairGenerator.A2inv;
        short[] sArray2 = rainbowKeyPairGenerator.b2;
        int[] nArray = rainbowKeyPairGenerator.vi;
        Layer[] layerArray = rainbowKeyPairGenerator.layers;
        rainbowPrivateKeyParameters = new RainbowPrivateKeyParameters((short[][])object, (short[])object2, sArray, sArray2, nArray, layerArray);
        object = rainbowPublicKeyParameters;
        RainbowKeyPairGenerator rainbowKeyPairGenerator2 = object3;
        Object object3 = rainbowKeyPairGenerator2.vi;
        int n3 = rainbowKeyPairGenerator2.vi[rainbowKeyPairGenerator2.vi.length - 1] - object3[0];
        object2 = rainbowKeyPairGenerator2.pub_quadratic;
        sArray = rainbowKeyPairGenerator2.pub_singular;
        sArray2 = rainbowKeyPairGenerator2.pub_scalar;
        rainbowPublicKeyParameters = new RainbowPublicKeyParameters(n3, (short[][])object2, sArray, sArray2);
        return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)object, rainbowPrivateKeyParameters2);
    }

    public void initialize(KeyGenerationParameters keyGenerationParameters) {
        RainbowKeyPairGenerator rainbowKeyPairGenerator = rainbowKeyGenerationParameters;
        RainbowKeyGenerationParameters rainbowKeyGenerationParameters = (RainbowKeyGenerationParameters)keyGenerationParameters;
        rainbowKeyPairGenerator.rainbowParams = rainbowKeyGenerationParameters;
        rainbowKeyPairGenerator.sr = rainbowKeyGenerationParameters.getRandom();
        rainbowKeyPairGenerator.vi = rainbowKeyPairGenerator.rainbowParams.getParameters().getVi();
        rainbowKeyPairGenerator.numOfLayers = rainbowKeyPairGenerator.rainbowParams.getParameters().getNumOfLayers();
        rainbowKeyPairGenerator.initialized = true;
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

