/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABEREngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.Utils;

class Poly {
    private static final int KARATSUBA_N = 64;
    private static int SCHB_N = 16;
    private final int N_RES;
    private final int N_SB;
    private final int N_SB_RES;
    private final int SABER_N;
    private final int SABER_L;
    private final SABEREngine engine;
    private final Utils utils;

    public Poly(SABEREngine sABEREngine) {
        int n3;
        this.engine = sABEREngine;
        this.SABER_L = sABEREngine.getSABER_L();
        this.SABER_N = n3 = sABEREngine.getSABER_N();
        this.N_RES = n3 << 1;
        this.N_SB = n3 >> 2;
        this.N_SB_RES = this.N_SB * 2 - 1;
        this.utils = sABEREngine.getUtils();
    }

    private long load_littleendian(byte[] byArray, int n3, int n4) {
        long l3 = byArray[n3 + 0] & 0xFF;
        for (int i3 = 1; i3 < n4; ++i3) {
            l3 |= (long)(byArray[n3 + i3] & 0xFF) << i3 * 8;
        }
        return l3;
    }

    private void cbd(short[] sArray, byte[] byArray, int n3) {
        block7: {
            int[] nArray;
            block8: {
                block6: {
                    nArray = new int[4];
                    if (this.engine.getSABER_MU() != 6) break block6;
                    for (int i3 = 0; i3 < this.SABER_N / 4; ++i3) {
                        int n4;
                        int n5 = (int)this.load_littleendian(byArray, i3 * 3 + n3, 3);
                        int n6 = 0;
                        for (n4 = 0; n4 < 3; ++n4) {
                            n6 += n5 >> n4 & 0x249249;
                        }
                        int n7 = n6;
                        int n8 = n6;
                        int n9 = n6;
                        int n10 = n6;
                        nArray[0] = n6 & 7;
                        n5 = n10 >>> 3 & 7;
                        nArray[1] = n10 >>> 6 & 7;
                        n6 = n9 >>> 9 & 7;
                        nArray[2] = n9 >>> 12 & 7;
                        n4 = n8 >>> 15 & 7;
                        nArray[3] = n8 >>> 18 & 7;
                        int n11 = n7 >>> 21;
                        int n12 = i3 * 4;
                        int n13 = n12 + 0;
                        sArray[n13] = (short)(nArray[0] - n5);
                        n5 = n12 + 1;
                        sArray[n5] = (short)(nArray[1] - n6);
                        n5 = n12 + 2;
                        sArray[n5] = (short)(nArray[2] - n4);
                        n5 = n12 + 3;
                        sArray[n5] = (short)(nArray[3] - n11);
                    }
                    break block7;
                }
                if (this.engine.getSABER_MU() != 8) break block8;
                for (int i4 = 0; i4 < this.SABER_N / 4; ++i4) {
                    int n14;
                    int n15 = i4 * 4;
                    int n16 = (int)this.load_littleendian(byArray, n3 + n15, 4);
                    int n17 = 0;
                    for (n14 = 0; n14 < 4; ++n14) {
                        n17 += n16 >>> n14 & 0x11111111;
                    }
                    int n18 = n17;
                    int n19 = n17;
                    int n20 = n17;
                    int n21 = n17;
                    nArray[0] = n17 & 0xF;
                    n16 = n21 >>> 4 & 0xF;
                    nArray[1] = n21 >>> 8 & 0xF;
                    n17 = n20 >>> 12 & 0xF;
                    nArray[2] = n20 >>> 16 & 0xF;
                    n14 = n19 >>> 20 & 0xF;
                    nArray[3] = n19 >>> 24 & 0xF;
                    int n22 = n18 >>> 28;
                    int n23 = n15 + 0;
                    sArray[n23] = (short)(nArray[0] - n16);
                    n16 = n15 + 1;
                    sArray[n16] = (short)(nArray[1] - n17);
                    n16 = n15 + 2;
                    sArray[n16] = (short)(nArray[2] - n14);
                    sArray[n15 += 3] = (short)(nArray[3] - n22);
                }
                break block7;
            }
            if (this.engine.getSABER_MU() != 10) break block7;
            for (int i5 = 0; i5 < this.SABER_N / 4; ++i5) {
                int n24;
                long l3 = this.load_littleendian(byArray, i5 * 5 + n3, 5);
                long l4 = 0L;
                for (n24 = 0; n24 < 5; ++n24) {
                    l4 += l3 >>> n24 & 0x842108421L;
                }
                long l5 = l4;
                long l6 = l4;
                long l7 = l4;
                nArray[0] = (int)(l4 & 0x1FL);
                int n25 = (int)(l7 >>> 5 & 0x1FL);
                nArray[1] = (int)(l7 >>> 10 & 0x1FL);
                int n26 = (int)(l6 >>> 15 & 0x1FL);
                nArray[2] = (int)(l6 >>> 20 & 0x1FL);
                int n27 = (int)(l5 >>> 25 & 0x1FL);
                nArray[3] = (int)(l5 >>> 30 & 0x1FL);
                int n28 = (int)(l4 >>> 35);
                n24 = i5 * 4;
                int n29 = n24 + 0;
                sArray[n29] = (short)(nArray[0] - n25);
                n25 = n24 + 1;
                sArray[n25] = (short)(nArray[1] - n26);
                n25 = n24 + 2;
                sArray[n25] = (short)(nArray[2] - n27);
                n25 = n24 + 3;
                sArray[n25] = (short)(nArray[3] - n28);
            }
        }
    }

    private short OVERFLOWING_MUL(int n3, int n4) {
        return (short)(n3 * n4);
    }

    private void karatsuba_simple(int[] nArray, int[] nArray2, int[] nArray3) {
        int n3;
        int[] nArray4 = new int[31];
        int[] nArray5 = new int[31];
        int[] nArray6 = new int[31];
        int[] nArray7 = new int[63];
        for (int i3 = 0; i3 < 16; ++i3) {
            int n4 = nArray[i3];
            int n5 = nArray[i3 + 16];
            int n6 = nArray[i3 + 32];
            int n7 = nArray[i3 + 48];
            for (int i4 = 0; i4 < 16; ++i4) {
                int n8;
                int n9 = nArray2[i4];
                int n10 = n8 = n9;
                int[] nArray8 = nArray3;
                int n11 = nArray2[i4 + 16];
                int n12 = i3 + i4;
                int n13 = n12 + 0;
                nArray8[n13] = nArray3[n13] + this.OVERFLOWING_MUL(n4, n8);
                n8 = n12 + 32;
                nArray8[n8] = nArray3[n8] + this.OVERFLOWING_MUL(n5, n11);
                int n14 = n10 + n11;
                int n15 = n4 + n5;
                long l3 = nArray4[n12];
                nArray4[n12] = (int)((long)n14 * (long)n15 + l3);
                n14 = nArray2[i4 + 32];
                int[] nArray9 = nArray3;
                n15 = nArray2[i4 + 48];
                int n16 = n12 + 64;
                nArray9[n16] = nArray3[n16] + this.OVERFLOWING_MUL(n14, n6);
                n16 = n12 + 96;
                nArray9[n16] = nArray3[n16] + this.OVERFLOWING_MUL(n15, n7);
                n16 = n6 + n7;
                int n17 = n14 + n15;
                nArray6[n12] = nArray6[n12] + this.OVERFLOWING_MUL(n16, n17);
                n14 = n9 + n14;
                n16 = n4 + n6;
                int n18 = n8;
                int n19 = n8;
                nArray7[n13] = nArray7[n13] + this.OVERFLOWING_MUL(n14, n16);
                n8 = n11 + n15;
                n11 = n5 + n7;
                nArray7[n18] = nArray7[n19] + this.OVERFLOWING_MUL(n8, n11);
                n8 = n14 + n8;
                n11 = n16 + n11;
                nArray5[n12] = nArray5[n12] + this.OVERFLOWING_MUL(n8, n11);
            }
        }
        for (n3 = 0; n3 < 31; ++n3) {
            int n20 = n3 + 0;
            int n21 = n3 + 32;
            nArray5[n3] = nArray5[n3] - nArray7[n20] - nArray7[n21];
            nArray4[n3] = nArray4[n3] - nArray3[n20] - nArray3[n21];
            nArray6[n3] = nArray6[n3] - nArray3[n3 + 64] - nArray3[n3 + 96];
        }
        for (n3 = 0; n3 < 31; ++n3) {
            int[] nArray10 = nArray3;
            int n22 = n3 + 16;
            nArray7[n22] = nArray7[n22] + nArray5[n3];
            nArray10[n22] = nArray3[n22] + nArray4[n3];
            n22 = n3 + 80;
            nArray10[n22] = nArray3[n22] + nArray6[n3];
        }
        for (n3 = 0; n3 < 63; ++n3) {
            nArray7[n3] = nArray7[n3] - nArray3[n3] - nArray3[n3 + 64];
        }
        for (n3 = 0; n3 < 63; ++n3) {
            int n23 = n3 + 32;
            nArray3[n23] = nArray3[n23] + nArray7[n3];
        }
    }

    private void toom_cook_4way(short[] sArray, short[] sArray2, short[] sArray3) {
        int n3;
        int n4;
        int n5;
        int n6;
        short s2;
        int n7;
        int n8;
        Poly poly = this;
        int n9 = 43691;
        int n10 = 36409;
        int n11 = 61167;
        int n12 = poly.N_SB;
        int[] nArray = new int[n12];
        int[] nArray2 = new int[n12];
        int[] nArray3 = new int[n12];
        int[] nArray4 = new int[n12];
        int[] nArray5 = new int[n12];
        int[] nArray6 = new int[n12];
        int[] nArray7 = new int[n12];
        int[] nArray8 = new int[n12];
        int[] nArray9 = new int[n12];
        int[] nArray10 = new int[n12];
        int[] nArray11 = new int[n12];
        int[] nArray12 = new int[n12];
        int[] nArray13 = new int[n12];
        int[] nArray14 = new int[n12];
        int n13 = poly.N_SB_RES;
        int[] nArray15 = new int[n13];
        int[] nArray16 = new int[n13];
        int[] nArray17 = new int[n13];
        int[] nArray18 = new int[n13];
        int[] nArray19 = new int[n13];
        int[] nArray20 = new int[n13];
        int[] nArray21 = new int[n13];
        for (n8 = 0; n8 < (n7 = this.N_SB); ++n8) {
            int n14 = n7;
            int n15 = n7;
            int n16 = n7;
            n7 = sArray[n8];
            s2 = sArray[n8 + n16];
            n6 = sArray[n15 * 2 + n8];
            n5 = sArray[n14 * 3 + n8];
            short s3 = (short)(n7 + n6);
            n4 = s2 + n5;
            short s4 = (short)(s3 + n4);
            n4 = (short)(s3 - n4);
            nArray3[n8] = s4;
            nArray4[n8] = n4;
            short s5 = (short)((n7 << 2) + n6 << 1);
            short s6 = (short)((s2 << 2) + n5);
            n4 = s6;
            s4 = (short)(s5 + s6);
            n4 = (short)(s5 - n4);
            nArray5[n8] = s4;
            nArray6[n8] = n4;
            nArray2[n8] = (short)((n5 << 3) + (n6 << 2) + (s2 << 1) + n7);
            nArray7[n8] = n7;
            nArray[n8] = n5;
        }
        for (n3 = 0; n3 < (n8 = this.N_SB); ++n3) {
            int n17 = n8;
            int n18 = n8;
            int n19 = n8;
            n8 = sArray2[n3];
            n7 = sArray2[n3 + n19];
            s2 = sArray2[n18 * 2 + n3];
            n6 = sArray2[n17 * 3 + n3];
            int n20 = n8 + s2;
            n5 = n7 + n6;
            n4 = n20 + n5;
            n5 = n20 - n5;
            nArray10[n3] = n4;
            nArray11[n3] = n5;
            int n21 = (n8 << 2) + s2 << 1;
            n5 = (n7 << 2) + n6;
            n4 = n21 + n5;
            n5 = n21 - n5;
            nArray12[n3] = n4;
            nArray13[n3] = n5;
            nArray9[n3] = (n6 << 3) + (s2 << 2) + (n7 << 1) + n8;
            nArray14[n3] = n8;
            nArray8[n3] = n6;
        }
        Poly poly2 = this;
        poly2.karatsuba_simple(nArray, nArray8, nArray15);
        poly2.karatsuba_simple(nArray2, nArray9, nArray16);
        poly2.karatsuba_simple(nArray3, nArray10, nArray17);
        poly2.karatsuba_simple(nArray4, nArray11, nArray18);
        poly2.karatsuba_simple(nArray5, nArray12, nArray19);
        poly2.karatsuba_simple(nArray6, nArray13, nArray20);
        poly2.karatsuba_simple(nArray7, nArray14, nArray21);
        for (n3 = 0; n3 < this.N_SB_RES; ++n3) {
            short[] sArray4 = sArray3;
            int n22 = nArray15[n3];
            int n23 = nArray16[n3];
            int n24 = nArray17[n3];
            int n25 = n24;
            int n26 = nArray18[n3];
            int n27 = nArray19[n3];
            int n28 = n27;
            int n29 = n26;
            int n30 = n23;
            n23 = nArray21[n3];
            n26 = n30 + n28;
            n28 = nArray20[n3] - n28;
            n25 = (n29 & 0xFFFF) - (n25 & 0xFFFF) >>> 1;
            int n31 = (n27 - n22 - (n23 << 6) << 1) + n28;
            int n32 = n24 + n25;
            n26 = n26 - (n32 << 6) - n32;
            n32 = n32 - n23 - n22;
            int n33 = n32 * 45 + n26;
            n26 = ((n31 & 0xFFFF) - (n32 << 3)) * n9 >> 3;
            n28 += n33;
            int n34 = ((n33 & 0xFFFF) + ((n25 & 0xFFFF) << 4)) * n10 >> 1;
            n31 = n34;
            n25 = -(n25 + n31);
            n28 = ((n31 & 0xFFFF) * 30 - (n28 & 0xFFFF)) * n11 >> 2;
            n31 = n32 - n26;
            n32 = n34 - n28;
            sArray4[n3] = (short)(sArray3[n3] + (n23 & 0xFFFF));
            n23 = n3 + 64;
            sArray3[n23] = (short)(sArray4[n23] + (n28 & 0xFFFF));
            n23 = n3 + 128;
            sArray3[n23] = (short)(sArray3[n23] + (n26 & 0xFFFF));
            n23 = n3 + 192;
            sArray3[n23] = (short)(sArray3[n23] + (n25 & 0xFFFF));
            n23 = n3 + 256;
            sArray3[n23] = (short)(sArray3[n23] + (n31 & 0xFFFF));
            n23 = n3 + 320;
            sArray3[n23] = (short)(sArray3[n23] + (n32 & 0xFFFF));
            n23 = n3 + 384;
            sArray3[n23] = (short)(sArray3[n23] + (n22 & 0xFFFF));
        }
    }

    private void poly_mul_acc(short[] sArray, short[] sArray2, short[] sArray3) {
        int n3;
        short[] sArray4 = sArray;
        sArray = new short[this.SABER_N * 2];
        this.toom_cook_4way(sArray4, sArray2, sArray);
        for (int i3 = (v1342688).SABER_N; i3 < (n3 = this.SABER_N) * 2; ++i3) {
            int n4 = n3;
            n3 = i3 - n3;
            short s2 = sArray3[n3];
            sArray3[n3] = (short)(sArray[i3 - n4] - sArray[i3] + s2);
        }
    }

    public void GenMatrix(short[][][] sArray, byte[] byArray) {
        SHAKEDigest sHAKEDigest;
        int n3 = this.SABER_L * this.engine.getSABER_POLYVECBYTES();
        byte[] byArray2 = new byte[n3];
        SHAKEDigest sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest2(128);
        sHAKEDigest2.update(byArray, 0, this.engine.getSABER_SEEDBYTES());
        sHAKEDigest.doFinal(byArray2, 0, n3);
        int n4 = 0;
        while (n4 < this.SABER_L) {
            int n5 = n4++;
            n3 = n5 * this.engine.getSABER_POLYVECBYTES();
            this.utils.BS2POLVECq(byArray2, n3, sArray[n5]);
        }
    }

    public void GenSecret(short[][] sArray, byte[] byArray) {
        SHAKEDigest sHAKEDigest;
        int n3 = this.SABER_L * this.engine.getSABER_POLYCOINBYTES();
        byte[] byArray2 = new byte[n3];
        SHAKEDigest sHAKEDigest2 = sHAKEDigest;
        sHAKEDigest2(128);
        sHAKEDigest2.update(byArray, 0, this.engine.getSABER_NOISE_SEEDBYTES());
        sHAKEDigest.doFinal(byArray2, 0, n3);
        for (int i3 = 0; i3 < this.SABER_L; ++i3) {
            short[] sArray2 = sArray[i3];
            int n4 = i3 * this.engine.getSABER_POLYCOINBYTES();
            this.cbd(sArray2, byArray2, n4);
        }
    }

    public void MatrixVectorMul(short[][][] sArray, short[][] sArray2, short[][] sArray3, int n3) {
        for (int i3 = 0; i3 < this.SABER_L; ++i3) {
            for (int i4 = 0; i4 < this.SABER_L; ++i4) {
                short[] sArray4;
                short[] sArray5;
                short[] sArray6;
                if (n3 == 1) {
                    sArray6 = sArray[i4][i3];
                    sArray5 = sArray2[i4];
                    sArray4 = sArray3[i3];
                    this.poly_mul_acc(sArray6, sArray5, sArray4);
                    continue;
                }
                sArray6 = sArray[i3][i4];
                sArray5 = sArray2[i4];
                sArray4 = sArray3[i3];
                this.poly_mul_acc(sArray6, sArray5, sArray4);
            }
        }
    }

    public void InnerProd(short[][] sArray, short[][] sArray2, short[] sArray3) {
        for (int i3 = 0; i3 < this.SABER_L; ++i3) {
            short[] sArray4 = sArray[i3];
            this.poly_mul_acc(sArray4, sArray2[i3], sArray3);
        }
    }
}

