/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABEREngine;

class Utils {
    private final int SABER_N;
    private final int SABER_L;
    private final int SABER_ET;
    private final int SABER_POLYBYTES;
    private final int SABER_EP;
    private final int SABER_KEYBYTES;

    public Utils(SABEREngine sABEREngine) {
        this.SABER_N = sABEREngine.getSABER_N();
        this.SABER_L = sABEREngine.getSABER_L();
        this.SABER_ET = sABEREngine.getSABER_ET();
        this.SABER_POLYBYTES = sABEREngine.getSABER_POLYBYTES();
        this.SABER_EP = sABEREngine.getSABER_EP();
        this.SABER_KEYBYTES = sABEREngine.getSABER_KEYBYTES();
    }

    private void POLq2BS(byte[] byArray, int n3, short[] sArray) {
        int n4 = 0;
        while (n4 < this.SABER_N / 8) {
            int n5;
            int n6 = n4;
            int n7 = n4;
            n4 = (short)(n7 * 13);
            int n8 = n7 * 8;
            int n9 = n5 = n8;
            int n10 = n5;
            int n11 = n5;
            int n12 = n5;
            int n13 = n5;
            int n14 = n5;
            int n15 = n5;
            n4 = n3 + n4;
            n5 = n4 + 0;
            int n16 = sArray[n15 + 0];
            byArray[n5] = (byte)(n16 & 0xFF);
            n5 = n4 + 1;
            n16 = n16 >> 8 & 0x1F;
            short s2 = sArray[n14 + 1];
            byArray[n5] = (byte)(n16 | (s2 & 7) << 5);
            n5 = n4 + 2;
            byArray[n5] = (byte)(s2 >> 3 & 0xFF);
            n5 = n4 + 3;
            n16 = s2 >> 11 & 3;
            s2 = sArray[n13 + 2];
            byArray[n5] = (byte)(n16 | (s2 & 0x3F) << 2);
            n5 = n4 + 4;
            n16 = s2 >> 6 & 0x7F;
            s2 = sArray[n12 + 3];
            byArray[n5] = (byte)(n16 | (s2 & 1) << 7);
            n5 = n4 + 5;
            byArray[n5] = (byte)(s2 >> 1 & 0xFF);
            n5 = n4 + 6;
            n16 = s2 >> 9 & 0xF;
            s2 = sArray[n11 + 4];
            byArray[n5] = (byte)(n16 | (s2 & 0xF) << 4);
            n5 = n4 + 7;
            byArray[n5] = (byte)(s2 >> 4 & 0xFF);
            n5 = n4 + 8;
            n16 = s2 >> 12 & 1;
            s2 = sArray[n10 + 5];
            byArray[n5] = (byte)(n16 | (s2 & 0x7F) << 1);
            n5 = n4 + 9;
            n16 = s2 >> 7 & 0x3F;
            s2 = sArray[n9 + 6];
            byArray[n5] = (byte)(n16 | (s2 & 3) << 6);
            n5 = n4 + 10;
            byArray[n5] = (byte)(s2 >> 2 & 0xFF);
            n5 = n4 + 11;
            n16 = s2 >> 10 & 7;
            s2 = sArray[n8 + 7];
            byArray[n5] = (byte)(n16 | (s2 & 0x1F) << 3);
            byArray[n4 += 12] = (byte)(s2 >> 5 & 0xFF);
            n4 = (short)(n6 + 1);
        }
    }

    private void BS2POLq(byte[] byArray, int n3, short[] sArray) {
        int n4 = 0;
        while (n4 < this.SABER_N / 8) {
            int n5 = n4;
            int n6 = n4;
            n4 = (short)(n6 * 13);
            short s2 = (short)(n6 * 8);
            int n7 = n4;
            n4 = s2 + 0;
            int n8 = n3 + n7;
            int n9 = byArray[n8 + 0] & 0xFF;
            byte by = byArray[n8 + 1];
            sArray[n4] = (short)(n9 | (by & 0x1F) << 8);
            n4 = s2 + 1;
            n9 = by >> 5 & 7 | (byArray[n8 + 2] & 0xFF) << 3;
            by = byArray[n8 + 3];
            sArray[n4] = (short)(n9 | (by & 3) << 11);
            n4 = s2 + 2;
            n9 = by >> 2 & 0x3F;
            by = byArray[n8 + 4];
            sArray[n4] = (short)(n9 | (by & 0x7F) << 6);
            n4 = s2 + 3;
            n9 = by >> 7 & 1 | (byArray[n8 + 5] & 0xFF) << 1;
            by = byArray[n8 + 6];
            sArray[n4] = (short)(n9 | (by & 0xF) << 9);
            n4 = s2 + 4;
            n9 = by >> 4 & 0xF | (byArray[n8 + 7] & 0xFF) << 4;
            by = byArray[n8 + 8];
            sArray[n4] = (short)(n9 | (by & 1) << 12);
            n4 = s2 + 5;
            n9 = by >> 1 & 0x7F;
            by = byArray[n8 + 9];
            sArray[n4] = (short)(n9 | (by & 0x3F) << 7);
            n4 = s2 + 6;
            n9 = by >> 6 & 3 | (byArray[n8 + 10] & 0xFF) << 2;
            by = byArray[n8 + 11];
            sArray[n4] = (short)(n9 | (by & 7) << 10);
            n4 = s2 + 7;
            sArray[n4] = (short)(by >> 3 & 0x1F | (byArray[n8 + 12] & 0xFF) << 5);
            n4 = (short)(n5 + 1);
        }
    }

    private void POLp2BS(byte[] byArray, int n3, short[] sArray) {
        int n4 = 0;
        while (n4 < this.SABER_N / 4) {
            int n5;
            int n6 = n4;
            int n7 = n4;
            n4 = (short)(n7 * 5);
            int n8 = n7 * 4;
            int n9 = n5 = n8;
            int n10 = n5;
            int n11 = n5;
            n4 = n3 + n4;
            n5 = n4 + 0;
            int n12 = sArray[n11 + 0];
            byArray[n5] = (byte)(n12 & 0xFF);
            n5 = n4 + 1;
            n12 = n12 >> 8 & 3;
            short s2 = sArray[n10 + 1];
            byArray[n5] = (byte)(n12 | (s2 & 0x3F) << 2);
            n5 = n4 + 2;
            n12 = s2 >> 6 & 0xF;
            s2 = sArray[n9 + 2];
            byArray[n5] = (byte)(n12 | (s2 & 0xF) << 4);
            n5 = n4 + 3;
            n12 = s2 >> 4 & 0x3F;
            s2 = sArray[n8 + 3];
            byArray[n5] = (byte)(n12 | (s2 & 3) << 6);
            byArray[n4 += 4] = (byte)(s2 >> 2 & 0xFF);
            n4 = (short)(n6 + 1);
        }
    }

    public void POLT2BS(byte[] byArray, int n3, short[] sArray) {
        block4: {
            int n4;
            block5: {
                block3: {
                    n4 = this.SABER_ET;
                    if (n4 != 3) break block3;
                    n4 = 0;
                    while (n4 < this.SABER_N / 8) {
                        int n5 = n4;
                        int n6 = n4;
                        n4 = (short)(n6 * 3);
                        short s2 = (short)(n6 * 8);
                        n4 = n3 + n4;
                        int n7 = n4 + 0;
                        int n8 = sArray[s2 + 0] & 7 | (sArray[s2 + 1] & 7) << 3;
                        short s3 = sArray[s2 + 2];
                        byArray[n7] = (byte)(n8 | (s3 & 3) << 6);
                        n7 = n4 + 1;
                        n8 = s3 >> 2 & 1 | (sArray[s2 + 3] & 7) << 1 | (sArray[s2 + 4] & 7) << 4;
                        s3 = sArray[s2 + 5];
                        byArray[n7] = (byte)(n8 | (s3 & 1) << 7);
                        byArray[n4 += 2] = (byte)(s3 >> 1 & 3 | (sArray[s2 + 6] & 7) << 2 | (sArray[s2 + 7] & 7) << 5);
                        n4 = (short)(n5 + 1);
                    }
                    break block4;
                }
                if (n4 != 4) break block5;
                n4 = 0;
                while (n4 < this.SABER_N / 2) {
                    int n9 = n4;
                    int n10 = n4;
                    n4 = (short)(n10 * 2);
                    int n11 = n3 + n10;
                    byArray[n11] = (byte)(sArray[n4] & 0xF | (sArray[n4 + 1] & 0xF) << 4);
                    n4 = (short)(n9 + 1);
                }
                break block4;
            }
            if (n4 != 6) break block4;
            n4 = 0;
            while (n4 < this.SABER_N / 4) {
                int n12 = n4;
                int n13 = n4;
                n4 = (short)(n13 * 3);
                short s4 = (short)(n13 * 4);
                n4 = n3 + n4;
                int n14 = n4 + 0;
                int n15 = sArray[s4 + 0] & 0x3F;
                short s5 = sArray[s4 + 1];
                byArray[n14] = (byte)(n15 | (s5 & 3) << 6);
                n14 = n4 + 1;
                n15 = s5 >> 2 & 0xF;
                s5 = sArray[s4 + 2];
                byArray[n14] = (byte)(n15 | (s5 & 0xF) << 4);
                byArray[n4 += 2] = (byte)(s5 >> 4 & 3 | (sArray[s4 + 3] & 0x3F) << 2);
                n4 = (short)(n12 + 1);
            }
        }
    }

    public void BS2POLT(byte[] byArray, int n3, short[] sArray) {
        block4: {
            int n4;
            block5: {
                block3: {
                    n4 = this.SABER_ET;
                    if (n4 != 3) break block3;
                    n4 = 0;
                    while (n4 < this.SABER_N / 8) {
                        int n5;
                        int n6 = n4;
                        int n7 = n4;
                        n4 = (short)(n7 * 3);
                        short s2 = (short)(n7 * 8);
                        int n8 = n4;
                        n4 = s2 + 0;
                        int n9 = n3 + n8;
                        int n10 = n5 = n9;
                        n5 = byArray[n5 + 0];
                        sArray[n4] = (short)(n5 & 7);
                        n4 = s2 + 1;
                        sArray[n4] = (short)(n5 >> 3 & 7);
                        n4 = s2 + 2;
                        n5 = n5 >> 6 & 3;
                        byte by = byArray[n10 + 1];
                        sArray[n4] = (short)(n5 | (by & 1) << 2);
                        n4 = s2 + 3;
                        sArray[n4] = (short)(by >> 1 & 7);
                        n4 = s2 + 4;
                        sArray[n4] = (short)(by >> 4 & 7);
                        n4 = s2 + 5;
                        n5 = by >> 7 & 1;
                        by = byArray[n9 + 2];
                        sArray[n4] = (short)(n5 | (by & 3) << 1);
                        n4 = s2 + 6;
                        sArray[n4] = (short)(by >> 2 & 7);
                        n4 = s2 + 7;
                        sArray[n4] = (short)(by >> 5 & 7);
                        n4 = (short)(n6 + 1);
                    }
                    break block4;
                }
                if (n4 != 4) break block5;
                n4 = 0;
                while (n4 < this.SABER_N / 2) {
                    int n11 = n4;
                    int n12 = n4;
                    n4 = (short)(n12 * 2);
                    byte by = byArray[n3 + n12];
                    sArray[n4] = (short)(by & 0xF);
                    sArray[++n4] = (short)(by >> 4 & 0xF);
                    n4 = (short)(n11 + 1);
                }
                break block4;
            }
            if (n4 != 6) break block4;
            n4 = 0;
            while (n4 < this.SABER_N / 4) {
                int n13;
                int n14 = n4;
                int n15 = n4;
                n4 = (short)(n15 * 3);
                short s3 = (short)(n15 * 4);
                int n16 = n4;
                n4 = s3 + 0;
                int n17 = n3 + n16;
                int n18 = n13 = n17;
                n13 = byArray[n13 + 0];
                sArray[n4] = (short)(n13 & 0x3F);
                n4 = s3 + 1;
                n13 = n13 >> 6 & 3;
                byte by = byArray[n18 + 1];
                sArray[n4] = (short)(n13 | (by & 0xF) << 2);
                n4 = s3 + 2;
                n13 = (by & 0xFF) >> 4;
                by = byArray[n17 + 2];
                sArray[n4] = (short)(n13 | (by & 3) << 4);
                n4 = s3 + 3;
                sArray[n4] = (short)((by & 0xFF) >> 2);
                n4 = (short)(n14 + 1);
            }
        }
    }

    public void BS2POLp(byte[] byArray, int n3, short[] sArray) {
        int n4 = 0;
        while (n4 < this.SABER_N / 4) {
            int n5 = n4;
            int n6 = n4;
            n4 = (short)(n6 * 5);
            short s2 = (short)(n6 * 4);
            int n7 = n4;
            n4 = s2 + 0;
            int n8 = n3 + n7;
            int n9 = byArray[n8 + 0] & 0xFF;
            byte by = byArray[n8 + 1];
            sArray[n4] = (short)(n9 | (by & 3) << 8);
            n4 = s2 + 1;
            n9 = by >> 2 & 0x3F;
            by = byArray[n8 + 2];
            sArray[n4] = (short)(n9 | (by & 0xF) << 6);
            n4 = s2 + 2;
            n9 = by >> 4 & 0xF;
            by = byArray[n8 + 3];
            sArray[n4] = (short)(n9 | (by & 0x3F) << 4);
            n4 = s2 + 3;
            sArray[n4] = (short)(by >> 6 & 3 | (byArray[n8 + 4] & 0xFF) << 2);
            n4 = (short)(n5 + 1);
        }
    }

    public void POLVECq2BS(byte[] byArray, short[][] sArray) {
        int n3 = 0;
        while (n3 < this.SABER_L) {
            int n4 = n3;
            int n5 = n3;
            n3 = n5 * this.SABER_POLYBYTES;
            this.POLq2BS(byArray, n3, sArray[n5]);
            n3 = (byte)(n4 + 1);
        }
    }

    public void BS2POLVECq(byte[] byArray, int n3, short[][] sArray) {
        int n4 = 0;
        while (n4 < this.SABER_L) {
            int n5 = n4;
            int n6 = n4;
            n4 = n6 * this.SABER_POLYBYTES + n3;
            this.BS2POLq(byArray, n4, sArray[n6]);
            n4 = (byte)(n5 + 1);
        }
    }

    public void POLVECp2BS(byte[] byArray, short[][] sArray) {
        int n3 = 0;
        while (n3 < this.SABER_L) {
            int n4 = n3;
            int n5 = n3;
            n3 = this.SABER_EP * this.SABER_N / 8 * n3;
            this.POLp2BS(byArray, n3, sArray[n5]);
            n3 = (byte)(n4 + 1);
        }
    }

    public void BS2POLVECp(byte[] byArray, short[][] sArray) {
        int n3 = 0;
        while (n3 < this.SABER_L) {
            int n4 = n3;
            int n5 = n3;
            n3 = this.SABER_EP * this.SABER_N / 8 * n3;
            this.BS2POLp(byArray, n3, sArray[n5]);
            n3 = (byte)(n4 + 1);
        }
    }

    public void BS2POLmsg(byte[] byArray, short[] sArray) {
        for (int n3 = 0; n3 < this.SABER_KEYBYTES; n3 = (int)((byte)(n3 + 1))) {
            for (int n4 = 0; n4 < 8; n4 = (int)((byte)(n4 + 1))) {
                int n5 = n3;
                int n6 = n5 * 8 + n4;
                sArray[n6] = (short)(byArray[n5] >> n4 & 1);
            }
        }
    }

    public void POLmsg2BS(byte[] byArray, short[] sArray) {
        for (int n3 = 0; n3 < this.SABER_KEYBYTES; n3 = (int)((byte)(n3 + 1))) {
            for (int n4 = 0; n4 < 8; n4 = (int)((byte)(n4 + 1))) {
                byArray[n3] = (byte)(byArray[n3] | (sArray[n3 * 8 + n4] & 1) << n4);
            }
        }
    }
}

