/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.Horst;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.Seed;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.Tree;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.Wots;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SPHINCS256Signer
implements MessageSigner {
    private final HashFunctions hashFunctions;
    private byte[] keyData;

    public SPHINCS256Signer(Digest digest, Digest digest2) {
        if (digest.getDigestSize() == 32) {
            if (digest2.getDigestSize() == 64) {
                HashFunctions hashFunctions;
                SPHINCS256Signer sPHINCS256Signer = hashFunctions2;
                HashFunctions hashFunctions2 = hashFunctions;
                hashFunctions = new HashFunctions(digest, digest2);
                sPHINCS256Signer.hashFunctions = hashFunctions2;
                return;
            }
            throw new IllegalArgumentException("2n-digest needs to produce 64 bytes of output");
        }
        throw new IllegalArgumentException("n-digest needs to produce 32 bytes of output");
    }

    public static void validate_authpath(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, int n3, byte[] byArray3, int n4, byte[] byArray4, int n5) {
        int n6;
        int n7;
        int n8;
        byte[] byArray5 = new byte[64];
        if ((n3 & 1) != 0) {
            for (n8 = 0; n8 < 32; ++n8) {
                n7 = n8 + 32;
                byArray5[n7] = byArray2[n8];
            }
            for (n6 = 0; n6 < 32; ++n6) {
                byArray5[n6] = byArray3[n4 + n6];
            }
        } else {
            for (n8 = 0; n8 < 32; ++n8) {
                byArray5[n8] = byArray2[n8];
            }
            n6 = 0;
            while (n6 < 32) {
                int n9 = n6++;
                n8 = n9 + 32;
                byArray5[n8] = byArray3[n4 + n9];
            }
        }
        n6 = n4 + 32;
        for (n4 = 0; n4 < n5 - 1; ++n4) {
            if (((n3 >>>= 1) & 1) != 0) {
                n8 = (n4 + 7) * 2 * 32;
                hashFunctions.hash_2n_n_mask(byArray5, 32, byArray5, 0, byArray4, n8);
                for (n8 = 0; n8 < 32; ++n8) {
                    byArray5[n8] = byArray3[n6 + n8];
                }
            } else {
                n8 = (n4 + 7) * 2 * 32;
                hashFunctions.hash_2n_n_mask(byArray5, 0, byArray5, 0, byArray4, n8);
                n8 = 0;
                while (n8 < 32) {
                    int n10 = n8++;
                    n7 = n10 + 32;
                    byArray5[n7] = byArray3[n6 + n10];
                }
            }
            n6 += 32;
        }
        int n11 = (n5 + 7 - 1) * 2 * 32;
        hashFunctions.hash_2n_n_mask(byArray, 0, byArray5, 0, byArray4, n11);
    }

    public static void compute_authpath_wots(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, int n3, Tree.leafaddr leafaddr2, byte[] object, byte[] byArray3, int n4) {
        int n5;
        Wots wots;
        long l3;
        Tree.leafaddr leafaddr3;
        Tree.leafaddr leafaddr4 = leafaddr3;
        byte[] byArray4 = new byte[2048];
        byte[] byArray5 = new byte[1024];
        byte[] byArray6 = new byte[68608];
        new Tree.leafaddr((Tree.leafaddr)leafaddr2).subleaf = 0L;
        while ((l3 = leafaddr4.subleaf++) < 32L) {
            Seed.get_seed(hashFunctions, byArray5, (int)(l3 * 32L), (byte[])object, leafaddr4);
        }
        object = wots;
        wots = new Wots();
        leafaddr4.subleaf = 0L;
        while ((l3 = leafaddr4.subleaf++) < 32L) {
            long l4 = l3;
            int n6 = (int)(l4 * 67L * 32L);
            n5 = (int)(l4 * 32L);
            ((Wots)object).wots_pkgen(hashFunctions, byArray6, n6, byArray5, n5, byArray3, 0);
        }
        leafaddr4.subleaf = 0L;
        while ((l3 = leafaddr4.subleaf++) < 32L) {
            long l5 = l3;
            int n7 = (int)(l5 * 32L + 1024L);
            int n8 = (int)(l5 * 67L * 32L);
            Tree.l_tree(hashFunctions, byArray4, n7, byArray6, n8, byArray3, 0);
        }
        int n9 = 0;
        for (int i3 = 32; i3 > 0; i3 >>>= 1) {
            for (int i4 = 0; i4 < i3; i4 += 2) {
                int n10 = (i3 >>> 1) * 32;
                n10 = (i4 >>> 1) * 32 + n10;
                int n11 = i3 * 32;
                n11 = i4 * 32 + n11;
                n5 = (n9 + 7) * 2 * 32;
                hashFunctions.hash_2n_n_mask(byArray4, n10, byArray4, n11, byArray3, n5);
            }
            ++n9;
        }
        int n12 = (int)leafaddr2.subleaf;
        for (int i5 = 0; i5 < n4; ++i5) {
            n9 = (32 >>> i5) * 32;
            n9 = (n12 >>> i5 ^ 1) * 32 + n9;
            int n13 = i5 * 32 + n3;
            System.arraycopy(byArray4, n9, byArray2, n13, 32);
        }
        System.arraycopy(byArray4, 32, byArray, 0, 32);
    }

    private void zerobytes(byte[] byArray, int n3, int n4) {
        for (int i3 = 0; i3 != n4; ++i3) {
            byArray[n3 + i3] = 0;
        }
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.keyData = bl ? (cipherParameters instanceof ParametersWithRandom ? ((SPHINCSPrivateKeyParameters)((ParametersWithRandom)cipherParameters).getParameters()).getKeyData() : ((SPHINCSPrivateKeyParameters)cipherParameters).getKeyData()) : ((SPHINCSPublicKeyParameters)cipherParameters).getKeyData();
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        SPHINCS256Signer sPHINCS256Signer = hashFunctions;
        HashFunctions hashFunctions = sPHINCS256Signer.hashFunctions;
        byte[] byArray2 = sPHINCS256Signer.keyData;
        return sPHINCS256Signer.crypto_sign(hashFunctions, byArray, byArray2);
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        SPHINCS256Signer sPHINCS256Signer = hashFunctions;
        HashFunctions hashFunctions = sPHINCS256Signer.hashFunctions;
        byte[] byArray3 = sPHINCS256Signer.keyData;
        return sPHINCS256Signer.verify(hashFunctions, byArray, byArray2, byArray3);
    }

    public byte[] crypto_sign(HashFunctions hashFunctions, byte[] object, byte[] object2) {
        Wots wots;
        int n3;
        Tree.leafaddr leafaddr2;
        Tree.leafaddr leafaddr3;
        int n4;
        byte[] byArray = new byte[41000];
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[64];
        int n5 = 8;
        long[] lArray = new long[8];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[1024];
        byte[] byArray7 = new byte[1088];
        for (n4 = 0; n4 < 1088; ++n4) {
            byArray7[n4] = object2[n4];
        }
        System.arraycopy(byArray7, 1056, byArray, 40968, 32);
        Digest digest = hashFunctions.getMessageHash();
        Object object3 = object2 = (Object)digest;
        object2 = new byte[object2.getDigestSize()];
        object3.update(byArray, 40968, 32);
        digest.update((byte[])object, 0, ((byte[])object).length);
        digest.doFinal((byte[])object2, 0);
        this.zerobytes(byArray, 40968, 32);
        for (n4 = 0; n4 != n5; ++n4) {
            lArray[n4] = Pack.littleEndianToLong((byte[])object2, n4 * 8);
        }
        HashFunctions hashFunctions2 = hashFunctions;
        long l3 = lArray[0] & 0xFFFFFFFFFFFFFFFL;
        System.arraycopy(object2, 16, byArray2, 0, 32);
        System.arraycopy(byArray2, 0, byArray, 39912, 32);
        object2 = leafaddr3;
        new Tree.leafaddr().level = 11;
        new Tree.leafaddr().subtree = 0L;
        new Tree.leafaddr().subleaf = 0L;
        System.arraycopy(byArray7, 32, byArray, 39944, 1024);
        Tree.treehash(hashFunctions2, byArray, 40968, 5, byArray7, (Tree.leafaddr)object2, byArray, 39944);
        Digest digest2 = hashFunctions2.getMessageHash();
        object2 = digest2;
        object2.update(byArray, 39912, 1088);
        object2.update((byte[])object, 0, ((byte[])object).length);
        digest2.doFinal(byArray3, 0);
        object = leafaddr2;
        object();
        object.level = 12;
        object.subleaf = (int)(l3 & 0x1FL);
        leafaddr2.subtree = l3 >>> 5;
        for (n3 = 0; n3 < 32; ++n3) {
            byArray[n3] = byArray2[n3];
        }
        n3 = 32;
        System.arraycopy(byArray7, 32, byArray6, 0, 1024);
        for (int i3 = 0; i3 < 8; ++i3) {
            n4 = n3 + i3;
            byArray[n4] = (byte)(l3 >>> i3 * 8 & 0xFFL);
        }
        Seed.get_seed(hashFunctions, byArray5, 0, byArray7, (Tree.leafaddr)object);
        new Horst();
        n3 = 40 + Horst.horst_sign(hashFunctions, byArray, 40, byArray4, byArray5, byArray6, byArray3);
        Wots wots2 = wots;
        wots = new Wots();
        int n6 = 0;
        while (n6 < 12) {
            HashFunctions hashFunctions3 = hashFunctions;
            object.level = n6++;
            Seed.get_seed(hashFunctions3, byArray5, 0, byArray7, (Tree.leafaddr)object);
            wots2.wots_sign(hashFunctions3, byArray, n3, byArray4, byArray5, byArray6);
            SPHINCS256Signer.compute_authpath_wots(hashFunctions, byArray4, byArray, n3 += 2144, (Tree.leafaddr)object, byArray7, byArray6, 5);
            n3 += 160;
            l3 = object.subtree;
            object.subleaf = (int)(l3 & 0x1FL);
            object.subtree = l3 >>> 5;
        }
        this.zerobytes(byArray7, 0, 1088);
        return byArray;
    }

    public boolean verify(HashFunctions hashFunctions, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        long l3 = 0L;
        Object object = new byte[2144];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = new byte[32];
        byte[] byArray6 = new byte[41000];
        byte[] byArray7 = new byte[1056];
        if (byArray2.length == 41000) {
            Wots wots;
            int n3;
            byte[] byArray8 = new byte[64];
            for (n3 = 0; n3 < 1056; ++n3) {
                byArray7[n3] = byArray3[n3];
            }
            byArray3 = new byte[32];
            for (n3 = 0; n3 < 32; ++n3) {
                byArray3[n3] = byArray2[n3];
            }
            System.arraycopy(byArray2, 0, byArray6, 0, 41000);
            Digest digest = hashFunctions.getMessageHash();
            digest.update(byArray3, 0, 32);
            digest.update(byArray7, 0, 1056);
            int n4 = byArray.length;
            digest.update(byArray, 0, n4);
            digest.doFinal(byArray8, 0);
            int n5 = 32;
            for (n4 = 0; n4 < 8; ++n4) {
                l3 ^= (long)(byArray6[n5 + n4] & 0xFF) << n4 * 8;
            }
            new Horst();
            Horst.horst_verify(hashFunctions, byArray5, byArray6, 40, byArray7, byArray8);
            n5 = 13352;
            Wots wots2 = wots;
            wots = new Wots();
            for (int i3 = 0; i3 < 12; ++i3) {
                wots2.wots_verify(hashFunctions, (byte[])object, byArray6, n5, byArray5, byArray7);
                Tree.l_tree(hashFunctions, byArray4, 0, (byte[])object, 0, byArray7, 0);
                SPHINCS256Signer.validate_authpath(hashFunctions, byArray5, byArray4, (int)(l3 & 0x1FL), byArray6, n5 += 2144, byArray7, 5);
                l3 >>= 5;
                n5 += 160;
            }
            boolean bl = true;
            for (int i4 = 0; i4 < 32; ++i4) {
                if (byArray5[i4] == byArray7[i4 + 1024]) continue;
                bl = false;
            }
            return bl;
        }
        throw new IllegalArgumentException("signature wrong size");
    }
}

