/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.MGF1BytesGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.HMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.MGFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.ADRS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.IndexedDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

abstract class SPHINCSPlusEngine {
    public final boolean robust;
    public final int N;
    public final int WOTS_W;
    public final int WOTS_LOGW;
    public final int WOTS_LEN;
    public final int WOTS_LEN1;
    public final int WOTS_LEN2;
    public final int D;
    public final int A;
    public final int K;
    public final int H;
    public final int H_PRIME;
    public final int T;

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Arrays.clone(byArray);
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            byArray3[i3] = (byte)(byArray3[i3] ^ byArray2[i3]);
        }
        return byArray3;
    }

    /*
     * Unable to fully structure code
     */
    public SPHINCSPlusEngine(boolean var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7) {
        block7: {
            block9: {
                block3: {
                    block8: {
                        block4: {
                            block6: {
                                block5: {
                                    super();
                                    this.N = var2_2;
                                    if (var3_3 != 16) break block4;
                                    this.WOTS_LOGW = 4;
                                    this.WOTS_LEN1 = var2_2 * 8 / 4;
                                    if (var2_2 <= 8) lbl-1000:
                                    // 2 sources

                                    {
                                        while (true) {
                                            this.WOTS_LEN2 = 2;
                                            break block3;
                                            break;
                                        }
                                    }
                                    if (var2_2 > 136) break block5;
                                    this.WOTS_LEN2 = 3;
                                    break block3;
                                }
                                if (var2_2 > 256) break block6;
                                this.WOTS_LEN2 = 4;
                                break block3;
                            }
                            throw new IllegalArgumentException("cannot precompute SPX_WOTS_LEN2 for n outside {2, .., 256}");
                        }
                        if (var3_3 != 256) break block7;
                        this.WOTS_LOGW = 8;
                        this.WOTS_LEN1 = var2_2 * 8 / 8;
                        if (var2_2 > 1) break block8;
                        this.WOTS_LEN2 = 1;
                        break block3;
                    }
                    if (var2_2 <= 256) {
                        ** continue;
                    }
                    break block9;
                }
                v0 = this;
                this.WOTS_W = var3_3;
                this.WOTS_LEN = this.WOTS_LEN1 + this.WOTS_LEN2;
                this.robust = var1_1;
                this.D = var4_4;
                this.A = var5_5;
                this.K = var6_6;
                this.H = var7_7;
                v0.H_PRIME = var7_7 / var4_4;
                v0.T = 1 << var5_5;
                return;
            }
            throw new IllegalArgumentException("cannot precompute SPX_WOTS_LEN2 for n outside {2, .., 256}");
        }
        throw new IllegalArgumentException("wots_w assumed 16 or 256");
    }

    public abstract byte[] F(byte[] var1, ADRS var2, byte[] var3);

    public abstract byte[] H(byte[] var1, ADRS var2, byte[] var3, byte[] var4);

    public abstract IndexedDigest H_msg(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public abstract byte[] T_l(byte[] var1, ADRS var2, byte[] var3);

    public abstract byte[] PRF(byte[] var1, byte[] var2, ADRS var3);

    public abstract byte[] PRF_msg(byte[] var1, byte[] var2, byte[] var3);

    public static class Shake256Engine
    extends SPHINCSPlusEngine {
        private final Xof treeDigest;

        public Shake256Engine(boolean bl, int n3, int n4, int n5, int n6, int n7, int n8) {
            super(bl, n3, n4, n5, n6, n7, n8);
            SHAKEDigest sHAKEDigest;
            SHAKEDigest sHAKEDigest2 = sHAKEDigest;
            sHAKEDigest = new SHAKEDigest(256);
            v1.treeDigest = sHAKEDigest2;
        }

        @Override
        public byte[] F(byte[] byArray, ADRS aDRS, byte[] byArray2) {
            if (this.robust) {
                byArray2 = this.bitmask(byArray, aDRS, byArray2);
            }
            int n3 = this.N;
            byte[] byArray3 = new byte[n3];
            Shake256Engine shake256Engine = this;
            shake256Engine.treeDigest.update(byArray, 0, byArray.length);
            shake256Engine.treeDigest.update(aDRS.value, 0, aDRS.value.length);
            shake256Engine.treeDigest.update(byArray2, 0, byArray2.length);
            shake256Engine.treeDigest.doFinal(byArray3, 0, n3);
            return byArray3;
        }

        @Override
        public byte[] H(byte[] byArray, ADRS aDRS, byte[] byArray2, byte[] byArray3) {
            byArray2 = Arrays.concatenate(byArray2, byArray3);
            if (this.robust) {
                byArray2 = this.bitmask(byArray, aDRS, byArray2);
            }
            int n3 = this.N;
            byte[] byArray4 = new byte[n3];
            Shake256Engine shake256Engine = this;
            shake256Engine.treeDigest.update(byArray, 0, byArray.length);
            shake256Engine.treeDigest.update(aDRS.value, 0, aDRS.value.length);
            shake256Engine.treeDigest.update(byArray2, 0, byArray2.length);
            shake256Engine.treeDigest.doFinal(byArray4, 0, n3);
            return byArray4;
        }

        @Override
        public IndexedDigest H_msg(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            Shake256Engine shake256Engine = this;
            int n3 = (shake256Engine.A * this.K + 7) / 8;
            int n4 = this.H;
            int n5 = n4 / this.D;
            int n6 = n4 - n5;
            int n7 = (n5 + 7) / 8;
            int n8 = (n6 + 7) / 8;
            int n9 = n3 + n7 + n8;
            byte[] byArray5 = new byte[n9];
            shake256Engine.treeDigest.update(byArray, 0, byArray.length);
            shake256Engine.treeDigest.update(byArray2, 0, byArray2.length);
            shake256Engine.treeDigest.update(byArray3, 0, byArray3.length);
            shake256Engine.treeDigest.update(byArray4, 0, byArray4.length);
            shake256Engine.treeDigest.doFinal(byArray5, 0, n9);
            byArray = new byte[8];
            System.arraycopy(byArray5, n3, byArray, 8 - n8, n8);
            int n10 = 64 - n6;
            long l3 = Pack.bigEndianToLong(byArray, 0) & -1L >>> n10;
            byArray3 = new byte[4];
            System.arraycopy(byArray5, n3 + n8, byArray3, 4 - n7, n7);
            n5 = Pack.bigEndianToInt(byArray3, 0) & -1 >>> 32 - n5;
            return new IndexedDigest(l3, n5, Arrays.copyOfRange(byArray5, 0, n3));
        }

        @Override
        public byte[] T_l(byte[] byArray, ADRS aDRS, byte[] byArray2) {
            if (this.robust) {
                byArray2 = this.bitmask(byArray, aDRS, byArray2);
            }
            int n3 = this.N;
            byte[] byArray3 = new byte[n3];
            Shake256Engine shake256Engine = this;
            shake256Engine.treeDigest.update(byArray, 0, byArray.length);
            shake256Engine.treeDigest.update(aDRS.value, 0, aDRS.value.length);
            shake256Engine.treeDigest.update(byArray2, 0, byArray2.length);
            shake256Engine.treeDigest.doFinal(byArray3, 0, n3);
            return byArray3;
        }

        @Override
        public byte[] PRF(byte[] byArray, byte[] byArray2, ADRS aDRS) {
            Shake256Engine shake256Engine = this;
            shake256Engine.treeDigest.update(byArray2, 0, byArray2.length);
            shake256Engine.treeDigest.update(aDRS.value, 0, aDRS.value.length);
            int n3 = shake256Engine.N;
            byte[] byArray3 = new byte[n3];
            this.treeDigest.doFinal(byArray3, 0, n3);
            return byArray3;
        }

        @Override
        public byte[] PRF_msg(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            Shake256Engine shake256Engine = this;
            shake256Engine.treeDigest.update(byArray, 0, byArray.length);
            shake256Engine.treeDigest.update(byArray2, 0, byArray2.length);
            shake256Engine.treeDigest.update(byArray3, 0, byArray3.length);
            int n3 = shake256Engine.N;
            byte[] byArray4 = new byte[n3];
            this.treeDigest.doFinal(byArray4, 0, n3);
            return byArray4;
        }

        public byte[] bitmask(byte[] byArray, ADRS aDRS, byte[] byArray2) {
            Shake256Engine shake256Engine = this;
            int n3 = byArray2.length;
            byte[] byArray3 = new byte[n3];
            shake256Engine.treeDigest.update(byArray, 0, byArray.length);
            shake256Engine.treeDigest.update(aDRS.value, 0, aDRS.value.length);
            shake256Engine.treeDigest.doFinal(byArray3, 0, n3);
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray3[n3] = (byte)(byArray3[n3] ^ byArray2[n3]);
            }
            return byArray3;
        }
    }

    public static class Sha256Engine
    extends SPHINCSPlusEngine {
        private final byte[] padding = new byte[64];
        private final Digest treeDigest;
        private final byte[] digestBuf;
        private final HMac treeHMac;
        private final MGF1BytesGenerator mgf1;
        private final byte[] hmacBuf;
        private final Digest msgDigest;

        public Sha256Engine(boolean bl, int n3, int n4, int n5, int n6, int n7, int n8) {
            super(bl, n3, n4, n5, n6, n7, n8);
            SHA256Digest sHA256Digest;
            SHA256Digest sHA256Digest2 = sHA256Digest;
            this.treeDigest = new SHA256Digest();
            if (n3 == 32) {
                SHA512Digest sHA512Digest;
                MGF1BytesGenerator mGF1BytesGenerator;
                SHA512Digest sHA512Digest2;
                HMac hMac;
                SHA512Digest sHA512Digest3;
                Sha256Engine sha256Engine = this;
                Object object = sHA512Digest3;
                sHA512Digest3 = new SHA512Digest();
                sha256Engine.msgDigest = object;
                object = hMac;
                SHA512Digest sHA512Digest4 = sHA512Digest2;
                sHA512Digest2 = new SHA512Digest();
                hMac = new HMac(sHA512Digest4);
                sha256Engine.treeHMac = object;
                object = mGF1BytesGenerator;
                sHA512Digest4 = sHA512Digest;
                sHA512Digest = new SHA512Digest();
                mGF1BytesGenerator = new MGF1BytesGenerator(sHA512Digest4);
                sha256Engine.mgf1 = object;
            } else {
                SHA256Digest sHA256Digest3;
                MGF1BytesGenerator mGF1BytesGenerator;
                SHA256Digest sHA256Digest4;
                HMac hMac;
                SHA256Digest sHA256Digest5;
                Sha256Engine sha256Engine = this;
                Object object = sHA256Digest5;
                sHA256Digest5 = new SHA256Digest();
                sha256Engine.msgDigest = object;
                object = hMac;
                SHA256Digest sHA256Digest6 = sHA256Digest4;
                sHA256Digest4 = new SHA256Digest();
                hMac = new HMac(sHA256Digest6);
                sha256Engine.treeHMac = object;
                object = mGF1BytesGenerator;
                sHA256Digest6 = sHA256Digest3;
                sHA256Digest3 = new SHA256Digest();
                mGF1BytesGenerator = new MGF1BytesGenerator(sHA256Digest6);
                sha256Engine.mgf1 = object;
            }
            this.digestBuf = new byte[sHA256Digest2.getDigestSize()];
            this.hmacBuf = new byte[this.treeHMac.getMacSize()];
        }

        private byte[] compressedADRS(ADRS aDRS) {
            byte[] byArray = new byte[22];
            Object object = byArray;
            ADRS aDRS2 = aDRS;
            System.arraycopy(aDRS2.value, 3, object, 0, 1);
            System.arraycopy(aDRS2.value, 8, object, 1, 8);
            System.arraycopy(aDRS2.value, 19, object, 9, 1);
            System.arraycopy(aDRS2.value, 20, object, 10, 12);
            return byArray;
        }

        @Override
        public byte[] F(byte[] byArray, ADRS object, byte[] byArray2) {
            Sha256Engine sha256Engine = this;
            object = sha256Engine.compressedADRS((ADRS)object);
            if (sha256Engine.robust) {
                byArray2 = this.bitmask256(Arrays.concatenate(byArray, (byte[])object), byArray2);
            }
            Sha256Engine sha256Engine2 = this;
            sha256Engine2.treeDigest.update(byArray, 0, byArray.length);
            byte[] byArray3 = byArray;
            byArray = this.padding;
            int n3 = byArray3.length;
            sha256Engine2.treeDigest.update(byArray, 0, 64 - n3);
            Object object2 = object;
            sha256Engine2.treeDigest.update((byte[])object2, 0, ((Object)object2).length);
            sha256Engine2.treeDigest.update(byArray2, 0, byArray2.length);
            sha256Engine2.treeDigest.doFinal(this.digestBuf, 0);
            return Arrays.copyOfRange(sha256Engine2.digestBuf, 0, this.N);
        }

        @Override
        public byte[] H(byte[] byArray, ADRS object, byte[] byArray2, byte[] byArray3) {
            Sha256Engine sha256Engine = this;
            ADRS aDRS = object;
            object = Arrays.concatenate(byArray2, byArray3);
            byArray2 = sha256Engine.compressedADRS(aDRS);
            if (sha256Engine.robust) {
                object = this.bitmask256(Arrays.concatenate(byArray, byArray2), (byte[])object);
            }
            Sha256Engine sha256Engine2 = this;
            sha256Engine2.treeDigest.update(byArray, 0, byArray.length);
            Sha256Engine sha256Engine3 = this;
            byArray = sha256Engine3.padding;
            int n3 = sha256Engine3.N;
            sha256Engine2.treeDigest.update(byArray, 0, 64 - n3);
            sha256Engine2.treeDigest.update(byArray2, 0, byArray2.length);
            Object object2 = object;
            sha256Engine2.treeDigest.update((byte[])object2, 0, ((Object)object2).length);
            sha256Engine2.treeDigest.doFinal(this.digestBuf, 0);
            return Arrays.copyOfRange(sha256Engine2.digestBuf, 0, this.N);
        }

        @Override
        public IndexedDigest H_msg(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            Sha256Engine sha256Engine = this;
            int n3 = (sha256Engine.A * this.K + 7) / 8;
            int n4 = this.H;
            int n5 = n4 / this.D;
            int n6 = n4 - n5;
            int n7 = (n5 + 7) / 8;
            int n8 = (n6 + 7) / 8;
            byte[] byArray5 = new byte[n3 + n7 + n8];
            byte[] byArray6 = new byte[sha256Engine.msgDigest.getDigestSize()];
            sha256Engine.msgDigest.update(byArray, 0, byArray.length);
            sha256Engine.msgDigest.update(byArray2, 0, byArray2.length);
            sha256Engine.msgDigest.update(byArray3, 0, byArray3.length);
            sha256Engine.msgDigest.update(byArray4, 0, byArray4.length);
            sha256Engine.msgDigest.doFinal(byArray6, 0);
            byArray = this.bitmask(Arrays.concatenate(byArray, byArray2, byArray6), byArray5);
            byArray2 = new byte[8];
            System.arraycopy(byArray, n3, byArray2, 8 - n8, n8);
            int n9 = 64 - n6;
            long l3 = Pack.bigEndianToLong(byArray2, 0) & -1L >>> n9;
            byArray4 = new byte[4];
            System.arraycopy(byArray, n3 + n8, byArray4, 4 - n7, n7);
            n5 = Pack.bigEndianToInt(byArray4, 0) & -1 >>> 32 - n5;
            return new IndexedDigest(l3, n5, Arrays.copyOfRange(byArray, 0, n3));
        }

        @Override
        public byte[] T_l(byte[] byArray, ADRS object, byte[] byArray2) {
            Sha256Engine sha256Engine = this;
            object = sha256Engine.compressedADRS((ADRS)object);
            if (sha256Engine.robust) {
                byArray2 = this.bitmask256(Arrays.concatenate(byArray, (byte[])object), byArray2);
            }
            Sha256Engine sha256Engine2 = this;
            sha256Engine2.treeDigest.update(byArray, 0, byArray.length);
            Sha256Engine sha256Engine3 = this;
            byArray = sha256Engine3.padding;
            int n3 = sha256Engine3.N;
            sha256Engine2.treeDigest.update(byArray, 0, 64 - n3);
            Object object2 = object;
            sha256Engine2.treeDigest.update((byte[])object2, 0, ((Object)object2).length);
            sha256Engine2.treeDigest.update(byArray2, 0, byArray2.length);
            sha256Engine2.treeDigest.doFinal(this.digestBuf, 0);
            return Arrays.copyOfRange(sha256Engine2.digestBuf, 0, this.N);
        }

        @Override
        public byte[] PRF(byte[] byArray, byte[] byArray2, ADRS aDRS) {
            Sha256Engine sha256Engine = this;
            int n3 = byArray2.length;
            this.treeDigest.update(byArray2, 0, byArray2.length);
            byArray2 = sha256Engine.compressedADRS(aDRS);
            sha256Engine.treeDigest.update(byArray2, 0, byArray2.length);
            sha256Engine.treeDigest.doFinal(this.digestBuf, 0);
            return Arrays.copyOfRange(sha256Engine.digestBuf, 0, n3);
        }

        @Override
        public byte[] PRF_msg(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            Sha256Engine sha256Engine = this;
            sha256Engine.treeHMac.init(new KeyParameter(byArray));
            sha256Engine.treeHMac.update(byArray2, 0, byArray2.length);
            sha256Engine.treeHMac.update(byArray3, 0, byArray3.length);
            sha256Engine.treeHMac.doFinal(this.hmacBuf, 0);
            return Arrays.copyOfRange(sha256Engine.hmacBuf, 0, this.N);
        }

        public byte[] bitmask(byte[] byArray, byte[] byArray2) {
            Sha256Engine sha256Engine = this;
            int n3 = byArray2.length;
            byte[] byArray3 = new byte[n3];
            sha256Engine.mgf1.init(new MGFParameters(byArray));
            sha256Engine.mgf1.generateBytes(byArray3, 0, n3);
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray3[n3] = (byte)(byArray3[n3] ^ byArray2[n3]);
            }
            return byArray3;
        }

        public byte[] bitmask256(byte[] byArray, byte[] byArray2) {
            MGFParameters mGFParameters;
            SHA256Digest sHA256Digest;
            int n3 = byArray2.length;
            byte[] byArray3 = new byte[n3];
            Object object = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            MGF1BytesGenerator mGF1BytesGenerator = new MGF1BytesGenerator((Digest)object);
            object = mGFParameters;
            mGFParameters = new MGFParameters(byArray);
            mGF1BytesGenerator.init((DerivationParameters)object);
            mGF1BytesGenerator.generateBytes(byArray3, 0, n3);
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                byArray3[n3] = (byte)(byArray3[n3] ^ byArray2[n3]);
            }
            return byArray3;
        }
    }
}

