/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.HT;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.PK;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.SK;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPublicKeyParameters;
import java.security.SecureRandom;

public class SPHINCSPlusKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private SPHINCSPlusParameters parameters;

    private byte[] sec_rand(int n3) {
        byte[] byArray = new byte[n3];
        this.random.nextBytes(byArray);
        return byArray;
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.parameters = ((SPHINCSPlusKeyGenerationParameters)keyGenerationParameters).getParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        PK pK;
        SK sK;
        SPHINCSPlusKeyPairGenerator sPHINCSPlusKeyPairGenerator = this;
        SPHINCSPlusEngine sPHINCSPlusEngine = sPHINCSPlusKeyPairGenerator.parameters.getEngine();
        SK sK2 = sK;
        byte[] byArray = this.sec_rand(sPHINCSPlusEngine.N);
        sK = new SK(byArray, this.sec_rand(sPHINCSPlusEngine.N));
        byArray = sPHINCSPlusKeyPairGenerator.sec_rand(sPHINCSPlusEngine.N);
        PK pK2 = pK;
        pK = new PK(byArray, new HT((SPHINCSPlusEngine)sPHINCSPlusEngine, (byte[])sK2.seed, (byte[])byArray).htPubKey);
        return new AsymmetricCipherKeyPair(new SPHINCSPlusPublicKeyParameters(this.parameters, pK2), new SPHINCSPlusPrivateKeyParameters(this.parameters, sK2, pK2));
    }
}

