/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.PK;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SPHINCSPlusPublicKeyParameters
extends SPHINCSPlusKeyParameters {
    private final PK pk;

    public SPHINCSPlusPublicKeyParameters(SPHINCSPlusParameters sPHINCSPlusParameters, byte[] byArray) {
        super(false, sPHINCSPlusParameters);
        int n3 = sPHINCSPlusParameters.getEngine().N;
        int n4 = n3 * 2;
        if (byArray.length == n4) {
            PK pK;
            SPHINCSPlusPublicKeyParameters sPHINCSPlusPublicKeyParameters = pK2;
            PK pK2 = pK;
            byArray = Arrays.copyOfRange(byArray, 0, n3);
            pK = new PK(byArray, Arrays.copyOfRange(byArray, n3, n4));
            sPHINCSPlusPublicKeyParameters.pk = pK2;
            return;
        }
        throw new IllegalArgumentException("public key encoding does not match parameters");
    }

    public SPHINCSPlusPublicKeyParameters(SPHINCSPlusParameters sPHINCSPlusParameters, PK pK) {
        super(false, sPHINCSPlusParameters);
        this.pk = pK;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.pk.seed);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.pk.root);
    }

    public byte[] getEncoded() {
        byte[] byArray = Pack.intToBigEndian(SPHINCSPlusParameters.getID(((SPHINCSPlusKeyParameters)object).getParameters()));
        PK pK = ((SPHINCSPlusPublicKeyParameters)object).pk;
        Object object = pK.seed;
        return Arrays.concatenate(byArray, (byte[])object, pK.root);
    }
}

