/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1BitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.BCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.IOException;
import java.io.InputStream;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo object) {
        Object object2 = ((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getAlgorithm();
        if (((ASN1ObjectIdentifier)object2).on(BCObjectIdentifiers.qTESLA)) {
            object2 = ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey());
            int n3 = Utils.qTeslaLookupSecurityCategory(((PrivateKeyInfo)object).getPrivateKeyAlgorithm());
            return new QTESLAPrivateKeyParameters(n3, ((ASN1OctetString)object2).getOctets());
        }
        if (((ASN1Primitive)object2).equals(BCObjectIdentifiers.sphincs256)) {
            return new SPHINCSPrivateKeyParameters(ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey()).getOctets(), Utils.sphincs256LookupTreeAlgName(SPHINCS256KeyParams.getInstance(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getParameters())));
        }
        if (((ASN1Primitive)object2).equals(BCObjectIdentifiers.newHope)) {
            return new NHPrivateKeyParameters(PrivateKeyFactory.convert(ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey()).getOctets()));
        }
        if (((ASN1Primitive)object2).equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
            byte[] byArray = ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey()).getOctets();
            object2 = byArray;
            object = ((PrivateKeyInfo)object).getPublicKeyData();
            if (Pack.bigEndianToInt(byArray, 0) == 1) {
                if (object != null) {
                    Object object3 = object2;
                    Object object4 = object = (Object)((ASN1BitString)object).getOctets();
                    return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange((byte[])object3, 4, ((Object)object3).length), Arrays.copyOfRange((byte[])object4, 4, ((Object)object4).length));
                }
                Object object5 = object2;
                return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange((byte[])object5, 4, ((Object)object5).length));
            }
            if (object != null) {
                Object object6 = object2;
                object = ((ASN1BitString)object).getOctets();
                return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange((byte[])object6, 4, ((Object)object6).length), (byte[])object);
            }
            Object object7 = object2;
            return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange((byte[])object7, 4, ((Object)object7).length));
        }
        if (((ASN1Primitive)object2).equals(BCObjectIdentifiers.xmss)) {
            XMSSPrivateKeyParameters.Builder builder;
            block31: {
                XMSSPrivateKey xMSSPrivateKey;
                block30: {
                    int n4;
                    Object object8;
                    XMSSParameters xMSSParameters;
                    XMSSParameters xMSSParameters2;
                    XMSSPrivateKey xMSSPrivateKey2;
                    XMSSPrivateKeyParameters.Builder builder2;
                    XMSSPrivateKeyParameters.Builder builder3;
                    PrivateKeyInfo privateKeyInfo = object;
                    object = XMSSKeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
                    object2 = ((XMSSKeyParams)object).getTreeDigest().getAlgorithm();
                    xMSSPrivateKey = XMSSPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
                    try {
                        XMSSParameters xMSSParameters3;
                        builder2 = builder3;
                        xMSSPrivateKey2 = xMSSPrivateKey;
                        xMSSParameters2 = xMSSParameters3;
                        xMSSParameters = xMSSParameters3;
                        object8 = object2;
                        n4 = ((XMSSKeyParams)object).getHeight();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException(b.a("ClassNotFoundException processing BDS state: ").append(classNotFoundException.getMessage()).toString());
                    }
                    xMSSParameters2(n4, Utils.getDigest((ASN1ObjectIdentifier)object8));
                    builder2(xMSSParameters);
                    builder = builder3.withIndex(xMSSPrivateKey2.getIndex()).withSecretKeySeed(xMSSPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKey.getPublicSeed()).withRoot(xMSSPrivateKey.getRoot());
                    if (xMSSPrivateKey.getVersion() == 0) break block30;
                    builder.withMaxIndex(xMSSPrivateKey.getMaxIndex());
                }
                if (xMSSPrivateKey.getBdsState() == null) break block31;
                builder.withBDSState(((BDS)XMSSUtil.deserialize(xMSSPrivateKey.getBdsState(), BDS.class)).withWOTSDigest((ASN1ObjectIdentifier)object2));
            }
            return builder.build();
        }
        if (((ASN1Primitive)object2).equals(PQCObjectIdentifiers.xmss_mt)) {
            XMSSMTPrivateKeyParameters.Builder builder;
            block33: {
                XMSSMTPrivateKey xMSSMTPrivateKey;
                block32: {
                    XMSSMTParameters xMSSMTParameters;
                    XMSSMTPrivateKeyParameters.Builder builder4;
                    ASN1Object aSN1Object = object;
                    object = XMSSMTKeyParams.getInstance(((PrivateKeyInfo)aSN1Object).getPrivateKeyAlgorithm().getParameters());
                    object2 = ((XMSSMTKeyParams)object).getTreeDigest().getAlgorithm();
                    try {
                        xMSSMTPrivateKey = XMSSMTPrivateKey.getInstance(((PrivateKeyInfo)aSN1Object).parsePrivateKey());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException(b.a("ClassNotFoundException processing BDS state: ").append(classNotFoundException.getMessage()).toString());
                    }
                    XMSSMTPrivateKeyParameters.Builder builder5 = builder4;
                    XMSSMTPrivateKey xMSSMTPrivateKey2 = xMSSMTPrivateKey;
                    XMSSMTParameters xMSSMTParameters2 = xMSSMTParameters;
                    XMSSMTParameters xMSSMTParameters3 = xMSSMTParameters;
                    Object object9 = object2;
                    Object object10 = object;
                    Object object11 = object10;
                    int n5 = ((XMSSMTKeyParams)object10).getHeight();
                    int n6 = ((XMSSMTKeyParams)object11).getLayers();
                    Digest digest = Utils.getDigest((ASN1ObjectIdentifier)object9);
                    xMSSMTParameters2(n5, n6, digest);
                    builder5(xMSSMTParameters3);
                    builder = builder4.withIndex(xMSSMTPrivateKey2.getIndex()).withSecretKeySeed(xMSSMTPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSMTPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSMTPrivateKey.getPublicSeed()).withRoot(xMSSMTPrivateKey.getRoot());
                    if (xMSSMTPrivateKey.getVersion() == 0) break block32;
                    builder.withMaxIndex(xMSSMTPrivateKey.getMaxIndex());
                }
                if (xMSSMTPrivateKey.getBdsState() == null) break block33;
                builder.withBDSState(((BDSStateMap)XMSSUtil.deserialize(xMSSMTPrivateKey.getBdsState(), BDSStateMap.class)).withWOTSDigest((ASN1ObjectIdentifier)object2));
            }
            return builder.build();
        }
        throw new RuntimeException("algorithm identifier in private key not recognised");
    }

    private static short[] convert(byte[] byArray) {
        int n3 = byArray.length / 2;
        short[] sArray = new short[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            sArray[i3] = Pack.littleEndianToShort(byArray, i3 * 2);
        }
        return sArray;
    }
}

