/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.Composer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.IOException;

public class PrivateKeyInfoFactory {
    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) {
        return PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter object, ASN1Set object2) {
        if (object instanceof QTESLAPrivateKeyParameters) {
            DEROctetString dEROctetString;
            ASN1Object aSN1Object;
            object = (QTESLAPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier = aSN1Object = Utils.qTeslaLookupAlgID(((QTESLAPrivateKeyParameters)object).getSecurityCategory());
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(((QTESLAPrivateKeyParameters)object).getSecret());
            return new PrivateKeyInfo(algorithmIdentifier, aSN1Object, (ASN1Set)object2);
        }
        if (object instanceof SPHINCSPrivateKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (SPHINCSPrivateKeyParameters)object;
            object2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(((SPHINCSKeyParameters)object).getTreeDigest())));
            return new PrivateKeyInfo((AlgorithmIdentifier)object2, new DEROctetString(((SPHINCSPrivateKeyParameters)object).getKeyData()));
        }
        if (object instanceof NHPrivateKeyParameters) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            NHPrivateKeyParameters nHPrivateKeyParameters = (NHPrivateKeyParameters)object;
            object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = nHPrivateKeyParameters.getSecData();
            object2 = sArray;
            byte[] byArray = new byte[sArray.length * 2];
            for (int i3 = 0; i3 != ((Object)object2).length; ++i3) {
                Pack.shortToLittleEndian((short)object2[i3], byArray, i3 * 2);
            }
            object2 = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            return new PrivateKeyInfo((AlgorithmIdentifier)object, (ASN1Encodable)object2);
        }
        if (object instanceof LMSPrivateKeyParameters) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            object = (LMSPrivateKeyParameters)object;
            byte[] byArray = Composer.compose().u32str(1).bytes((Encodable)object).build();
            object = Composer.compose().u32str(1).bytes(((LMSPrivateKeyParameters)object).getPublicKey()).build();
            ASN1Object aSN1Object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            AlgorithmIdentifier algorithmIdentifier2 = aSN1Object;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            return new PrivateKeyInfo(algorithmIdentifier2, aSN1Object, (ASN1Set)object2, (byte[])object);
        }
        if (object instanceof HSSPrivateKeyParameters) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            object = (HSSPrivateKeyParameters)object;
            byte[] byArray = Composer.compose().u32str(((HSSPrivateKeyParameters)object).getL()).bytes((Encodable)object).build();
            object = Composer.compose().u32str(((HSSPrivateKeyParameters)object).getL()).bytes(((HSSPrivateKeyParameters)object).getPublicKey().getLMSPublicKey()).build();
            ASN1Object aSN1Object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            AlgorithmIdentifier algorithmIdentifier3 = aSN1Object;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            return new PrivateKeyInfo(algorithmIdentifier3, aSN1Object, (ASN1Set)object2, (byte[])object);
        }
        if (object instanceof XMSSPrivateKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (XMSSPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier4 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(((XMSSPrivateKeyParameters)object).getParameters().getHeight(), Utils.xmssLookupTreeAlgID(((XMSSKeyParameters)object).getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier4, PrivateKeyInfoFactory.xmssCreateKeyStructure((XMSSPrivateKeyParameters)object), (ASN1Set)object2);
        }
        if (object instanceof XMSSMTPrivateKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (XMSSMTPrivateKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier5 = algorithmIdentifier;
            Object object3 = object;
            int n3 = ((XMSSMTPrivateKeyParameters)object3).getParameters().getLayers();
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(((XMSSMTPrivateKeyParameters)object).getParameters().getHeight(), n3, Utils.xmssLookupTreeAlgID(((XMSSMTKeyParameters)object3).getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier5, PrivateKeyInfoFactory.xmssmtCreateKeyStructure((XMSSMTPrivateKeyParameters)object), (ASN1Set)object2);
        }
        throw new IOException("key parameters not recognized");
    }

    private static XMSSPrivateKey xmssCreateKeyStructure(XMSSPrivateKeyParameters object) {
        int n3;
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = object;
        object = xMSSPrivateKeyParameters.getEncoded();
        int n4 = xMSSPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n5 = xMSSPrivateKeyParameters.getParameters().getHeight();
        if (XMSSUtil.isIndexValid(n5, n3 = (int)XMSSUtil.bytesToXBigEndian((byte[])object, 0, 4))) {
            Object object2 = object;
            byte[] byArray = XMSSUtil.extractBytesAtOffset((byte[])object2, 4, n4);
            int n6 = n4 + 4;
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])object, n6, n4);
            int n7 = n6 + n4;
            byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])object, n7, n4);
            int n8 = n7 + n4;
            byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])object, n8, n4);
            int n9 = n8 + n4;
            byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])object2, n9, ((Object)object).length - n9);
            object = byArray5;
            try {
                BDS bDS = (BDS)XMSSUtil.deserialize(byArray5, BDS.class);
                if (bDS.getMaxIndex() != (1 << n5) - 1) {
                    n5 = bDS.getMaxIndex();
                    return new XMSSPrivateKey(n3, byArray, byArray2, byArray3, byArray4, (byte[])object, n5);
                }
                return new XMSSPrivateKey(n3, byArray, byArray2, byArray3, byArray4, (byte[])object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(b.a("cannot parse BDS: ").append(classNotFoundException.getMessage()).toString());
            }
        }
        throw new IllegalArgumentException("index out of bounds");
    }

    private static XMSSMTPrivateKey xmssmtCreateKeyStructure(XMSSMTPrivateKeyParameters object) {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = object;
        object = xMSSMTPrivateKeyParameters.getEncoded();
        int n3 = xMSSMTPrivateKeyParameters.getParameters().getTreeDigestSize();
        int n4 = xMSSMTPrivateKeyParameters.getParameters().getHeight();
        int n5 = (n4 + 7) / 8;
        int n6 = 0;
        long l3 = (int)XMSSUtil.bytesToXBigEndian((byte[])object, 0, n5);
        if (XMSSUtil.isIndexValid(n4, l3)) {
            byte[] byArray = XMSSUtil.extractBytesAtOffset((byte[])object, n5 += n6, n3);
            n6 = n5 + n3;
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])object, n6, n3);
            int n7 = n6 + n3;
            byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])object, n7, n3);
            int n8 = n7 + n3;
            byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])object, n8, n3);
            int n9 = n8 + n3;
            byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])object, n9, ((Object)object).length - n9);
            object = byArray5;
            try {
                BDSStateMap bDSStateMap = (BDSStateMap)XMSSUtil.deserialize(byArray5, BDSStateMap.class);
                if (bDSStateMap.getMaxIndex() != (1L << n4) - 1L) {
                    long l4 = bDSStateMap.getMaxIndex();
                    return new XMSSMTPrivateKey(l3, byArray, byArray2, byArray3, byArray4, (byte[])object, l4);
                }
                return new XMSSMTPrivateKey(l3, byArray, byArray2, byArray3, byArray4, (byte[])object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(b.a("cannot parse BDSStateMap: ").append(classNotFoundException.getMessage()).toString());
            }
        }
        throw new IllegalArgumentException("index out of bounds");
    }
}

