/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.XMSSPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class PublicKeyFactory {
    private static Map converters = new HashMap<ASN1ObjectIdentifier, QTeslaConverter>();

    public static AsymmetricKeyParameter createKey(byte[] byArray) {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo, null);
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
        AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
        SubjectPublicKeyInfoConverter subjectPublicKeyInfoConverter = (SubjectPublicKeyInfoConverter)converters.get(algorithmIdentifier.getAlgorithm());
        if (subjectPublicKeyInfoConverter != null) {
            return subjectPublicKeyInfoConverter.getPublicKeyParameters(subjectPublicKeyInfo, object);
        }
        throw new IOException(b.a("algorithm identifier in public key not recognised: ").append(algorithmIdentifier.getAlgorithm()).toString());
    }

    static {
        converters.put(PQCObjectIdentifiers.qTESLA_p_I, new QTeslaConverter(null));
        converters.put(PQCObjectIdentifiers.qTESLA_p_III, new QTeslaConverter(null));
        converters.put(PQCObjectIdentifiers.sphincs256, new SPHINCSConverter(null));
        converters.put(PQCObjectIdentifiers.newHope, new NHConverter(null));
        converters.put(PQCObjectIdentifiers.xmss, new XMSSConverter(null));
        converters.put(PQCObjectIdentifiers.xmss_mt, new XMSSMTConverter(null));
        converters.put(IsaraObjectIdentifiers.id_alg_xmss, new XMSSConverter(null));
        converters.put(IsaraObjectIdentifiers.id_alg_xmssmt, new XMSSMTConverter(null));
        converters.put(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, new LMSConverter(null));
    }

    public static class LMSConverter
    extends SubjectPublicKeyInfoConverter {
        private LMSConverter() {
            super(null);
        }

        public /* synthetic */ LMSConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            byte[] byArray = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets();
            Object object2 = byArray;
            if (Pack.bigEndianToInt(byArray, 0) == 1) {
                Object object3 = object2;
                return LMSPublicKeyParameters.getInstance(Arrays.copyOfRange((byte[])object3, 4, ((Object)object3).length));
            }
            if (((Object)object2).length == 64) {
                Object object4 = object2;
                object2 = Arrays.copyOfRange((byte[])object4, 4, ((Object)object4).length);
            }
            return HSSPublicKeyParameters.getInstance(object2);
        }
    }

    public static class XMSSMTConverter
    extends SubjectPublicKeyInfoConverter {
        private XMSSMTConverter() {
            super(null);
        }

        public /* synthetic */ XMSSMTConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo aSN1Object, Object object) {
            Object object2 = XMSSMTKeyParams.getInstance(aSN1Object.getAlgorithm().getParameters());
            if (object2 != null) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = aSN1Object;
                aSN1Object = ((XMSSMTKeyParams)object2).getTreeDigest().getAlgorithm();
                object = XMSSPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
                Object object3 = object2;
                int n3 = ((XMSSMTKeyParams)object3).getHeight();
                int n4 = ((XMSSMTKeyParams)object3).getLayers();
                Digest digest = Utils.getDigest((ASN1ObjectIdentifier)aSN1Object);
                return new XMSSMTPublicKeyParameters.Builder(new XMSSMTParameters(n3, n4, digest)).withPublicSeed(((XMSSPublicKey)object).getPublicSeed()).withRoot(((XMSSPublicKey)object).getRoot()).build();
            }
            object2 = ASN1OctetString.getInstance(aSN1Object.parsePublicKey()).getOctets();
            return new XMSSMTPublicKeyParameters.Builder(XMSSMTParameters.lookupByOID(Pack.bigEndianToInt((byte[])object2, 0))).withPublicKey((byte[])object2).build();
        }
    }

    public static class XMSSConverter
    extends SubjectPublicKeyInfoConverter {
        private XMSSConverter() {
            super(null);
        }

        public /* synthetic */ XMSSConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo aSN1Object, Object object) {
            Object object2 = XMSSKeyParams.getInstance(aSN1Object.getAlgorithm().getParameters());
            if (object2 != null) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = aSN1Object;
                aSN1Object = ((XMSSKeyParams)object2).getTreeDigest().getAlgorithm();
                object = XMSSPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
                int n3 = ((XMSSKeyParams)object2).getHeight();
                return new XMSSPublicKeyParameters.Builder(new XMSSParameters(n3, Utils.getDigest((ASN1ObjectIdentifier)aSN1Object))).withPublicSeed(((XMSSPublicKey)object).getPublicSeed()).withRoot(((XMSSPublicKey)object).getRoot()).build();
            }
            object2 = ASN1OctetString.getInstance(aSN1Object.parsePublicKey()).getOctets();
            return new XMSSPublicKeyParameters.Builder(XMSSParameters.lookupByOID(Pack.bigEndianToInt((byte[])object2, 0))).withPublicKey((byte[])object2).build();
        }
    }

    public static class NHConverter
    extends SubjectPublicKeyInfoConverter {
        private NHConverter() {
            super(null);
        }

        public /* synthetic */ NHConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new NHPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getBytes());
        }
    }

    public static class SPHINCSConverter
    extends SubjectPublicKeyInfoConverter {
        private SPHINCSConverter() {
            super(null);
        }

        public /* synthetic */ SPHINCSConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new SPHINCSPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getBytes(), Utils.sphincs256LookupTreeAlgName(SPHINCS256KeyParams.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters())));
        }
    }

    public static class QTeslaConverter
    extends SubjectPublicKeyInfoConverter {
        private QTeslaConverter() {
            super(null);
        }

        public /* synthetic */ QTeslaConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new QTESLAPublicKeyParameters(Utils.qTeslaLookupSecurityCategory(subjectPublicKeyInfo.getAlgorithm()), subjectPublicKeyInfo.getPublicKeyData().getOctets());
        }
    }

    public static abstract class SubjectPublicKeyInfoConverter {
        private SubjectPublicKeyInfoConverter() {
        }

        public /* synthetic */ SubjectPublicKeyInfoConverter(1 var1_1) {
            this();
        }

        public abstract AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo var1, Object var2);
    }
}

