/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.util.HashMap;
import java.util.Map;

class Utils {
    public static final AlgorithmIdentifier AlgID_qTESLA_p_I;
    public static final AlgorithmIdentifier AlgID_qTESLA_p_III;
    public static final AlgorithmIdentifier SPHINCS_SHA3_256;
    public static final AlgorithmIdentifier SPHINCS_SHA512_256;
    public static final AlgorithmIdentifier XMSS_SHA256;
    public static final AlgorithmIdentifier XMSS_SHA512;
    public static final AlgorithmIdentifier XMSS_SHAKE128;
    public static final AlgorithmIdentifier XMSS_SHAKE256;
    public static final Map categories;

    public static int qTeslaLookupSecurityCategory(AlgorithmIdentifier algorithmIdentifier) {
        return (Integer)categories.get(algorithmIdentifier.getAlgorithm());
    }

    public static AlgorithmIdentifier qTeslaLookupAlgID(int n3) {
        if (n3 != 5) {
            if (n3 == 6) {
                return AlgID_qTESLA_p_III;
            }
            throw new IllegalArgumentException(a.a("unknown security category: ", n3));
        }
        return AlgID_qTESLA_p_I;
    }

    public static AlgorithmIdentifier sphincs256LookupTreeAlgID(String string2) {
        if (string2.equals("SHA3-256")) {
            return SPHINCS_SHA3_256;
        }
        if (string2.equals("SHA-512/256")) {
            return SPHINCS_SHA512_256;
        }
        throw new IllegalArgumentException(i.a("unknown tree digest: ", string2));
    }

    public static AlgorithmIdentifier xmssLookupTreeAlgID(String string2) {
        if (string2.equals("SHA-256")) {
            return XMSS_SHA256;
        }
        if (string2.equals("SHA-512")) {
            return XMSS_SHA512;
        }
        if (string2.equals("SHAKE128")) {
            return XMSS_SHAKE128;
        }
        if (string2.equals("SHAKE256")) {
            return XMSS_SHAKE256;
        }
        throw new IllegalArgumentException(i.a("unknown tree digest: ", string2));
    }

    public static String sphincs256LookupTreeAlgName(SPHINCS256KeyParams aSN1Object) {
        if (((AlgorithmIdentifier)(aSN1Object = ((SPHINCS256KeyParams)aSN1Object).getTreeDigest())).getAlgorithm().equals(SPHINCS_SHA3_256.getAlgorithm())) {
            return "SHA3-256";
        }
        if (((AlgorithmIdentifier)aSN1Object).getAlgorithm().equals(SPHINCS_SHA512_256.getAlgorithm())) {
            return "SHA-512/256";
        }
        throw new IllegalArgumentException(b.a("unknown tree digest: ").append(((AlgorithmIdentifier)aSN1Object).getAlgorithm()).toString());
    }

    public static Digest getDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha512)) {
            return new SHA512Digest();
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_shake128)) {
            return new SHAKEDigest(128);
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_shake256)) {
            return new SHAKEDigest(256);
        }
        throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.a.a("unrecognized digest OID: ", aSN1ObjectIdentifier));
    }

    static {
        HashMap<ASN1ObjectIdentifier, Integer> hashMap;
        HashMap<ASN1ObjectIdentifier, Integer> hashMap2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = PQCObjectIdentifiers.qTESLA_p_I;
        AlgID_qTESLA_p_I = new AlgorithmIdentifier(aSN1ObjectIdentifier);
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = PQCObjectIdentifiers.qTESLA_p_III;
        AlgID_qTESLA_p_III = new AlgorithmIdentifier(aSN1ObjectIdentifier2);
        SPHINCS_SHA3_256 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha3_256);
        SPHINCS_SHA512_256 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512_256);
        XMSS_SHA256 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        XMSS_SHA512 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512);
        XMSS_SHAKE128 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake128);
        XMSS_SHAKE256 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_shake256);
        HashMap<ASN1ObjectIdentifier, Integer> hashMap3 = hashMap2 = hashMap;
        hashMap3();
        categories = hashMap3;
        hashMap2.put(aSN1ObjectIdentifier, Integers.valueOf(5));
        hashMap.put(aSN1ObjectIdentifier2, Integers.valueOf(6));
    }
}

