/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDSTreeHash;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.HashTreeAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.LTreeAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSNodeUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public final class BDS
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient WOTSPlus wotsPlus;
    private final int treeHeight;
    private final List<BDSTreeHash> treeHashInstances;
    private int k;
    private XMSSNode root;
    private List<XMSSNode> authenticationPath;
    private Map<Integer, LinkedList<XMSSNode>> retain;
    private Stack<XMSSNode> stack;
    private Map<Integer, XMSSNode> keep;
    private int index;
    private boolean used;
    private transient int maxIndex;

    public BDS(XMSSParameters xMSSParameters, int n3, int n4) {
        BDS bDS = wOTSPlus;
        XMSSParameters xMSSParameters2 = xMSSParameters;
        WOTSPlus wOTSPlus = xMSSParameters2.getWOTSPlus();
        int n5 = xMSSParameters2.getHeight();
        int n6 = xMSSParameters2.getK();
        bDS(wOTSPlus, n5, n6, n4);
        bDS.maxIndex = n3;
        bDS.index = n4;
        bDS.used = true;
    }

    public BDS(XMSSParameters xMSSParameters, byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        BDS bDS = wOTSPlus;
        BDS bDS2 = wOTSPlus;
        XMSSParameters xMSSParameters2 = xMSSParameters;
        WOTSPlus wOTSPlus = xMSSParameters2.getWOTSPlus();
        int n3 = xMSSParameters2.getHeight();
        int n4 = xMSSParameters2.getK();
        int n5 = xMSSParameters2.getHeight();
        int n6 = (1 << n5) - 1;
        bDS2(wOTSPlus, n3, n4, n6);
        bDS.initialize(byArray, byArray2, oTSHashAddress);
    }

    public BDS(XMSSParameters object, byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress, int n3) {
        XMSSParameters xMSSParameters = object;
        object = xMSSParameters.getWOTSPlus();
        int n4 = xMSSParameters.getHeight();
        int n5 = xMSSParameters.getK();
        int n6 = xMSSParameters.getHeight();
        int n7 = (1 << n6) - 1;
        this((WOTSPlus)object, n4, n5, n7);
        this.initialize(byArray, byArray2, oTSHashAddress);
        while (this.index < n3) {
            this.nextAuthenticationPath(byArray, byArray2, oTSHashAddress);
            this.used = false;
        }
    }

    private BDS(WOTSPlus wOTSPlus, int n3, int n4, int n5) {
        int n6;
        serializable.wotsPlus = wOTSPlus;
        serializable.treeHeight = n3;
        serializable.maxIndex = n5;
        serializable.k = n4;
        if (n4 <= n3 && n4 >= 2 && (n6 = n3 - n4) % 2 == 0) {
            TreeMap treeMap;
            ArrayList<BDSTreeHash> arrayList;
            Stack stack;
            TreeMap treeMap2;
            ArrayList<XMSSNode> arrayList2;
            BDS bDS = serializable;
            ArrayList<BDSTreeHash> arrayList3 = arrayList2;
            arrayList2 = new ArrayList<XMSSNode>();
            bDS.authenticationPath = arrayList3;
            arrayList3 = treeMap2;
            treeMap2 = new TreeMap();
            bDS.retain = arrayList3;
            arrayList3 = stack;
            stack = new Stack();
            bDS.stack = arrayList3;
            arrayList3 = arrayList;
            arrayList = new ArrayList<BDSTreeHash>();
            bDS.treeHashInstances = arrayList3;
            for (int i3 = 0; i3 < n6; ++i3) {
                serializable.treeHashInstances.add(new BDSTreeHash(i3));
            }
            BDS bDS2 = serializable;
            Serializable serializable = treeMap;
            treeMap = new TreeMap();
            bDS2.keep = serializable;
            bDS2.index = 0;
            bDS2.used = false;
            return;
        }
        throw new IllegalArgumentException("illegal value for BDS parameter k");
    }

    public BDS(BDS bDS) {
        Stack stack;
        ArrayList<XMSSNode> arrayList;
        BDS bDS2 = this;
        this.wotsPlus = new WOTSPlus(bDS.wotsPlus.getParams());
        this.treeHeight = bDS.treeHeight;
        this.k = bDS.k;
        bDS2.root = bDS.root;
        Object object = arrayList;
        ArrayList<XMSSNode> arrayList2 = object;
        arrayList2();
        this.authenticationPath = arrayList2;
        arrayList.addAll(bDS.authenticationPath);
        bDS2.retain = new TreeMap<Integer, LinkedList<XMSSNode>>();
        for (Integer n3 : bDS.retain.keySet()) {
            this.retain.put(n3, (LinkedList)bDS.retain.get(n3).clone());
        }
        object = stack;
        Stack stack2 = object;
        stack2();
        this.stack = stack2;
        ((AbstractCollection)stack).addAll(bDS.stack);
        this.treeHashInstances = new ArrayList<BDSTreeHash>();
        object = bDS.treeHashInstances.iterator();
        while (object.hasNext()) {
            this.treeHashInstances.add(((BDSTreeHash)object.next()).clone());
        }
        this.keep = new TreeMap<Integer, XMSSNode>(bDS.keep);
        this.index = bDS.index;
        this.maxIndex = bDS.maxIndex;
        this.used = bDS.used;
    }

    private BDS(BDS bDS, byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        Stack stack;
        ArrayList<XMSSNode> arrayList;
        BDS bDS2 = this;
        this.wotsPlus = new WOTSPlus(bDS.wotsPlus.getParams());
        this.treeHeight = bDS.treeHeight;
        this.k = bDS.k;
        bDS2.root = bDS.root;
        Object object = arrayList;
        ArrayList<XMSSNode> arrayList2 = object;
        arrayList2();
        this.authenticationPath = arrayList2;
        arrayList.addAll(bDS.authenticationPath);
        bDS2.retain = new TreeMap<Integer, LinkedList<XMSSNode>>();
        for (Integer n3 : bDS.retain.keySet()) {
            this.retain.put(n3, (LinkedList)bDS.retain.get(n3).clone());
        }
        object = stack;
        Stack stack2 = object;
        stack2();
        this.stack = stack2;
        ((AbstractCollection)stack).addAll(bDS.stack);
        this.treeHashInstances = new ArrayList<BDSTreeHash>();
        object = bDS.treeHashInstances.iterator();
        while (object.hasNext()) {
            this.treeHashInstances.add(((BDSTreeHash)object.next()).clone());
        }
        BDS bDS3 = this;
        this.keep = new TreeMap<Integer, XMSSNode>(bDS.keep);
        this.index = bDS.index;
        bDS3.maxIndex = bDS.maxIndex;
        bDS3.used = false;
        this.nextAuthenticationPath(byArray, byArray2, oTSHashAddress);
    }

    private BDS(BDS bDS, ASN1ObjectIdentifier object) {
        Stack stack;
        ArrayList arrayList;
        BDS bDS2 = this;
        this.wotsPlus = new WOTSPlus(new WOTSPlusParameters((ASN1ObjectIdentifier)object));
        this.treeHeight = bDS.treeHeight;
        this.k = bDS.k;
        bDS2.root = bDS.root;
        object = arrayList;
        ArrayList<XMSSNode> arrayList2 = object;
        arrayList2();
        this.authenticationPath = arrayList2;
        arrayList.addAll(bDS.authenticationPath);
        bDS2.retain = new TreeMap<Integer, LinkedList<XMSSNode>>();
        for (Integer n3 : bDS.retain.keySet()) {
            this.retain.put(n3, (LinkedList)bDS.retain.get(n3).clone());
        }
        object = stack;
        Stack stack2 = object;
        stack2();
        this.stack = stack2;
        ((AbstractCollection)stack).addAll(bDS.stack);
        this.treeHashInstances = new ArrayList<BDSTreeHash>();
        object = bDS.treeHashInstances.iterator();
        while (object.hasNext()) {
            this.treeHashInstances.add(((BDSTreeHash)object.next()).clone());
        }
        this.keep = new TreeMap<Integer, XMSSNode>(bDS.keep);
        this.index = bDS.index;
        this.maxIndex = bDS.maxIndex;
        this.used = bDS.used;
        this.validate();
    }

    private BDS(BDS bDS, int n3, ASN1ObjectIdentifier object) {
        Stack stack;
        ArrayList arrayList;
        BDS bDS2 = this;
        this.wotsPlus = new WOTSPlus(new WOTSPlusParameters((ASN1ObjectIdentifier)object));
        this.treeHeight = bDS.treeHeight;
        this.k = bDS.k;
        bDS2.root = bDS.root;
        object = arrayList;
        ArrayList<XMSSNode> arrayList2 = object;
        arrayList2();
        this.authenticationPath = arrayList2;
        arrayList.addAll(bDS.authenticationPath);
        bDS2.retain = new TreeMap<Integer, LinkedList<XMSSNode>>();
        for (Integer n4 : bDS.retain.keySet()) {
            this.retain.put(n4, (LinkedList)bDS.retain.get(n4).clone());
        }
        object = stack;
        Stack stack2 = object;
        stack2();
        this.stack = stack2;
        ((AbstractCollection)stack).addAll(bDS.stack);
        this.treeHashInstances = new ArrayList<BDSTreeHash>();
        object = bDS.treeHashInstances.iterator();
        while (object.hasNext()) {
            this.treeHashInstances.add(((BDSTreeHash)object.next()).clone());
        }
        this.keep = new TreeMap<Integer, XMSSNode>(bDS.keep);
        this.index = bDS.index;
        this.maxIndex = n3;
        this.used = bDS.used;
        this.validate();
    }

    private void initialize(byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        if (oTSHashAddress != null) {
            LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
            HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
            for (int i3 = 0; i3 < 1 << this.treeHeight; ++i3) {
                BDS bDS = this;
                oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(i3).withChainAddress(oTSHashAddress.getChainAddress()).withHashAddress(oTSHashAddress.getHashAddress()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
                WOTSPlus wOTSPlus = bDS.wotsPlus;
                wOTSPlus.importKeys(wOTSPlus.getWOTSPlusSecretKey(byArray2, oTSHashAddress), byArray);
                Object object = bDS.wotsPlus.getPublicKey(oTSHashAddress);
                lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(i3).withTreeHeight(lTreeAddress.getTreeHeight()).withTreeIndex(lTreeAddress.getTreeIndex()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
                object = XMSSNodeUtil.lTree(bDS.wotsPlus, (WOTSPlusPublicKeyParameters)object, lTreeAddress);
                hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeIndex(i3).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                while (!((AbstractCollection)this.stack).isEmpty() && this.stack.peek().getHeight() == ((XMSSNode)object).getHeight()) {
                    XMSSNode xMSSNode;
                    int n3 = i3 / (1 << ((XMSSNode)object).getHeight());
                    if (n3 == 1) {
                        this.authenticationPath.add((XMSSNode)object);
                    }
                    if (n3 == 3 && ((XMSSNode)object).getHeight() < this.treeHeight - this.k) {
                        this.treeHashInstances.get(((XMSSNode)object).getHeight()).setNode((XMSSNode)object);
                    }
                    if (n3 >= 3 && (n3 & 1) == 1 && ((XMSSNode)object).getHeight() >= this.treeHeight - this.k && ((XMSSNode)object).getHeight() <= this.treeHeight - 2) {
                        if (this.retain.get(((XMSSNode)object).getHeight()) == null) {
                            LinkedList<Object> linkedList;
                            LinkedList<Object> linkedList2 = linkedList;
                            linkedList2();
                            linkedList.add(object);
                            this.retain.put(((XMSSNode)object).getHeight(), linkedList2);
                        } else {
                            this.retain.get(((XMSSNode)object).getHeight()).add((XMSSNode)object);
                        }
                    }
                    hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                    object = XMSSNodeUtil.randomizeHash(this.wotsPlus, this.stack.pop(), (XMSSNode)object, hashTreeAddress);
                    XMSSNode xMSSNode2 = xMSSNode;
                    Object object2 = object;
                    int n4 = ((XMSSNode)object2).getHeight() + 1;
                    xMSSNode = new XMSSNode(n4, ((XMSSNode)object2).getValue());
                    hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight() + 1).withTreeIndex(hashTreeAddress.getTreeIndex()).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                    object = xMSSNode2;
                }
                this.stack.push((XMSSNode)object);
            }
            this.root = this.stack.pop();
            return;
        }
        throw new NullPointerException("otsHashAddress == null");
    }

    private void nextAuthenticationPath(byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        if (oTSHashAddress != null) {
            if (!this.used) {
                int n3 = this.index;
                if (n3 <= this.maxIndex - 1) {
                    if ((this.index >> (n3 = XMSSUtil.calculateTau(n3, this.treeHeight)) + 1 & 1) == 0 && n3 < this.treeHeight - 1) {
                        this.keep.put(n3, this.authenticationPath.get(n3));
                    }
                    LTreeAddress lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
                    Object object = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).build();
                    if (n3 == 0) {
                        BDS bDS = this;
                        oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(this.index).withChainAddress(oTSHashAddress.getChainAddress()).withHashAddress(oTSHashAddress.getHashAddress()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
                        WOTSPlus wOTSPlus = bDS.wotsPlus;
                        wOTSPlus.importKeys(wOTSPlus.getWOTSPlusSecretKey(byArray2, oTSHashAddress), byArray);
                        Object object2 = bDS.wotsPlus.getPublicKey(oTSHashAddress);
                        lTreeAddress = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(lTreeAddress.getLayerAddress())).withTreeAddress(lTreeAddress.getTreeAddress())).withLTreeAddress(this.index).withTreeHeight(lTreeAddress.getTreeHeight()).withTreeIndex(lTreeAddress.getTreeIndex()).withKeyAndMask(lTreeAddress.getKeyAndMask())).build();
                        object2 = XMSSNodeUtil.lTree(bDS.wotsPlus, (WOTSPlusPublicKeyParameters)object2, lTreeAddress);
                        bDS.authenticationPath.set(0, (XMSSNode)object2);
                    } else {
                        XMSSNode xMSSNode;
                        BDS bDS = this;
                        int n4 = n3 - 1;
                        object = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(((XMSSAddress)object).getLayerAddress())).withTreeAddress(((XMSSAddress)object).getTreeAddress())).withTreeHeight(n4).withTreeIndex(this.index >> n3).withKeyAndMask(((XMSSAddress)object).getKeyAndMask())).build();
                        WOTSPlus wOTSPlus = bDS.wotsPlus;
                        wOTSPlus.importKeys(wOTSPlus.getWOTSPlusSecretKey(byArray2, oTSHashAddress), byArray);
                        object = XMSSNodeUtil.randomizeHash(bDS.wotsPlus, this.authenticationPath.get(n4), this.keep.get(n4), (XMSSAddress)object);
                        XMSSNode xMSSNode2 = xMSSNode;
                        Object object3 = object;
                        int n5 = ((XMSSNode)object3).getHeight() + 1;
                        xMSSNode = new XMSSNode(n5, ((XMSSNode)object3).getValue());
                        bDS.authenticationPath.set(n3, xMSSNode2);
                        bDS.keep.remove(n4);
                        for (n4 = 0; n4 < n3; ++n4) {
                            if (n4 < this.treeHeight - this.k) {
                                this.authenticationPath.set(n4, this.treeHashInstances.get(n4).getTailNode());
                                continue;
                            }
                            this.authenticationPath.set(n4, this.retain.get(n4).removeFirst());
                        }
                        n3 = Math.min(n3, this.treeHeight - this.k);
                        for (n4 = 0; n4 < n3; ++n4) {
                            n5 = (1 << n4) * 3 + (this.index + 1);
                            if (n5 >= 1 << this.treeHeight) continue;
                            this.treeHashInstances.get(n4).initialize(n5);
                        }
                    }
                    for (int i3 = 0; i3 < this.treeHeight - this.k >> 1; ++i3) {
                        Cloneable cloneable = this.getBDSTreeHashInstanceForUpdate();
                        if (cloneable == null) continue;
                        BDSTreeHash bDSTreeHash = cloneable;
                        BDS bDS = this;
                        cloneable = bDS.stack;
                        bDSTreeHash.update((Stack<XMSSNode>)cloneable, bDS.wotsPlus, byArray, byArray2, oTSHashAddress);
                    }
                    ++this.index;
                    return;
                }
                throw new IllegalStateException("index out of bounds");
            }
            throw new IllegalStateException("index already used");
        }
        throw new NullPointerException("otsHashAddress == null");
    }

    /*
     * Enabled aggressive block sorting
     */
    private BDSTreeHash getBDSTreeHashInstanceForUpdate() {
        BDS bDS = serializable;
        Serializable serializable = null;
        Iterator<BDSTreeHash> iterator = bDS.treeHashInstances.iterator();
        while (iterator.hasNext()) {
            BDSTreeHash bDSTreeHash = iterator.next();
            if (bDSTreeHash.isFinished() || !bDSTreeHash.isInitialized() || serializable != null && bDSTreeHash.getHeight() >= ((BDSTreeHash)serializable).getHeight() && (bDSTreeHash.getHeight() != ((BDSTreeHash)serializable).getHeight() || bDSTreeHash.getIndexLeaf() >= ((BDSTreeHash)serializable).getIndexLeaf())) continue;
            serializable = bDSTreeHash;
        }
        return serializable;
    }

    private void validate() {
        if (this.authenticationPath != null) {
            if (this.retain != null) {
                if (this.stack != null) {
                    if (this.treeHashInstances != null) {
                        if (this.keep != null) {
                            if (XMSSUtil.isIndexValid(this.treeHeight, this.index)) {
                                return;
                            }
                            throw new IllegalStateException("index in BDS state out of bounds");
                        }
                        throw new IllegalStateException("keep == null");
                    }
                    throw new IllegalStateException("treeHashInstances == null");
                }
                throw new IllegalStateException("stack == null");
            }
            throw new IllegalStateException("retain == null");
        }
        throw new IllegalStateException("authenticationPath == null");
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.maxIndex = objectInputStream2.available() != 0 ? objectInputStream.readInt() : (1 << this.treeHeight) - 1;
        int n3 = this.maxIndex;
        if (n3 <= (1 << this.treeHeight) - 1 && this.index <= n3 + 1 && objectInputStream.available() == 0) {
            return;
        }
        throw new IOException("inconsistent BDS data detected");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.maxIndex);
    }

    public BDS getNextState(byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        return new BDS(this, byArray, byArray2, oTSHashAddress);
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markUsed() {
        this.used = true;
    }

    public int getTreeHeight() {
        return this.treeHeight;
    }

    public XMSSNode getRoot() {
        return this.root;
    }

    public List<XMSSNode> getAuthenticationPath() {
        ArrayList arrayList;
        BDS bDS = serializable;
        Serializable serializable = arrayList;
        arrayList = new ArrayList();
        Iterator<XMSSNode> iterator = bDS.authenticationPath.iterator();
        while (iterator.hasNext()) {
            ((ArrayList)serializable).add(iterator.next());
        }
        return serializable;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public BDS withWOTSDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return new BDS(this, aSN1ObjectIdentifier);
    }

    public BDS withMaxIndex(int n3, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return new BDS(this, n3, aSN1ObjectIdentifier);
    }
}

