/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDS;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class BDSStateMap
implements Serializable {
    private static final long serialVersionUID = -3464451825208522308L;
    private final Map<Integer, BDS> bdsState;
    private transient long maxIndex;

    public BDSStateMap(long l3) {
        TreeMap treeMap;
        Serializable serializable = treeMap;
        treeMap = new TreeMap();
        v1.bdsState = serializable;
        v1.maxIndex = l3;
    }

    public BDSStateMap(BDSStateMap bDSStateMap, long l3) {
        this.bdsState = new TreeMap<Integer, BDS>();
        for (Integer n3 : bDSStateMap.bdsState.keySet()) {
            BDS bDS;
            BDS bDS2 = bDS;
            bDS = new BDS(bDSStateMap.bdsState.get(n3));
            this.bdsState.put(n3, bDS2);
        }
        this.maxIndex = l3;
    }

    public BDSStateMap(XMSSMTParameters xMSSMTParameters, long l3, byte[] byArray, byte[] byArray2) {
        this.bdsState = new TreeMap<Integer, BDS>();
        int n3 = xMSSMTParameters.getHeight();
        this.maxIndex = (1L << n3) - 1L;
        for (long i3 = 0L; i3 < l3; ++i3) {
            this.updateState(xMSSMTParameters, i3, byArray, byArray2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.maxIndex = objectInputStream2.available() != 0 ? objectInputStream.readLong() : 0L;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeLong(this.maxIndex);
    }

    public long getMaxIndex() {
        return this.maxIndex;
    }

    public void updateState(XMSSMTParameters xMSSMTParameters, long l3, byte[] byArray, byte[] byArray2) {
        OTSHashAddress.Builder builder;
        long l4 = l3;
        XMSSParameters xMSSParameters = xMSSMTParameters.getXMSSParameters();
        int n3 = xMSSParameters.getHeight();
        long l5 = XMSSUtil.getTreeIndex(l4, n3);
        int n4 = XMSSUtil.getLeafIndex(l4, n3);
        Object object = builder;
        ((OTSHashAddress.Builder)object)();
        object = (OTSHashAddress)((OTSHashAddress.Builder)builder.withTreeAddress(l5)).withOTSAddress(n4).build();
        int n5 = (1 << n3) - 1;
        if (n4 < n5) {
            if (this.get(0) == null || n4 == 0) {
                BDS bDS;
                BDS bDS2 = bDS;
                bDS = new BDS(xMSSParameters, byArray, byArray2, (OTSHashAddress)object);
                this.put(0, bDS2);
            }
            this.update(0, byArray, byArray2, (OTSHashAddress)object);
        }
        for (n4 = 1; n4 < xMSSMTParameters.getLayers(); ++n4) {
            int n6 = XMSSUtil.getLeafIndex(l5, n3);
            long l6 = XMSSUtil.getTreeIndex(l5, n3);
            OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(n4)).withTreeAddress(l6)).withOTSAddress(n6).build();
            if (this.bdsState.get(n4) == null || XMSSUtil.isNewBDSInitNeeded(l3, n3, n4)) {
                this.bdsState.put(n4, new BDS(xMSSParameters, byArray, byArray2, oTSHashAddress));
            }
            if (n6 < n5 && XMSSUtil.isNewAuthenticationPathNeeded(l3, n3, n4)) {
                this.update(n4, byArray, byArray2, oTSHashAddress);
            }
            l5 = l6;
        }
    }

    public boolean isEmpty() {
        return this.bdsState.isEmpty();
    }

    public BDS get(int n3) {
        return this.bdsState.get(Integers.valueOf(n3));
    }

    public BDS update(int n3, byte[] byArray, byte[] byArray2, OTSHashAddress oTSHashAddress) {
        return this.bdsState.put(Integers.valueOf(n3), this.bdsState.get(Integers.valueOf(n3)).getNextState(byArray, byArray2, oTSHashAddress));
    }

    public void put(int n3, BDS bDS) {
        this.bdsState.put(Integers.valueOf(n3), bDS);
    }

    public BDSStateMap withWOTSDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        BDSStateMap bDSStateMap;
        BDSStateMap bDSStateMap2 = bDSStateMap;
        bDSStateMap = new BDSStateMap(this.maxIndex);
        for (Integer n3 : this.bdsState.keySet()) {
            bDSStateMap2.bdsState.put(n3, this.bdsState.get(n3).withWOTSDigest(aSN1ObjectIdentifier));
        }
        return bDSStateMap2;
    }
}

