/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.HashTreeAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.LTreeAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSNodeUtil;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Stack;

class BDSTreeHash
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private XMSSNode tailNode;
    private final int initialHeight;
    private int height;
    private int nextIndex;
    private boolean initialized;
    private boolean finished;

    public BDSTreeHash(int n3) {
        this.initialHeight = n3;
        this.initialized = false;
        this.finished = false;
    }

    public void initialize(int n3) {
        BDSTreeHash bDSTreeHash = this;
        this.tailNode = null;
        this.height = this.initialHeight;
        bDSTreeHash.nextIndex = n3;
        bDSTreeHash.initialized = true;
        bDSTreeHash.finished = false;
    }

    public void update(Stack<XMSSNode> object, WOTSPlus object2, byte[] object3, byte[] object4, OTSHashAddress object5) {
        if (object5 != null) {
            if (!this.finished && this.initialized) {
                WOTSPlus wOTSPlus = object2;
                byte[] byArray = object4;
                object4 = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(((XMSSAddress)object5).getLayerAddress())).withTreeAddress(((XMSSAddress)object5).getTreeAddress())).withOTSAddress(this.nextIndex).withChainAddress(((OTSHashAddress)object5).getChainAddress()).withHashAddress(((OTSHashAddress)object5).getHashAddress()).withKeyAndMask(((XMSSAddress)object5).getKeyAndMask())).build();
                object5 = (LTreeAddress)((LTreeAddress.Builder)((LTreeAddress.Builder)new LTreeAddress.Builder().withLayerAddress(((XMSSAddress)object4).getLayerAddress())).withTreeAddress(((XMSSAddress)object4).getTreeAddress())).withLTreeAddress(this.nextIndex).build();
                HashTreeAddress hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(((XMSSAddress)object4).getLayerAddress())).withTreeAddress(((XMSSAddress)object4).getTreeAddress())).withTreeIndex(this.nextIndex).build();
                wOTSPlus.importKeys(wOTSPlus.getWOTSPlusSecretKey(byArray, (OTSHashAddress)object4), (byte[])object3);
                object3 = XMSSNodeUtil.lTree(wOTSPlus, wOTSPlus.getPublicKey((OTSHashAddress)object4), (LTreeAddress)object5);
                while (!((AbstractCollection)object).isEmpty() && ((Stack)object).peek().getHeight() == ((XMSSNode)object3).getHeight() && ((Stack)object).peek().getHeight() != this.initialHeight) {
                    XMSSNode xMSSNode;
                    object4 = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                    object3 = XMSSNodeUtil.randomizeHash((WOTSPlus)object2, ((Stack)object).pop(), (XMSSNode)object3, (XMSSAddress)object4);
                    object5 = xMSSNode;
                    Object object6 = object3;
                    int n3 = ((XMSSNode)object6).getHeight() + 1;
                    xMSSNode = new XMSSNode(n3, ((XMSSNode)object6).getValue());
                    hashTreeAddress = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(((XMSSAddress)object4).getLayerAddress())).withTreeAddress(((XMSSAddress)object4).getTreeAddress())).withTreeHeight(((HashTreeAddress)object4).getTreeHeight() + 1).withTreeIndex(((HashTreeAddress)object4).getTreeIndex()).withKeyAndMask(((XMSSAddress)object4).getKeyAndMask())).build();
                    object3 = object5;
                }
                object4 = this.tailNode;
                if (object4 == null) {
                    this.tailNode = object3;
                } else if (((XMSSNode)object4).getHeight() == ((XMSSNode)object3).getHeight()) {
                    XMSSNode xMSSNode;
                    object = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(hashTreeAddress.getLayerAddress())).withTreeAddress(hashTreeAddress.getTreeAddress())).withTreeHeight(hashTreeAddress.getTreeHeight()).withTreeIndex((hashTreeAddress.getTreeIndex() - 1) / 2).withKeyAndMask(hashTreeAddress.getKeyAndMask())).build();
                    object2 = XMSSNodeUtil.randomizeHash((WOTSPlus)object2, this.tailNode, (XMSSNode)object3, (XMSSAddress)object);
                    object3 = xMSSNode;
                    int n4 = this.tailNode.getHeight() + 1;
                    this.tailNode = new XMSSNode(n4, ((XMSSNode)object2).getValue());
                    HashTreeAddress cfr_ignored_0 = (HashTreeAddress)((HashTreeAddress.Builder)((HashTreeAddress.Builder)((HashTreeAddress.Builder)new HashTreeAddress.Builder().withLayerAddress(((XMSSAddress)object).getLayerAddress())).withTreeAddress(((XMSSAddress)object).getTreeAddress())).withTreeHeight(((HashTreeAddress)object).getTreeHeight() + 1).withTreeIndex(((HashTreeAddress)object).getTreeIndex()).withKeyAndMask(((XMSSAddress)object).getKeyAndMask())).build();
                } else {
                    ((Stack)object).push((XMSSNode)object3);
                }
                if (this.tailNode.getHeight() == this.initialHeight) {
                    this.finished = true;
                } else {
                    this.height = ((XMSSNode)object3).getHeight();
                    ++this.nextIndex;
                }
                return;
            }
            throw new IllegalStateException("finished or not initialized");
        }
        throw new NullPointerException("otsHashAddress == null");
    }

    public int getHeight() {
        if (this.initialized && !this.finished) {
            return this.height;
        }
        return Integer.MAX_VALUE;
    }

    public int getIndexLeaf() {
        return this.nextIndex;
    }

    public void setNode(XMSSNode xMSSNode) {
        int n3;
        this.tailNode = xMSSNode;
        this.height = n3 = xMSSNode.getHeight();
        if (n3 == this.initialHeight) {
            this.finished = true;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public XMSSNode getTailNode() {
        return this.tailNode;
    }

    public BDSTreeHash clone() {
        BDSTreeHash bDSTreeHash;
        BDSTreeHash bDSTreeHash2 = bDSTreeHash;
        bDSTreeHash2(this.initialHeight);
        bDSTreeHash2.tailNode = this.tailNode;
        bDSTreeHash2.height = this.height;
        bDSTreeHash2.nextIndex = this.nextIndex;
        bDSTreeHash2.initialized = this.initialized;
        bDSTreeHash.finished = this.finished;
        return bDSTreeHash;
    }
}

