/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

final class OTSHashAddress
extends XMSSAddress {
    private static final int TYPE = 0;
    private final int otsAddress;
    private final int chainAddress;
    private final int hashAddress;

    private OTSHashAddress(Builder builder) {
        super(builder);
        this.otsAddress = builder.otsAddress;
        this.chainAddress = builder.chainAddress;
        this.hashAddress = builder.hashAddress;
    }

    public /* synthetic */ OTSHashAddress(Builder builder, 1 var2_2) {
        this(builder);
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = super.toByteArray();
        OTSHashAddress oTSHashAddress = this;
        Pack.intToBigEndian(oTSHashAddress.otsAddress, byArray, 16);
        Pack.intToBigEndian(oTSHashAddress.chainAddress, byArray, 20);
        Pack.intToBigEndian(oTSHashAddress.hashAddress, byArray, 24);
        return byArray;
    }

    public int getOTSAddress() {
        return this.otsAddress;
    }

    public int getChainAddress() {
        return this.chainAddress;
    }

    public int getHashAddress() {
        return this.hashAddress;
    }

    public static class Builder
    extends XMSSAddress.Builder<Builder> {
        private int otsAddress = 0;
        private int chainAddress = 0;
        private int hashAddress = 0;

        public Builder() {
            super(0);
        }

        public Builder withOTSAddress(int n3) {
            this.otsAddress = n3;
            return this;
        }

        public Builder withChainAddress(int n3) {
            this.chainAddress = n3;
            return this;
        }

        public Builder withHashAddress(int n3) {
            this.hashAddress = n3;
            return this;
        }

        @Override
        public XMSSAddress build() {
            return new OTSHashAddress(this, null);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

