/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.KeyedHashFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.util.ArrayList;
import java.util.List;

final class WOTSPlus {
    private final WOTSPlusParameters params;
    private final KeyedHashFunctions khf;
    private byte[] secretKeySeed;
    private byte[] publicSeed;

    public WOTSPlus(WOTSPlusParameters wOTSPlusParameters) {
        if (wOTSPlusParameters != null) {
            WOTSPlus wOTSPlus = this;
            this.params = wOTSPlusParameters;
            int n3 = wOTSPlusParameters.getTreeDigestSize();
            wOTSPlus.khf = new KeyedHashFunctions(wOTSPlusParameters.getTreeDigest(), n3);
            wOTSPlus.secretKeySeed = new byte[n3];
            wOTSPlus.publicSeed = new byte[n3];
            return;
        }
        throw new NullPointerException("params == null");
    }

    private byte[] chain(byte[] byArray, int n3, int n4, OTSHashAddress object) {
        int n5 = this.params.getTreeDigestSize();
        if (byArray != null) {
            if (byArray.length == n5) {
                if (object != null) {
                    if (((OTSHashAddress)object).toByteArray() != null) {
                        int n6 = n3 + n4;
                        if (n6 <= this.params.getWinternitzParameter() - 1) {
                            if (n4 == 0) {
                                return byArray;
                            }
                            WOTSPlus wOTSPlus = this;
                            byArray = wOTSPlus.chain(byArray, n3, n4 - 1, (OTSHashAddress)object);
                            Object object2 = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(((XMSSAddress)object).getLayerAddress())).withTreeAddress(((XMSSAddress)object).getTreeAddress())).withOTSAddress(((OTSHashAddress)object).getOTSAddress()).withChainAddress(((OTSHashAddress)object).getChainAddress()).withHashAddress(n6 - 1).withKeyAndMask(0)).build();
                            byte[] byArray2 = this.publicSeed;
                            byArray2 = wOTSPlus.khf.PRF(byArray2, ((OTSHashAddress)object2).toByteArray());
                            object2 = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(((XMSSAddress)object2).getLayerAddress())).withTreeAddress(((XMSSAddress)object2).getTreeAddress())).withOTSAddress(((OTSHashAddress)object2).getOTSAddress()).withChainAddress(((OTSHashAddress)object2).getChainAddress()).withHashAddress(((OTSHashAddress)object2).getHashAddress()).withKeyAndMask(1)).build();
                            OTSHashAddress oTSHashAddress = object2;
                            object2 = this.publicSeed;
                            object2 = wOTSPlus.khf.PRF((byte[])object2, oTSHashAddress.toByteArray());
                            object = new byte[n5];
                            for (n6 = 0; n6 < n5; ++n6) {
                                object[n6] = (byte)(byArray[n6] ^ object2[n6]);
                            }
                            return this.khf.F(byArray2, (byte[])object);
                        }
                        throw new IllegalArgumentException("max chain length must not be greater than w");
                    }
                    throw new NullPointerException("otsHashAddress byte array == null");
                }
                throw new NullPointerException("otsHashAddress == null");
            }
            throw new IllegalArgumentException(f.a("startHash needs to be ", n5, "bytes"));
        }
        throw new NullPointerException("startHash == null");
    }

    private List<Integer> convertToBaseW(byte[] byArray, int n3, int n4) {
        if (byArray != null) {
            if (n3 != 4 && n3 != 16) {
                throw new IllegalArgumentException("w needs to be 4 or 16");
            }
            int n5 = XMSSUtil.log2(n3);
            if (n4 <= byArray.length * 8 / n5) {
                ArrayList<Integer> arrayList;
                ArrayList<Integer> arrayList2 = arrayList;
                arrayList = new ArrayList<Integer>();
                for (int i3 = 0; i3 < byArray.length; ++i3) {
                    for (int i4 = 8 - n5; i4 >= 0; i4 -= n5) {
                        ArrayList<Integer> arrayList3 = arrayList2;
                        arrayList3.add(byArray[i3] >> i4 & n3 - 1);
                        if (arrayList3.size() != n4) continue;
                        return arrayList2;
                    }
                }
                return arrayList2;
            }
            throw new IllegalArgumentException("outLength too big");
        }
        throw new NullPointerException("msg == null");
    }

    private byte[] expandSecretKeySeed(int n3) {
        if (n3 >= 0 && n3 < this.params.getLen()) {
            return this.khf.PRF(this.secretKeySeed, XMSSUtil.toBytesBigEndian(n3, 32));
        }
        throw new IllegalArgumentException("index out of bounds");
    }

    public void importKeys(byte[] byArray, byte[] byArray2) {
        if (byArray != null) {
            if (byArray.length == this.params.getTreeDigestSize()) {
                if (byArray2 != null) {
                    if (byArray2.length == this.params.getTreeDigestSize()) {
                        WOTSPlus wOTSPlus = this;
                        wOTSPlus.secretKeySeed = byArray;
                        wOTSPlus.publicSeed = byArray2;
                        return;
                    }
                    throw new IllegalArgumentException("size of publicSeed needs to be equal to size of digest");
                }
                throw new NullPointerException("publicSeed == null");
            }
            throw new IllegalArgumentException("size of secretKeySeed needs to be equal to size of digest");
        }
        throw new NullPointerException("secretKeySeed == null");
    }

    public WOTSPlusSignature sign(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray != null) {
            if (byArray.length == this.params.getTreeDigestSize()) {
                if (oTSHashAddress != null) {
                    int n3;
                    WOTSPlus wOTSPlus = this;
                    int n4 = wOTSPlus.params.getWinternitzParameter();
                    List<Integer> list = this.convertToBaseW(byArray, n4, wOTSPlus.params.getLen1());
                    int n5 = 0;
                    for (n3 = 0; n3 < this.params.getLen1(); ++n3) {
                        n5 = this.params.getWinternitzParameter() - 1 - list.get(n3) + n5;
                    }
                    int n6 = n5;
                    WOTSPlus wOTSPlus2 = this;
                    n5 = wOTSPlus2.params.getLen2();
                    int n7 = n6 << 8 - XMSSUtil.log2(wOTSPlus2.params.getWinternitzParameter()) * n5 % 8;
                    WOTSPlus wOTSPlus3 = this;
                    n5 = wOTSPlus3.params.getLen2();
                    n5 = (int)Math.ceil((double)(XMSSUtil.log2(wOTSPlus3.params.getWinternitzParameter()) * n5) / 8.0);
                    byte[] byArray2 = XMSSUtil.toBytesBigEndian(n7, n5);
                    WOTSPlus wOTSPlus4 = this;
                    n5 = wOTSPlus4.params.getWinternitzParameter();
                    list.addAll(this.convertToBaseW(byArray2, n5, wOTSPlus4.params.getLen2()));
                    byte[][] byArrayArray = new byte[this.params.getLen()][];
                    for (n3 = 0; n3 < this.params.getLen(); ++n3) {
                        oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(oTSHashAddress.getOTSAddress()).withChainAddress(n3).withHashAddress(oTSHashAddress.getHashAddress()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
                        byte[] byArray3 = this.expandSecretKeySeed(n3);
                        int n8 = list.get(n3);
                        byArrayArray[n3] = this.chain(byArray3, 0, n8, oTSHashAddress);
                    }
                    return new WOTSPlusSignature(this.params, byArrayArray);
                }
                throw new NullPointerException("otsHashAddress == null");
            }
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        throw new NullPointerException("messageDigest == null");
    }

    public WOTSPlusPublicKeyParameters getPublicKeyFromSignature(byte[] byArray, WOTSPlusSignature wOTSPlusSignature, OTSHashAddress oTSHashAddress) {
        if (byArray != null) {
            if (byArray.length == this.params.getTreeDigestSize()) {
                if (wOTSPlusSignature != null) {
                    if (oTSHashAddress != null) {
                        int n3;
                        WOTSPlus wOTSPlus = this;
                        int n4 = wOTSPlus.params.getWinternitzParameter();
                        List<Integer> list = this.convertToBaseW(byArray, n4, wOTSPlus.params.getLen1());
                        int n5 = 0;
                        for (n3 = 0; n3 < this.params.getLen1(); ++n3) {
                            n5 = this.params.getWinternitzParameter() - 1 - list.get(n3) + n5;
                        }
                        int n6 = n5;
                        WOTSPlus wOTSPlus2 = this;
                        n5 = wOTSPlus2.params.getLen2();
                        int n7 = n6 << 8 - XMSSUtil.log2(wOTSPlus2.params.getWinternitzParameter()) * n5 % 8;
                        WOTSPlus wOTSPlus3 = this;
                        n5 = wOTSPlus3.params.getLen2();
                        n5 = (int)Math.ceil((double)(XMSSUtil.log2(wOTSPlus3.params.getWinternitzParameter()) * n5) / 8.0);
                        byte[] byArray2 = XMSSUtil.toBytesBigEndian(n7, n5);
                        WOTSPlus wOTSPlus4 = this;
                        n5 = wOTSPlus4.params.getWinternitzParameter();
                        list.addAll(this.convertToBaseW(byArray2, n5, wOTSPlus4.params.getLen2()));
                        byte[][] byArrayArray = new byte[this.params.getLen()][];
                        for (n3 = 0; n3 < this.params.getLen(); ++n3) {
                            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(oTSHashAddress.getOTSAddress()).withChainAddress(n3).withHashAddress(oTSHashAddress.getHashAddress()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
                            byte[] byArray3 = wOTSPlusSignature.toByteArray()[n3];
                            byArrayArray[n3] = this.chain(byArray3, list.get(n3), this.params.getWinternitzParameter() - 1 - list.get(n3), oTSHashAddress);
                        }
                        return new WOTSPlusPublicKeyParameters(this.params, byArrayArray);
                    }
                    throw new NullPointerException("otsHashAddress == null");
                }
                throw new NullPointerException("signature == null");
            }
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        throw new NullPointerException("messageDigest == null");
    }

    public byte[] getWOTSPlusSecretKey(byte[] byArray, OTSHashAddress oTSHashAddress) {
        WOTSPlus wOTSPlus = oTSHashAddress2;
        OTSHashAddress oTSHashAddress2 = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(oTSHashAddress.getOTSAddress()).build();
        return wOTSPlus.khf.PRF(byArray, oTSHashAddress2.toByteArray());
    }

    public WOTSPlusParameters getParams() {
        return this.params;
    }

    public KeyedHashFunctions getKhf() {
        return this.khf;
    }

    public byte[] getSecretKeySeed() {
        return Arrays.clone(this.secretKeySeed);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.publicSeed);
    }

    public WOTSPlusPrivateKeyParameters getPrivateKey() {
        int n3 = this.params.getLen();
        byte[][] byArrayArray = new byte[n3][];
        for (int i3 = 0; i3 < n3; ++i3) {
            byArrayArray[i3] = this.expandSecretKeySeed(i3);
        }
        return new WOTSPlusPrivateKeyParameters(this.params, byArrayArray);
    }

    public WOTSPlusPublicKeyParameters getPublicKey(OTSHashAddress oTSHashAddress) {
        if (oTSHashAddress != null) {
            byte[][] byArrayArray = new byte[this.params.getLen()][];
            for (int i3 = 0; i3 < this.params.getLen(); ++i3) {
                WOTSPlus wOTSPlus = this;
                oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(oTSHashAddress.getOTSAddress()).withChainAddress(i3).withHashAddress(oTSHashAddress.getHashAddress()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
                byArrayArray[i3] = wOTSPlus.chain(wOTSPlus.expandSecretKeySeed(i3), 0, this.params.getWinternitzParameter() - 1, oTSHashAddress);
            }
            return new WOTSPlusPublicKeyParameters(this.params, byArrayArray);
        }
        throw new NullPointerException("otsHashAddress == null");
    }
}

