/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSOid;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class WOTSPlusOid
implements XMSSOid {
    private static final Map<String, WOTSPlusOid> oidLookupTable;
    private final int oid;
    private final String stringRepresentation;

    private WOTSPlusOid(int n3, String string2) {
        this.oid = n3;
        this.stringRepresentation = string2;
    }

    public static WOTSPlusOid lookup(String string2, int n3, int n4, int n5) {
        if (string2 != null) {
            return oidLookupTable.get(WOTSPlusOid.createKey(string2, n3, n4, n5));
        }
        throw new NullPointerException("algorithmName == null");
    }

    private static String createKey(String string2, int n3, int n4, int n5) {
        if (string2 != null) {
            return string2 + "-" + n3 + "-" + n4 + "-" + n5;
        }
        throw new NullPointerException("algorithmName == null");
    }

    static {
        HashMap<String, WOTSPlusOid> hashMap = new HashMap<String, WOTSPlusOid>();
        hashMap.put(WOTSPlusOid.createKey("SHA-256", 32, 16, 67), new WOTSPlusOid(0x1000001, "WOTSP_SHA2-256_W16"));
        hashMap.put(WOTSPlusOid.createKey("SHA-512", 64, 16, 131), new WOTSPlusOid(0x2000002, "WOTSP_SHA2-512_W16"));
        hashMap.put(WOTSPlusOid.createKey("SHAKE128", 32, 16, 67), new WOTSPlusOid(0x3000003, "WOTSP_SHAKE128_W16"));
        hashMap.put(WOTSPlusOid.createKey("SHAKE256", 64, 16, 131), new WOTSPlusOid(0x4000004, "WOTSP_SHAKE256_W16"));
        oidLookupTable = Collections.unmodifiableMap(hashMap);
    }

    @Override
    public int getOid() {
        return this.oid;
    }

    @Override
    public String toString() {
        return this.stringRepresentation;
    }
}

