/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class XMSS {
    private final XMSSParameters params;
    private WOTSPlus wotsPlus;
    private SecureRandom prng;
    private XMSSPrivateKeyParameters privateKey;
    private XMSSPublicKeyParameters publicKey;

    public XMSS(XMSSParameters xMSSParameters, SecureRandom secureRandom) {
        if (xMSSParameters != null) {
            this.params = xMSSParameters;
            this.wotsPlus = xMSSParameters.getWOTSPlus();
            this.prng = secureRandom;
            return;
        }
        throw new NullPointerException("params == null");
    }

    public void generateKeys() {
        XMSSKeyPairGenerator xMSSKeyPairGenerator = new XMSSKeyPairGenerator();
        XMSS xMSS = this;
        Object object = xMSS.getParams();
        xMSSKeyPairGenerator.init(new XMSSKeyGenerationParameters((XMSSParameters)object, xMSS.prng));
        object = xMSSKeyPairGenerator.generateKeyPair();
        this.privateKey = (XMSSPrivateKeyParameters)((AsymmetricCipherKeyPair)object).getPrivate();
        this.publicKey = (XMSSPublicKeyParameters)((AsymmetricCipherKeyPair)object).getPublic();
        this.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], this.privateKey.getPublicSeed());
    }

    public void importState(XMSSPrivateKeyParameters xMSSPrivateKeyParameters, XMSSPublicKeyParameters xMSSPublicKeyParameters) {
        if (Arrays.areEqual(xMSSPrivateKeyParameters.getRoot(), xMSSPublicKeyParameters.getRoot())) {
            if (Arrays.areEqual(xMSSPrivateKeyParameters.getPublicSeed(), xMSSPublicKeyParameters.getPublicSeed())) {
                this.privateKey = xMSSPrivateKeyParameters;
                this.publicKey = xMSSPublicKeyParameters;
                this.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], this.privateKey.getPublicSeed());
                return;
            }
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        throw new IllegalStateException("root of private key and public key do not match");
    }

    public void importState(byte[] object, byte[] object2) {
        if (object != null) {
            if (object2 != null) {
                XMSSPrivateKeyParameters xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(this.params).withPrivateKey((byte[])object).build();
                object = xMSSPrivateKeyParameters;
                object2 = new XMSSPublicKeyParameters.Builder(this.params).withPublicKey((byte[])object2).build();
                if (Arrays.areEqual(xMSSPrivateKeyParameters.getRoot(), ((XMSSPublicKeyParameters)object2).getRoot())) {
                    if (Arrays.areEqual(((XMSSPrivateKeyParameters)object).getPublicSeed(), ((XMSSPublicKeyParameters)object2).getPublicSeed())) {
                        this.privateKey = object;
                        this.publicKey = object2;
                        this.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], this.privateKey.getPublicSeed());
                        return;
                    }
                    throw new IllegalStateException("public seed of private key and public key do not match");
                }
                throw new IllegalStateException("root of private key and public key do not match");
            }
            throw new NullPointerException("publicKey == null");
        }
        throw new NullPointerException("privateKey == null");
    }

    public byte[] sign(byte[] byArray) {
        if (byArray != null) {
            XMSSSigner xMSSSigner;
            XMSSSigner xMSSSigner2 = xMSSSigner;
            xMSSSigner2();
            xMSSSigner2.init(true, ((XMSS)((Object)xMSSPrivateKeyParameters)).privateKey);
            byte[] byArray2 = xMSSSigner.generateSignature(byArray);
            XMSS xMSS = xMSSPrivateKeyParameters;
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters = (XMSSPrivateKeyParameters)xMSSSigner2.getUpdatedPrivateKey();
            xMSS.privateKey = xMSSPrivateKeyParameters;
            xMSS.importState(xMSSPrivateKeyParameters, xMSS.publicKey);
            return byArray2;
        }
        throw new NullPointerException("message == null");
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray != null) {
            if (byArray2 != null) {
                if (byArray3 != null) {
                    XMSSSigner xMSSSigner = new XMSSSigner();
                    xMSSSigner.init(false, new XMSSPublicKeyParameters.Builder(this.getParams()).withPublicKey(byArray3).build());
                    return xMSSSigner.verifySignature(byArray, byArray2);
                }
                throw new NullPointerException("publicKey == null");
            }
            throw new NullPointerException("signature == null");
        }
        throw new NullPointerException("message == null");
    }

    public XMSSPrivateKeyParameters exportPrivateKey() {
        return this.privateKey;
    }

    public XMSSPublicKeyParameters exportPublicKey() {
        return this.publicKey;
    }

    public WOTSPlusSignature wotsSign(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length == ((XMSS)object).params.getTreeDigestSize()) {
            if (oTSHashAddress != null) {
                XMSS xMSS = object;
                WOTSPlus wOTSPlus = xMSS.wotsPlus;
                Object object = wOTSPlus.getWOTSPlusSecretKey(((XMSS)object).privateKey.getSecretKeySeed(), oTSHashAddress);
                wOTSPlus.importKeys((byte[])object, ((XMSS)object).getPublicSeed());
                return xMSS.wotsPlus.sign(byArray, oTSHashAddress);
            }
            throw new NullPointerException("otsHashAddress == null");
        }
        throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
    }

    public XMSSParameters getParams() {
        return this.params;
    }

    public WOTSPlus getWOTSPlus() {
        return this.wotsPlus;
    }

    public byte[] getRoot() {
        return this.privateKey.getRoot();
    }

    public void setRoot(byte[] byArray) {
        XMSS xMSS = this;
        xMSS.privateKey = new XMSSPrivateKeyParameters.Builder(this.params).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.getPublicSeed()).withRoot(byArray).withBDSState(this.privateKey.getBDSState()).build();
        xMSS.publicKey = new XMSSPublicKeyParameters.Builder(this.params).withRoot(byArray).withPublicSeed(this.getPublicSeed()).build();
    }

    public int getIndex() {
        return this.privateKey.getIndex();
    }

    public void setIndex(int n3) {
        this.privateKey = new XMSSPrivateKeyParameters.Builder(this.params).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(this.privateKey.getPublicSeed()).withRoot(this.privateKey.getRoot()).withBDSState(this.privateKey.getBDSState()).build();
    }

    public byte[] getPublicSeed() {
        return this.privateKey.getPublicSeed();
    }

    public void setPublicSeed(byte[] byArray) {
        this.privateKey = new XMSSPrivateKeyParameters.Builder(this.params).withSecretKeySeed(this.privateKey.getSecretKeySeed()).withSecretKeyPRF(this.privateKey.getSecretKeyPRF()).withPublicSeed(byArray).withRoot(this.getRoot()).withBDSState(this.privateKey.getBDSState()).build();
        this.publicKey = new XMSSPublicKeyParameters.Builder(this.params).withRoot(this.getRoot()).withPublicSeed(byArray).build();
        this.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], byArray);
    }

    public XMSSPrivateKeyParameters getPrivateKey() {
        return this.privateKey;
    }
}

