/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class XMSSMTSignature
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSMTParameters params;
    private final long index;
    private final byte[] random;
    private final List<XMSSReducedSignature> reducedSignatures;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMSSMTSignature(Builder object) {
        Object object2 = ((Builder)object).params;
        ((XMSSMTSignature)((Object)arrayList2)).params = object2;
        if (object2 == null) throw new NullPointerException("params == null");
        int n3 = ((XMSSMTParameters)object2).getTreeDigestSize();
        byte[] byArray = ((Builder)object).signature;
        if (byArray != null) {
            long l3;
            XMSSMTParameters xMSSMTParameters = object2;
            int n4 = xMSSMTParameters.getWOTSPlus().getParams().getLen();
            int n5 = (int)Math.ceil((double)xMSSMTParameters.getHeight() / 8.0);
            Object object3 = object2;
            n4 = (((XMSSMTParameters)object3).getHeight() / ((XMSSMTParameters)object2).getLayers() + n4) * n3;
            int n6 = ((XMSSMTParameters)object3).getLayers() * n4;
            if (byArray.length != (n6 = n5 + n3 + n6)) throw new IllegalArgumentException("signature has wrong size");
            int n7 = 0;
            ((XMSSMTSignature)((Object)arrayList2)).index = l3 = XMSSUtil.bytesToXBigEndian(byArray, 0, n5);
            if (!XMSSUtil.isIndexValid(((XMSSMTParameters)object2).getHeight(), l3)) throw new IllegalArgumentException("index out of bounds");
            n7 = n5 + n7;
            ((XMSSMTSignature)((Object)arrayList2)).random = XMSSUtil.extractBytesAtOffset(byArray, n7, n3);
            n7 += n3;
            ((XMSSMTSignature)((Object)arrayList2)).reducedSignatures = new ArrayList<XMSSReducedSignature>();
            while (n7 < byArray.length) {
                XMSSReducedSignature.Builder builder;
                XMSSReducedSignature.Builder builder2 = builder;
                builder2(((XMSSMTSignature)((Object)arrayList2)).params.getXMSSParameters());
                XMSSReducedSignature xMSSReducedSignature = builder.withReducedSignature(XMSSUtil.extractBytesAtOffset(byArray, n7, n4)).build();
                ((XMSSMTSignature)((Object)arrayList2)).reducedSignatures.add(xMSSReducedSignature);
                n7 += n4;
            }
            return;
        } else {
            ((XMSSMTSignature)((Object)arrayList2)).index = ((Builder)object).index;
            byte[] byArray2 = ((Builder)object).random;
            object2 = byArray2;
            if (byArray2 != null) {
                if (((Object)object2).length != n3) throw new IllegalArgumentException("size of random needs to be equal to size of digest");
                ((XMSSMTSignature)((Object)arrayList2)).random = (byte[])object2;
            } else {
                ((XMSSMTSignature)((Object)arrayList2)).random = new byte[n3];
            }
            object = ((Builder)object).reducedSignatures;
            if (object != null) {
                ((XMSSMTSignature)((Object)arrayList2)).reducedSignatures = object;
                return;
            } else {
                ArrayList arrayList;
                XMSSMTSignature xMSSMTSignature = arrayList2;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                xMSSMTSignature.reducedSignatures = arrayList2;
            }
        }
    }

    public /* synthetic */ XMSSMTSignature(Builder builder, 1 var2_2) {
        this(builder);
    }

    @Override
    public byte[] getEncoded() {
        return this.toByteArray();
    }

    @Override
    public byte[] toByteArray() {
        XMSSMTSignature xMSSMTSignature = this;
        int n3 = xMSSMTSignature.params.getTreeDigestSize();
        int n4 = xMSSMTSignature.params.getWOTSPlus().getParams().getLen();
        int n5 = (int)Math.ceil((double)xMSSMTSignature.params.getHeight() / 8.0);
        XMSSMTSignature xMSSMTSignature2 = this;
        n4 = (xMSSMTSignature2.params.getHeight() / this.params.getLayers() + n4) * n3;
        int n6 = xMSSMTSignature2.params.getLayers() * n4;
        byte[] byArray = new byte[n5 + n3 + n6];
        XMSSUtil.copyBytesAtOffset(byArray, XMSSUtil.toBytesBigEndian(this.index, n5), 0);
        XMSSUtil.copyBytesAtOffset(byArray, this.random, n5 += 0);
        int n7 = n5 + n3;
        Iterator<XMSSReducedSignature> iterator = xMSSMTSignature.reducedSignatures.iterator();
        while (iterator.hasNext()) {
            XMSSUtil.copyBytesAtOffset(byArray, iterator.next().toByteArray(), n7);
            n7 += n4;
        }
        return byArray;
    }

    public long getIndex() {
        return this.index;
    }

    public byte[] getRandom() {
        return XMSSUtil.cloneArray(this.random);
    }

    public List<XMSSReducedSignature> getReducedSignatures() {
        return this.reducedSignatures;
    }

    public static class Builder {
        private final XMSSMTParameters params;
        private long index = 0L;
        private byte[] random = null;
        private List<XMSSReducedSignature> reducedSignatures = null;
        private byte[] signature = null;

        public Builder(XMSSMTParameters xMSSMTParameters) {
            this.params = xMSSMTParameters;
        }

        public Builder withIndex(long l3) {
            this.index = l3;
            return this;
        }

        public Builder withRandom(byte[] byArray) {
            this.random = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withReducedSignatures(List<XMSSReducedSignature> list) {
            this.reducedSignatures = list;
            return this;
        }

        public Builder withSignature(byte[] byArray) {
            this.signature = Arrays.clone(byArray);
            return this;
        }

        public XMSSMTSignature build() {
            return new XMSSMTSignature(this, null);
        }
    }
}

