/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public final class XMSSPublicKeyParameters
extends XMSSKeyParameters
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSParameters params;
    private final int oid;
    private final byte[] root;
    private final byte[] publicSeed;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMSSPublicKeyParameters(Builder object) {
        super(false, ((Builder)object).params.getTreeDigest());
        Object object2 = ((Builder)object).params;
        this.params = object2;
        if (object2 == null) throw new NullPointerException("params == null");
        int n3 = ((XMSSParameters)object2).getTreeDigestSize();
        byte[] byArray = ((Builder)object).publicKey;
        if (byArray != null) {
            int n4 = 4;
            int n5 = 0;
            int n6 = n3;
            if (byArray.length == n6 + n6) {
                this.oid = 0;
                this.root = XMSSUtil.extractBytesAtOffset(byArray, n5, n3);
                this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n3 + n5, n3);
                return;
            } else {
                if (byArray.length != n3 + n4 + n3) throw new IllegalArgumentException("public key has wrong size");
                this.oid = Pack.bigEndianToInt(byArray, 0);
                this.root = XMSSUtil.extractBytesAtOffset(byArray, 4, n3);
                this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, 4 + n3, n3);
            }
            return;
        } else {
            this.oid = ((XMSSParameters)object2).getOid() != null ? ((XMSSParameters)object2).getOid().getOid() : 0;
            byte[] byArray2 = ((Builder)object).root;
            object2 = byArray2;
            if (byArray2 != null) {
                if (((Object)object2).length != n3) throw new IllegalArgumentException("length of root must be equal to length of digest");
                this.root = (byte[])object2;
            } else {
                this.root = new byte[n3];
            }
            byte[] byArray3 = ((Builder)object).publicSeed;
            object = byArray3;
            if (byArray3 != null) {
                if (((Object)object).length != n3) throw new IllegalArgumentException("length of publicSeed must be equal to length of digest");
                this.publicSeed = (byte[])object;
                return;
            } else {
                this.publicSeed = new byte[n3];
            }
        }
    }

    public /* synthetic */ XMSSPublicKeyParameters(Builder builder, 1 var2_2) {
        this(builder);
    }

    @Override
    public byte[] getEncoded() {
        return this.toByteArray();
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray;
        XMSSPublicKeyParameters xMSSPublicKeyParameters = this;
        int n3 = xMSSPublicKeyParameters.params.getTreeDigestSize();
        int n4 = 4;
        int n5 = 0;
        int n6 = xMSSPublicKeyParameters.oid;
        if (n6 != 0) {
            byArray = new byte[n3 + n4 + n3];
            Pack.intToBigEndian(n6, byArray, n5);
            n5 = 4;
        } else {
            int n7 = n3;
            byArray = new byte[n7 + n7];
        }
        XMSSUtil.copyBytesAtOffset(byArray, this.root, n5);
        int n8 = n5 + n3;
        XMSSUtil.copyBytesAtOffset(byArray, this.publicSeed, n8);
        return byArray;
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public XMSSParameters getParameters() {
        return this.params;
    }

    public static class Builder {
        private final XMSSParameters params;
        private byte[] root = null;
        private byte[] publicSeed = null;
        private byte[] publicKey = null;

        public Builder(XMSSParameters xMSSParameters) {
            this.params = xMSSParameters;
        }

        public Builder withRoot(byte[] byArray) {
            this.root = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicSeed(byte[] byArray) {
            this.publicSeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicKey(byte[] byArray) {
            this.publicKey = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public XMSSPublicKeyParameters build() {
            return new XMSSPublicKeyParameters(this, null);
        }
    }
}

