/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import java.util.ArrayList;
import java.util.List;

public class XMSSReducedSignature
implements XMSSStoreableObjectInterface {
    private final XMSSParameters params;
    private final WOTSPlusSignature wotsPlusSignature;
    private final List<XMSSNode> authPath;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMSSReducedSignature(Builder object) {
        Object object2 = ((Builder)object).params;
        ((XMSSReducedSignature)((Object)arrayList2)).params = object2;
        if (object2 == null) throw new NullPointerException("params == null");
        XMSSParameters xMSSParameters = object2;
        int n3 = xMSSParameters.getTreeDigestSize();
        int n4 = xMSSParameters.getWOTSPlus().getParams().getLen();
        int n5 = xMSSParameters.getHeight();
        byte[] byArray = ((Builder)object).reducedSignature;
        if (byArray != null) {
            ArrayList arrayList;
            int n6 = n4 * n3;
            if (byArray.length != (n6 = n5 * n3 + n6)) throw new IllegalArgumentException("signature has wrong size");
            n6 = 0;
            object2 = new byte[n4][];
            for (int i3 = 0; i3 < n4; ++i3) {
                object2[i3] = XMSSUtil.extractBytesAtOffset(byArray, n6, n3);
                n6 += n3;
            }
            ((XMSSReducedSignature)((Object)arrayList2)).wotsPlusSignature = new WOTSPlusSignature(((XMSSReducedSignature)((Object)arrayList2)).params.getWOTSPlus().getParams(), (byte[][])object2);
            object2 = arrayList;
            arrayList = new ArrayList();
            for (n4 = 0; n4 < n5; ++n4) {
                XMSSNode xMSSNode;
                XMSSNode xMSSNode2 = xMSSNode;
                xMSSNode = new XMSSNode(n4, XMSSUtil.extractBytesAtOffset(byArray, n6, n3));
                ((ArrayList)object2).add(xMSSNode2);
                n6 += n3;
            }
            ((XMSSReducedSignature)((Object)arrayList2)).authPath = object2;
            return;
        } else {
            WOTSPlusSignature wOTSPlusSignature = ((Builder)object).wotsPlusSignature;
            if (wOTSPlusSignature != null) {
                ((XMSSReducedSignature)((Object)arrayList2)).wotsPlusSignature = wOTSPlusSignature;
            } else {
                object2 = ((XMSSParameters)object2).getWOTSPlus().getParams();
                ((XMSSReducedSignature)((Object)arrayList2)).wotsPlusSignature = new WOTSPlusSignature((WOTSPlusParameters)object2, new byte[n4][n3]);
            }
            object = ((Builder)object).authPath;
            if (object != null) {
                if (object.size() != n5) throw new IllegalArgumentException("size of authPath needs to be equal to height of tree");
                ((XMSSReducedSignature)((Object)arrayList2)).authPath = object;
                return;
            } else {
                ArrayList arrayList;
                XMSSReducedSignature xMSSReducedSignature = arrayList2;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                xMSSReducedSignature.authPath = arrayList2;
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        XMSSReducedSignature xMSSReducedSignature = this;
        int n3 = xMSSReducedSignature.params.getTreeDigestSize();
        int n4 = xMSSReducedSignature.params.getWOTSPlus().getParams().getLen() * n3;
        byte[] byArray = new byte[xMSSReducedSignature.params.getHeight() * n3 + n4];
        int n5 = 0;
        byte[][] byArray2 = xMSSReducedSignature.wotsPlusSignature.toByteArray();
        for (int i3 = 0; i3 < byArray2.length; ++i3) {
            XMSSUtil.copyBytesAtOffset(byArray, byArray2[i3], n5);
            n5 += n3;
        }
        for (int i4 = 0; i4 < this.authPath.size(); ++i4) {
            XMSSUtil.copyBytesAtOffset(byArray, this.authPath.get(i4).getValue(), n5);
            n5 += n3;
        }
        return byArray;
    }

    public XMSSParameters getParams() {
        return this.params;
    }

    public WOTSPlusSignature getWOTSPlusSignature() {
        return this.wotsPlusSignature;
    }

    public List<XMSSNode> getAuthPath() {
        return this.authPath;
    }

    public static class Builder {
        private final XMSSParameters params;
        private WOTSPlusSignature wotsPlusSignature = null;
        private List<XMSSNode> authPath = null;
        private byte[] reducedSignature = null;

        public Builder(XMSSParameters xMSSParameters) {
            this.params = xMSSParameters;
        }

        public Builder withWOTSPlusSignature(WOTSPlusSignature wOTSPlusSignature) {
            this.wotsPlusSignature = wOTSPlusSignature;
            return this;
        }

        public Builder withAuthPath(List<XMSSNode> list) {
            this.authPath = list;
            return this;
        }

        public Builder withReducedSignature(byte[] byArray) {
            this.reducedSignature = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public XMSSReducedSignature build() {
            return new XMSSReducedSignature(this);
        }
    }
}

