/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public final class XMSSSignature
extends XMSSReducedSignature
implements Encodable {
    private final int index;
    private final byte[] random;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMSSSignature(Builder builder) {
        super(builder);
        this.index = builder.index;
        int n3 = this.getParams().getTreeDigestSize();
        byte[] byArray = builder.random;
        if (byArray != null) {
            if (byArray.length != n3) throw new IllegalArgumentException("size of random needs to be equal to size of digest");
            this.random = byArray;
            return;
        } else {
            this.random = new byte[n3];
        }
    }

    public /* synthetic */ XMSSSignature(Builder builder, 1 var2_2) {
        this(builder);
    }

    @Override
    public byte[] getEncoded() {
        return this.toByteArray();
    }

    @Override
    public byte[] toByteArray() {
        XMSSSignature xMSSSignature = this;
        int n3 = xMSSSignature.getParams().getTreeDigestSize();
        XMSSSignature xMSSSignature2 = this;
        int n4 = xMSSSignature2.getParams().getWOTSPlus().getParams().getLen() * n3;
        int n5 = xMSSSignature2.getParams().getHeight() * n3;
        byte[] byArray = new byte[b.a(n3, 4, n4, n5)];
        XMSSSignature xMSSSignature3 = this;
        Pack.intToBigEndian(xMSSSignature3.index, byArray, 0);
        XMSSUtil.copyBytesAtOffset(byArray, xMSSSignature3.random, 4);
        n5 = n3 + 4;
        byte[][] byArray2 = xMSSSignature.getWOTSPlusSignature().toByteArray();
        for (int i3 = 0; i3 < byArray2.length; ++i3) {
            XMSSUtil.copyBytesAtOffset(byArray, byArray2[i3], n5);
            n5 += n3;
        }
        for (int i4 = 0; i4 < this.getAuthPath().size(); ++i4) {
            XMSSUtil.copyBytesAtOffset(byArray, this.getAuthPath().get(i4).getValue(), n5);
            n5 += n3;
        }
        return byArray;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getRandom() {
        return XMSSUtil.cloneArray(this.random);
    }

    public static class Builder
    extends XMSSReducedSignature.Builder {
        private final XMSSParameters params;
        private int index = 0;
        private byte[] random = null;

        public Builder(XMSSParameters xMSSParameters) {
            super(xMSSParameters);
            this.params = xMSSParameters;
        }

        public Builder withIndex(int n3) {
            this.index = n3;
            return this;
        }

        public Builder withRandom(byte[] byArray) {
            this.random = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withSignature(byte[] byArray) {
            if (byArray != null) {
                Builder builder = this;
                Builder builder2 = this;
                int n3 = builder2.params.getTreeDigestSize();
                int n4 = this.params.getHeight();
                int n5 = n4 * n3;
                this.index = Pack.bigEndianToInt(byArray, 0);
                this.random = XMSSUtil.extractBytesAtOffset(byArray, 4, n3);
                int n6 = n5;
                n5 = 4 + n3;
                builder.withReducedSignature(XMSSUtil.extractBytesAtOffset(byArray, n5, builder2.params.getWOTSPlus().getParams().getLen() * n3 + n6));
                return builder;
            }
            throw new NullPointerException("signature == null");
        }

        @Override
        public XMSSSignature build() {
            return new XMSSSignature(this, null);
        }
    }
}

