/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;

public class XMSSUtil {
    public static int log2(int n3) {
        int n4 = 0;
        while ((n3 >>= 1) != 0) {
            ++n4;
        }
        return n4;
    }

    public static byte[] toBytesBigEndian(long l3, int n3) {
        byte[] byArray = new byte[n3];
        for (int i3 = (v1372429) - 1; i3 >= 0; --i3) {
            byArray[i3] = (byte)l3;
            l3 >>>= 8;
        }
        return byArray;
    }

    public static void longToBigEndian(long l3, byte[] byArray, int n3) {
        if (byArray != null) {
            if (byArray.length - n3 >= 8) {
                byArray[n3] = (byte)(l3 >> 56 & 0xFFL);
                int n4 = n3 + 1;
                byArray[n4] = (byte)(l3 >> 48 & 0xFFL);
                n4 = n3 + 2;
                byArray[n4] = (byte)(l3 >> 40 & 0xFFL);
                n4 = n3 + 3;
                byArray[n4] = (byte)(l3 >> 32 & 0xFFL);
                n4 = n3 + 4;
                byArray[n4] = (byte)(l3 >> 24 & 0xFFL);
                n4 = n3 + 5;
                byArray[n4] = (byte)(l3 >> 16 & 0xFFL);
                n4 = n3 + 6;
                byArray[n4] = (byte)(l3 >> 8 & 0xFFL);
                n4 = n3 + 7;
                byArray[n4] = (byte)(l3 & 0xFFL);
                return;
            }
            throw new IllegalArgumentException("not enough space in array");
        }
        throw new NullPointerException("in == null");
    }

    public static long bytesToXBigEndian(byte[] byArray, int n3, int n4) {
        if (byArray != null) {
            long l3 = 0L;
            for (int i3 = n3; i3 < n3 + n4; ++i3) {
                l3 = l3 << 8 | (long)(byArray[i3] & 0xFF);
            }
            return l3;
        }
        throw new NullPointerException("in == null");
    }

    public static byte[] cloneArray(byte[] byArray) {
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            int n3 = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        throw new NullPointerException("in == null");
    }

    public static byte[][] cloneArray(byte[][] byArray) {
        if (!XMSSUtil.hasNullPointer(byArray)) {
            byte[][] byArrayArray = new byte[byArray.length][];
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                byte[] byArray2 = new byte[byArray[i3].length];
                byArrayArray[i3] = byArray2;
                byte[] byArray3 = byArray[i3];
                int n3 = byArray3.length;
                System.arraycopy(byArray3, 0, byArray2, 0, n3);
            }
            return byArrayArray;
        }
        throw new NullPointerException("in has null pointers");
    }

    public static boolean areEqual(byte[][] byArray, byte[][] byArray2) {
        if (!XMSSUtil.hasNullPointer(byArray) && !XMSSUtil.hasNullPointer(byArray2)) {
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                if (Arrays.areEqual(byArray[i3], byArray2[i3])) continue;
                return false;
            }
            return true;
        }
        throw new NullPointerException("a or b == null");
    }

    public static void dumpByteArray(byte[][] byArray) {
        if (!XMSSUtil.hasNullPointer(byArray)) {
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                System.out.println(Hex.toHexString(byArray[i3]));
            }
            return;
        }
        throw new NullPointerException("x has null pointers");
    }

    public static boolean hasNullPointer(byte[][] byArray) {
        if (byArray == null) {
            return true;
        }
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            if (byArray[i3] != null) continue;
            return true;
        }
        return false;
    }

    public static void copyBytesAtOffset(byte[] byArray, byte[] byArray2, int n3) {
        if (byArray != null) {
            if (byArray2 != null) {
                if (n3 >= 0) {
                    if (byArray2.length + n3 <= byArray.length) {
                        for (int i3 = 0; i3 < byArray2.length; ++i3) {
                            int n4 = n3 + i3;
                            byArray[n4] = byArray2[i3];
                        }
                        return;
                    }
                    throw new IllegalArgumentException("src length + offset must not be greater than size of destination");
                }
                throw new IllegalArgumentException("offset hast to be >= 0");
            }
            throw new NullPointerException("src == null");
        }
        throw new NullPointerException("dst == null");
    }

    public static byte[] extractBytesAtOffset(byte[] byArray, int n3, int n4) {
        if (byArray != null) {
            if (n3 >= 0) {
                if (n4 >= 0) {
                    if (n3 + n4 <= byArray.length) {
                        byte[] byArray2 = new byte[n4];
                        for (int i3 = 0; i3 < n4; ++i3) {
                            byArray2[i3] = byArray[n3 + i3];
                        }
                        return byArray2;
                    }
                    throw new IllegalArgumentException("offset + length must not be greater then size of source array");
                }
                throw new IllegalArgumentException("length hast to be >= 0");
            }
            throw new IllegalArgumentException("offset hast to be >= 0");
        }
        throw new NullPointerException("src == null");
    }

    public static boolean isIndexValid(int n3, long l3) {
        if (l3 >= 0L) {
            return l3 < 1L << n3;
        }
        throw new IllegalStateException("index must not be negative");
    }

    public static int getDigestSize(Digest digest) {
        if (digest != null) {
            String string2 = digest.getAlgorithmName();
            if (string2.equals("SHAKE128")) {
                return 32;
            }
            if (string2.equals("SHAKE256")) {
                return 64;
            }
            return digest.getDigestSize();
        }
        throw new NullPointerException("digest == null");
    }

    public static long getTreeIndex(long l3, int n3) {
        return l3 >> n3;
    }

    public static int getLeafIndex(long l3, int n3) {
        return (int)(l3 & (1L << n3) - 1L);
    }

    public static byte[] serialize(Object object) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream2);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(byte[] object, Class clazz) {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        CheckingStream checkingStream = new CheckingStream(clazz, byteArrayInputStream2);
        object = checkingStream.readObject();
        if (checkingStream.available() == 0) {
            if (clazz.isInstance(object)) {
                return object;
            }
            throw new IOException("unexpected class found in ObjectInputStream");
        }
        throw new IOException("unexpected data found at end of ObjectInputStream");
    }

    public static int calculateTau(int n3, int n4) {
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            if ((n3 >> i3 & 1) != 0) continue;
            n5 = i3;
            break;
        }
        return n5;
    }

    public static boolean isNewBDSInitNeeded(long l3, int n3, int n4) {
        if (l3 == 0L) {
            return false;
        }
        return l3 % (long)Math.pow(1 << n3, n4 + 1) == 0L;
    }

    public static boolean isNewAuthenticationPathNeeded(long l3, int n3, int n4) {
        if (l3 == 0L) {
            return false;
        }
        return (l3 + 1L) % (long)Math.pow(1 << n3, n4) == 0L;
    }

    public static class CheckingStream
    extends ObjectInputStream {
        private static final Set components = new HashSet<String>();
        private final Class mainClass;
        private boolean found = false;

        public CheckingStream(Class clazz, InputStream inputStream) {
            super(inputStream);
            this.mainClass = clazz;
        }

        static {
            components.add("java.util.TreeMap");
            components.add("java.lang.Integer");
            components.add("java.lang.Number");
            components.add("com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDS");
            components.add("java.util.ArrayList");
            components.add("com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSNode");
            components.add("[B");
            components.add("java.util.LinkedList");
            components.add("java.util.Stack");
            components.add("java.util.Vector");
            components.add("[Ljava.lang.Object;");
            components.add("com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDSTreeHash");
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
            block5: {
                block4: {
                    block2: {
                        block3: {
                            if (this.found) break block2;
                            if (!objectStreamClass.getName().equals(this.mainClass.getName())) break block3;
                            this.found = true;
                            break block4;
                        }
                        throw new InvalidClassException("unexpected class: ", objectStreamClass.getName());
                    }
                    if (!components.contains(objectStreamClass.getName())) break block5;
                }
                return super.resolveClass(objectStreamClass);
            }
            throw new InvalidClassException("unexpected class: ", objectStreamClass.getName());
        }
    }
}

