/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.cmce;

import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.KEMExtractSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.KEMGenerateSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.CMCEKEMExtractor;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.cmce.CMCEKEMGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;

public class CMCEKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    @Override
    public void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        block4: {
            block3: {
                block2: {
                    this.random = secureRandom;
                    if (!(algorithmParameterSpec instanceof KEMGenerateSpec)) break block2;
                    CMCEKeyGeneratorSpi cMCEKeyGeneratorSpi = this;
                    cMCEKeyGeneratorSpi.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
                    cMCEKeyGeneratorSpi.extSpec = null;
                    break block3;
                }
                if (!(algorithmParameterSpec instanceof KEMExtractSpec)) break block4;
                this.genSpec = null;
                this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
            }
            return;
        }
        throw new InvalidAlgorithmParameterException("unknown spec");
    }

    @Override
    public void engineInit(int n3, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public SecretKey engineGenerateKey() {
        Object object = this.genSpec;
        if (object != null) {
            SecretKeySpec secretKeySpec;
            object = (BCCMCEPublicKey)((KEMGenerateSpec)object).getPublicKey();
            object = new CMCEKEMGenerator(this.random).generateEncapsulated(((BCCMCEPublicKey)object).getKeyParams());
            SecretKeySpec secretKeySpec2 = secretKeySpec;
            secretKeySpec = new SecretKeySpec(object.getSecret(), this.genSpec.getKeyAlgorithmName());
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(secretKeySpec2, object.getEncapsulation());
            try {
                object.destroy();
                return secretKeyWithEncapsulation;
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("key cleanup failed");
            }
        }
        object = (BCCMCEPrivateKey)this.extSpec.getPrivateKey();
        CMCEKEMExtractor cMCEKEMExtractor = new CMCEKEMExtractor(((BCCMCEPrivateKey)object).getKeyParams());
        byte[] byArray = this.extSpec.getEncapsulation();
        object = byArray;
        byte[] byArray2 = cMCEKEMExtractor.extractSecret(byArray);
        SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(byArray2, this.extSpec.getKeyAlgorithmName()), (byte[])object);
        Arrays.clear(byArray2);
        return secretKeyWithEncapsulation;
    }
}

