/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.lms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.LMSPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCLMSPrivateKey
implements PrivateKey,
LMSPrivateKey {
    private static final long serialVersionUID = 8568701712864512338L;
    private transient LMSKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCLMSPrivateKey(LMSKeyParameters lMSKeyParameters) {
        this.keyParams = lMSKeyParameters;
    }

    public BCLMSPrivateKey(PrivateKeyInfo privateKeyInfo) {
        BCLMSPrivateKey bCLMSPrivateKey = this;
        bCLMSPrivateKey.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) {
        this.attributes = privateKeyInfo.getAttributes();
        this.keyParams = (LMSKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.init(PrivateKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public long getIndex() {
        if (((BCLMSPrivateKey)((Object)lMSKeyParameters)).getUsagesRemaining() != 0L) {
            LMSKeyParameters lMSKeyParameters = ((BCLMSPrivateKey)((Object)lMSKeyParameters)).keyParams;
            if (lMSKeyParameters instanceof LMSPrivateKeyParameters) {
                return ((LMSPrivateKeyParameters)lMSKeyParameters).getIndex();
            }
            return ((HSSPrivateKeyParameters)lMSKeyParameters).getIndex();
        }
        throw new IllegalStateException("key exhausted");
    }

    @Override
    public long getUsagesRemaining() {
        LMSKeyParameters lMSKeyParameters = ((BCLMSPrivateKey)((Object)lMSKeyParameters)).keyParams;
        if (lMSKeyParameters instanceof LMSPrivateKeyParameters) {
            return ((LMSPrivateKeyParameters)lMSKeyParameters).getUsagesRemaining();
        }
        return ((HSSPrivateKeyParameters)lMSKeyParameters).getUsagesRemaining();
    }

    @Override
    public LMSPrivateKey extractKeyShard(int n3) {
        LMSKeyParameters lMSKeyParameters = ((BCLMSPrivateKey)((Object)lMSKeyParameters)).keyParams;
        if (lMSKeyParameters instanceof LMSPrivateKeyParameters) {
            return new BCLMSPrivateKey(((LMSPrivateKeyParameters)lMSKeyParameters).extractKeyShard(n3));
        }
        return new BCLMSPrivateKey(((HSSPrivateKeyParameters)lMSKeyParameters).extractKeyShard(n3));
    }

    @Override
    public String getAlgorithm() {
        return "LMS";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == bCLMSPrivateKey2) {
            return true;
        }
        if (object instanceof BCLMSPrivateKey) {
            BCLMSPrivateKey bCLMSPrivateKey = bCLMSPrivateKey2;
            BCLMSPrivateKey bCLMSPrivateKey2 = (BCLMSPrivateKey)object;
            try {
                return Arrays.areEqual(bCLMSPrivateKey.keyParams.getEncoded(), bCLMSPrivateKey2.keyParams.getEncoded());
            }
            catch (IOException iOException) {
                throw new IllegalStateException("unable to perform equals");
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to calculate hashCode");
        }
    }

    public CipherParameters getKeyParams() {
        return this.keyParams;
    }

    @Override
    public int getLevels() {
        LMSKeyParameters lMSKeyParameters = ((BCLMSPrivateKey)((Object)lMSKeyParameters)).keyParams;
        if (lMSKeyParameters instanceof LMSPrivateKeyParameters) {
            return 1;
        }
        return ((HSSPrivateKeyParameters)lMSKeyParameters).getL();
    }
}

