/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.McEliecePublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.io.IOException;
import java.security.PublicKey;

public class BCMcEliecePublicKey
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private McEliecePublicKeyParameters params;

    public BCMcEliecePublicKey(McEliecePublicKeyParameters mcEliecePublicKeyParameters) {
        this.params = mcEliecePublicKeyParameters;
    }

    @Override
    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.params.getN();
    }

    public int getK() {
        return this.params.getK();
    }

    public int getT() {
        return this.params.getT();
    }

    public GF2Matrix getG() {
        return this.params.getG();
    }

    public String toString() {
        return e.a(e.a(e.a("McEliecePublicKey:\n", " length of the code         : ").append(this.params.getN()).append("\n").toString(), " error correction capability: ").append(this.params.getT()).append("\n").toString(), " generator matrix           : ").append(this.params.getG()).toString();
    }

    public boolean equals(Object object) {
        if (object instanceof BCMcEliecePublicKey) {
            object = (BCMcEliecePublicKey)object;
            return this.params.getN() == ((BCMcEliecePublicKey)object).getN() && this.params.getT() == ((BCMcEliecePublicKey)object).getT() && this.params.getG().equals(((BCMcEliecePublicKey)object).getG());
        }
        return false;
    }

    public int hashCode() {
        BCMcEliecePublicKey bCMcEliecePublicKey = this;
        int n3 = bCMcEliecePublicKey.params.getN();
        n3 = (bCMcEliecePublicKey.params.getT() * 37 + n3) * 37;
        return bCMcEliecePublicKey.params.getG().hashCode() + n3;
    }

    @Override
    public byte[] getEncoded() {
        AlgorithmIdentifier algorithmIdentifier;
        McEliecePublicKey mcEliecePublicKey;
        McEliecePublicKey mcEliecePublicKey2 = mcEliecePublicKey;
        BCMcEliecePublicKey bCMcEliecePublicKey = this;
        int n3 = bCMcEliecePublicKey.params.getT();
        mcEliecePublicKey = new McEliecePublicKey(this.params.getN(), n3, bCMcEliecePublicKey.params.getG());
        AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
        algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcEliece);
        try {
            return new SubjectPublicKeyInfo(algorithmIdentifier2, mcEliecePublicKey2).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

