/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.McEliecePrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.McEliecePublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class McElieceKeyFactorySpi
extends KeyFactorySpi
implements AsymmetricKeyInfoConverter {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.1";

    private static Digest getDigest(AlgorithmIdentifier algorithmIdentifier) {
        return new SHA256Digest();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) {
        Object object;
        if (!(keySpec instanceof X509EncodedKeySpec)) {
            throw new InvalidKeySpecException(b.b.a("Unsupported key specification: ").append(keySpec.getClass()).append(".").toString());
        }
        try {
            object = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(((X509EncodedKeySpec)keySpec).getEncoded()));
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(((Object)iOException).toString());
        }
        try {
            if (PQCObjectIdentifiers.mcEliece.equals(((SubjectPublicKeyInfo)object).getAlgorithm().getAlgorithm())) {
                Object object2 = object = McEliecePublicKey.getInstance(((SubjectPublicKeyInfo)object).parsePublicKey());
                int n3 = ((McEliecePublicKey)object2).getN();
                int n4 = ((McEliecePublicKey)object2).getT();
                GF2Matrix gF2Matrix = ((McEliecePublicKey)object2).getG();
                return new BCMcEliecePublicKey(new McEliecePublicKeyParameters(n3, n4, gF2Matrix));
            }
            throw new InvalidKeySpecException("Unable to recognise OID in McEliece public key");
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(b.a(iOException, b.b.a("Unable to decode X509EncodedKeySpec: ")));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        Object object;
        if (!(keySpec instanceof PKCS8EncodedKeySpec)) {
            throw new InvalidKeySpecException(b.b.a("Unsupported key specification: ").append(keySpec.getClass()).append(".").toString());
        }
        try {
            object = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(j.a("Unable to decode PKCS8EncodedKeySpec: ", iOException));
        }
        try {
            if (PQCObjectIdentifiers.mcEliece.equals(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getAlgorithm())) {
                Object object2 = object = McEliecePrivateKey.getInstance(((PrivateKeyInfo)object).parsePrivateKey());
                int n3 = ((McEliecePrivateKey)object2).getN();
                int n4 = ((McEliecePrivateKey)object2).getK();
                GF2mField gF2mField = ((McEliecePrivateKey)object2).getField();
                PolynomialGF2mSmallM polynomialGF2mSmallM = ((McEliecePrivateKey)object2).getGoppaPoly();
                Permutation permutation = ((McEliecePrivateKey)object2).getP1();
                Permutation permutation2 = ((McEliecePrivateKey)object2).getP2();
                GF2Matrix gF2Matrix = ((McEliecePrivateKey)object2).getSInv();
                return new BCMcEliecePrivateKey(new McEliecePrivateKeyParameters(n3, n4, gF2mField, polynomialGF2mSmallM, permutation, permutation2, gF2Matrix));
            }
            throw new InvalidKeySpecException("Unable to recognise OID in McEliece private key");
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeySpec getKeySpec(Key key, Class clazz) {
        if (key instanceof BCMcEliecePrivateKey) {
            if (!PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (!(key instanceof BCMcEliecePublicKey)) throw new InvalidKeySpecException(b.b.a("Unsupported key type: ").append(key.getClass()).append(".").toString());
        if (!X509EncodedKeySpec.class.isAssignableFrom(clazz)) throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
        return new X509EncodedKeySpec(key.getEncoded());
    }

    public Key translateKey(Key key) {
        if (!(key instanceof BCMcEliecePrivateKey) && !(key instanceof BCMcEliecePublicKey)) {
            throw new InvalidKeyException("Unsupported key type.");
        }
        return key;
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object = this = McEliecePublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
        int n3 = ((McEliecePublicKey)object).getN();
        int n4 = ((McEliecePublicKey)object).getT();
        GF2Matrix gF2Matrix = ((McEliecePublicKey)object).getG();
        return new BCMcEliecePublicKey(new McEliecePublicKeyParameters(n3, n4, gF2Matrix));
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) {
        Object object = this = McEliecePrivateKey.getInstance(privateKeyInfo.parsePrivateKey().toASN1Primitive());
        int n3 = ((McEliecePrivateKey)object).getN();
        int n4 = ((McEliecePrivateKey)object).getK();
        GF2mField gF2mField = ((McEliecePrivateKey)object).getField();
        PolynomialGF2mSmallM polynomialGF2mSmallM = ((McEliecePrivateKey)object).getGoppaPoly();
        Permutation permutation = ((McEliecePrivateKey)object).getP1();
        Permutation permutation2 = ((McEliecePrivateKey)object).getP2();
        GF2Matrix gF2Matrix = ((McEliecePrivateKey)object).getSInv();
        return new BCMcEliecePrivateKey(new McEliecePrivateKeyParameters(n3, n4, gF2mField, polynomialGF2mSmallM, permutation, permutation2, gF2Matrix));
    }

    public KeySpec engineGetKeySpec(Key key, Class clazz) {
        return null;
    }

    @Override
    public Key engineTranslateKey(Key key) {
        return null;
    }
}

