/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.qtesla;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.NullDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.qtesla.QTESLASigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.qtesla.DigestUtil;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends Signature {
    private Digest digest;
    private QTESLASigner signer;
    private SecureRandom random;

    public SignatureSpi(String string2) {
        super(string2);
    }

    public SignatureSpi(String string2, Digest digest, QTESLASigner qTESLASigner) {
        super(string2);
        this.digest = digest;
        this.signer = qTESLASigner;
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        if (publicKey instanceof BCqTESLAPublicKey) {
            SignatureSpi signatureSpi = cipherParameters;
            CipherParameters cipherParameters = ((BCqTESLAPublicKey)publicKey).getKeyParams();
            signatureSpi.digest.reset();
            signatureSpi.signer.init(false, cipherParameters);
            return;
        }
        throw new InvalidKeyException("unknown public key passed to qTESLA");
    }

    @Override
    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        if (object instanceof BCqTESLAPrivateKey) {
            object = ((BCqTESLAPrivateKey)object).getKeyParams();
            SecureRandom secureRandom = this.random;
            if (secureRandom != null) {
                ParametersWithRandom parametersWithRandom;
                ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
                parametersWithRandom = new ParametersWithRandom((CipherParameters)object, secureRandom);
                object = parametersWithRandom2;
            }
            this.signer.init(true, (CipherParameters)object);
            return;
        }
        throw new InvalidKeyException("unknown private key passed to qTESLA");
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    @Override
    public byte[] engineSign() {
        SignatureSpi signatureSpi;
        try {
            SignatureSpi signatureSpi2 = object;
            signatureSpi = signatureSpi2;
            Object object = DigestUtil.getDigestResult(signatureSpi2.digest);
        }
        catch (Exception exception) {
            if (exception instanceof IllegalStateException) {
                throw new SignatureException(exception.getMessage());
            }
            throw new SignatureException(((Object)exception).toString());
        }
        return signatureSpi.signer.generateSignature((byte[])object);
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        SignatureSpi signatureSpi = object;
        Object object = DigestUtil.getDigestResult(signatureSpi.digest);
        return signatureSpi.signer.verifySignature((byte[])object, byArray);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string2, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string2) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class PIII
    extends SignatureSpi {
        public PIII() {
            QTESLASigner qTESLASigner;
            NullDigest nullDigest;
            PIII pIII = string2;
            String string2 = QTESLASecurityCategory.getName(6);
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            QTESLASigner qTESLASigner2 = qTESLASigner;
            qTESLASigner = new QTESLASigner();
            super(string2, nullDigest2, qTESLASigner2);
        }
    }

    public static class PI
    extends SignatureSpi {
        public PI() {
            QTESLASigner qTESLASigner;
            NullDigest nullDigest;
            PI pI = string2;
            String string2 = QTESLASecurityCategory.getName(5);
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            QTESLASigner qTESLASigner2 = qTESLASigner;
            qTESLASigner = new QTESLASigner();
            super(string2, nullDigest2, qTESLASigner2);
        }
    }

    public static class qTESLA
    extends SignatureSpi {
        public qTESLA() {
            QTESLASigner qTESLASigner;
            NullDigest nullDigest;
            qTESLA qTESLA2 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            QTESLASigner qTESLASigner2 = qTESLASigner;
            qTESLASigner = new QTESLASigner();
            super("qTESLA", nullDigest2, qTESLASigner2);
        }
    }
}

