/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.rainbow;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.RainbowPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.RainbowPublicKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.PublicKey;

public class BCRainbowPublicKey
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private short[][] coeffquadratic;
    private short[][] coeffsingular;
    private short[] coeffscalar;
    private int docLength;
    private RainbowParameters rainbowParams;

    public BCRainbowPublicKey(int n3, short[][] sArray, short[][] sArray2, short[] sArray3) {
        this.docLength = n3;
        this.coeffquadratic = sArray;
        this.coeffsingular = sArray2;
        this.coeffscalar = sArray3;
    }

    public BCRainbowPublicKey(RainbowPublicKeySpec object) {
        RainbowPublicKeySpec rainbowPublicKeySpec = object;
        int n3 = rainbowPublicKeySpec.getDocLength();
        object = rainbowPublicKeySpec.getCoeffQuadratic();
        short[][] sArray = rainbowPublicKeySpec.getCoeffSingular();
        short[] sArray2 = rainbowPublicKeySpec.getCoeffScalar();
        this(n3, (short[][])object, sArray, sArray2);
    }

    public BCRainbowPublicKey(RainbowPublicKeyParameters object) {
        RainbowPublicKeyParameters rainbowPublicKeyParameters = object;
        int n3 = rainbowPublicKeyParameters.getDocLength();
        object = rainbowPublicKeyParameters.getCoeffQuadratic();
        short[][] sArray = rainbowPublicKeyParameters.getCoeffSingular();
        short[] sArray2 = rainbowPublicKeyParameters.getCoeffScalar();
        this(n3, (short[][])object, sArray, sArray2);
    }

    public int getDocLength() {
        return this.docLength;
    }

    public short[][] getCoeffQuadratic() {
        return this.coeffquadratic;
    }

    public short[][] getCoeffSingular() {
        short[][] sArrayArray = new short[this.coeffsingular.length][];
        int n3 = 0;
        while (true) {
            short[][] sArray = this.coeffsingular;
            if (n3 == this.coeffsingular.length) break;
            sArrayArray[n3] = Arrays.clone(sArray[n3]);
            ++n3;
        }
        return sArrayArray;
    }

    public short[] getCoeffScalar() {
        return Arrays.clone(this.coeffscalar);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BCRainbowPublicKey) {
            return this.docLength == ((BCRainbowPublicKey)(object = (BCRainbowPublicKey)object)).getDocLength() && RainbowUtil.equals(this.coeffquadratic, ((BCRainbowPublicKey)object).getCoeffQuadratic()) && RainbowUtil.equals(this.coeffsingular, ((BCRainbowPublicKey)object).getCoeffSingular()) && RainbowUtil.equals(this.coeffscalar, ((BCRainbowPublicKey)object).getCoeffScalar());
        }
        return false;
    }

    public int hashCode() {
        BCRainbowPublicKey bCRainbowPublicKey = this;
        int n3 = bCRainbowPublicKey.docLength * 37;
        n3 = (Arrays.hashCode(bCRainbowPublicKey.coeffquadratic) + n3) * 37;
        n3 = (Arrays.hashCode(bCRainbowPublicKey.coeffsingular) + n3) * 37;
        return Arrays.hashCode(bCRainbowPublicKey.coeffscalar) + n3;
    }

    @Override
    public final String getAlgorithm() {
        return "Rainbow";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        RainbowPublicKey rainbowPublicKey;
        RainbowPublicKey rainbowPublicKey2 = rainbowPublicKey;
        BCRainbowPublicKey bCRainbowPublicKey = this;
        int n3 = bCRainbowPublicKey.docLength;
        short[][] sArray = bCRainbowPublicKey.coeffquadratic;
        short[][] sArray2 = bCRainbowPublicKey.coeffsingular;
        short[] sArray3 = bCRainbowPublicKey.coeffscalar;
        rainbowPublicKey = new RainbowPublicKey(n3, sArray, sArray2, sArray3);
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PQCObjectIdentifiers.rainbow, DERNull.INSTANCE), rainbowPublicKey2);
    }
}

