/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.rainbow;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA224Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA384Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.rainbow.RainbowSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.rainbow.RainbowKeysToParams;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi {
    private Digest digest;
    private RainbowSigner signer;
    private SecureRandom random;

    public SignatureSpi(Digest digest, RainbowSigner rainbowSigner) {
        this.digest = digest;
        this.signer = rainbowSigner;
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        SignatureSpi signatureSpi = asymmetricKeyParameter;
        AsymmetricKeyParameter asymmetricKeyParameter = RainbowKeysToParams.generatePublicKeyParameter(publicKey);
        signatureSpi.digest.reset();
        signatureSpi.signer.init(false, asymmetricKeyParameter);
    }

    @Override
    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        object = RainbowKeysToParams.generatePrivateKeyParameter((PrivateKey)object);
        SecureRandom secureRandom = this.random;
        if (secureRandom != null) {
            ParametersWithRandom parametersWithRandom;
            ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
            parametersWithRandom = new ParametersWithRandom((CipherParameters)object, secureRandom);
            object = parametersWithRandom2;
        }
        SignatureSpi signatureSpi = this;
        signatureSpi.digest.reset();
        signatureSpi.signer.init(true, (CipherParameters)object);
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    @Override
    public byte[] engineSign() {
        SignatureSpi signatureSpi = object;
        Object object = new byte[signatureSpi.digest.getDigestSize()];
        signatureSpi.digest.doFinal((byte[])object, 0);
        try {
            return signatureSpi.signer.generateSignature((byte[])object);
        }
        catch (Exception exception) {
            throw new SignatureException(((Object)exception).toString());
        }
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        SignatureSpi signatureSpi = object;
        Object object = new byte[signatureSpi.digest.getDigestSize()];
        signatureSpi.digest.doFinal((byte[])object, 0);
        return signatureSpi.signer.verifySignature((byte[])object, byArray);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string2, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string2) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class withSha512
    extends SignatureSpi {
        public withSha512() {
            RainbowSigner rainbowSigner;
            SHA512Digest sHA512Digest;
            withSha512 withSha5122 = sHA512Digest2;
            SHA512Digest sHA512Digest2 = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            RainbowSigner rainbowSigner2 = rainbowSigner;
            rainbowSigner = new RainbowSigner();
            super(sHA512Digest2, rainbowSigner2);
        }
    }

    public static class withSha384
    extends SignatureSpi {
        public withSha384() {
            RainbowSigner rainbowSigner;
            SHA384Digest sHA384Digest;
            withSha384 withSha3842 = sHA384Digest2;
            SHA384Digest sHA384Digest2 = sHA384Digest;
            sHA384Digest = new SHA384Digest();
            RainbowSigner rainbowSigner2 = rainbowSigner;
            rainbowSigner = new RainbowSigner();
            super(sHA384Digest2, rainbowSigner2);
        }
    }

    public static class withSha256
    extends SignatureSpi {
        public withSha256() {
            RainbowSigner rainbowSigner;
            SHA256Digest sHA256Digest;
            withSha256 withSha2562 = sHA256Digest2;
            SHA256Digest sHA256Digest2 = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            RainbowSigner rainbowSigner2 = rainbowSigner;
            rainbowSigner = new RainbowSigner();
            super(sHA256Digest2, rainbowSigner2);
        }
    }

    public static class withSha224
    extends SignatureSpi {
        public withSha224() {
            RainbowSigner rainbowSigner;
            SHA224Digest sHA224Digest;
            withSha224 withSha2242 = sHA224Digest2;
            SHA224Digest sHA224Digest2 = sHA224Digest;
            sHA224Digest = new SHA224Digest();
            RainbowSigner rainbowSigner2 = rainbowSigner;
            rainbowSigner = new RainbowSigner();
            super(sHA224Digest2, rainbowSigner2);
        }
    }
}

