/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.saber;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABERKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABERKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABERParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.saber.BCSABERPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.saber.BCSABERPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.SABERParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class SABERKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap<String, SABERParameters>();
    public SABERKeyGenerationParameters param;
    public SABERKeyPairGenerator engine = new SABERKeyPairGenerator();
    public SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    public boolean initialised = false;

    public SABERKeyPairGeneratorSpi() {
        super("SABER");
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof SABERParameterSpec) {
            return ((SABERParameterSpec)algorithmParameterSpec).getName();
        }
        return SpecUtil.getNameFrom(algorithmParameterSpec);
    }

    static {
        parameters.put(SABERParameterSpec.lightsaberkem128r3.getName(), SABERParameters.lightsaberkem128r3);
        parameters.put(SABERParameterSpec.saberkem128r3.getName(), SABERParameters.saberkem128r3);
        parameters.put(SABERParameterSpec.firesaberkem128r3.getName(), SABERParameters.firesaberkem128r3);
        parameters.put(SABERParameterSpec.lightsaberkem192r3.getName(), SABERParameters.lightsaberkem192r3);
        parameters.put(SABERParameterSpec.saberkem192r3.getName(), SABERParameters.saberkem192r3);
        parameters.put(SABERParameterSpec.firesaberkem192r3.getName(), SABERParameters.firesaberkem192r3);
        parameters.put(SABERParameterSpec.lightsaberkem256r3.getName(), SABERParameters.lightsaberkem256r3);
        parameters.put(SABERParameterSpec.saberkem256r3.getName(), SABERParameters.saberkem256r3);
        parameters.put(SABERParameterSpec.firesaberkem256r3.getName(), SABERParameters.firesaberkem256r3);
    }

    @Override
    public void initialize(int n3, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (algorithmParameterSpec instanceof SABERParameterSpec) {
            SABERKeyGenerationParameters sABERKeyGenerationParameters;
            SABERKeyPairGeneratorSpi sABERKeyPairGeneratorSpi = sABERKeyGenerationParameters2;
            SABERKeyGenerationParameters sABERKeyGenerationParameters2 = sABERKeyGenerationParameters;
            sABERKeyPairGeneratorSpi.param = new SABERKeyGenerationParameters(secureRandom, (SABERParameters)parameters.get(SABERKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec)));
            sABERKeyPairGeneratorSpi.engine.init(sABERKeyGenerationParameters2);
            sABERKeyPairGeneratorSpi.initialised = true;
            return;
        }
        throw new InvalidAlgorithmParameterException("parameter object not a SABERParameterSpec");
    }

    @Override
    public KeyPair generateKeyPair() {
        BCSABERPrivateKey bCSABERPrivateKey;
        Object object;
        if (!((SABERKeyPairGeneratorSpi)object2).initialised) {
            SABERKeyGenerationParameters sABERKeyGenerationParameters;
            object = sABERKeyGenerationParameters;
            ((SABERKeyPairGeneratorSpi)object2).param = new SABERKeyGenerationParameters(((SABERKeyPairGeneratorSpi)object2).random, SABERParameters.firesaberkem256r3);
            ((SABERKeyPairGeneratorSpi)object2).engine.init((KeyGenerationParameters)object);
            ((SABERKeyPairGeneratorSpi)object2).initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = ((SABERKeyPairGeneratorSpi)object2).engine.generateKeyPair();
        Object object2 = (SABERPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        object = (SABERPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BCSABERPublicKey bCSABERPublicKey = new BCSABERPublicKey((SABERPublicKeyParameters)object2);
        object2 = bCSABERPrivateKey;
        bCSABERPrivateKey = new BCSABERPrivateKey((SABERPrivateKeyParameters)object);
        return new KeyPair(bCSABERPublicKey, (PrivateKey)object2);
    }
}

