/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.sphincs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCSphincs256PrivateKey
implements PrivateKey,
SPHINCSKey {
    private static final long serialVersionUID = 1L;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSphincs256PrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, SPHINCSPrivateKeyParameters sPHINCSPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.params = sPHINCSPrivateKeyParameters;
    }

    public BCSphincs256PrivateKey(PrivateKeyInfo privateKeyInfo) {
        BCSphincs256PrivateKey bCSphincs256PrivateKey = this;
        bCSphincs256PrivateKey.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) {
        this.attributes = privateKeyInfo.getAttributes();
        this.treeDigest = SPHINCS256KeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        this.params = (SPHINCSPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.init(PrivateKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PrivateKey) {
            object = (BCSphincs256PrivateKey)object;
            return this.treeDigest.equals(((BCSphincs256PrivateKey)object).treeDigest) && Arrays.areEqual(this.params.getKeyData(), ((BCSphincs256PrivateKey)object).params.getKeyData());
        }
        return false;
    }

    public int hashCode() {
        BCSphincs256PrivateKey bCSphincs256PrivateKey = this;
        int n3 = bCSphincs256PrivateKey.treeDigest.hashCode();
        return Arrays.hashCode(bCSphincs256PrivateKey.params.getKeyData()) * 37 + n3;
    }

    @Override
    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    @Override
    public byte[] getEncoded() {
        block9: {
            DEROctetString dEROctetString;
            PrivateKeyInfo privateKeyInfo;
            AlgorithmIdentifier algorithmIdentifier;
            Object object;
            block8: {
                try {
                    if (((BCSphincs256PrivateKey)object).params.getTreeDigest() == null) break block8;
                }
                catch (IOException iOException) {
                    return null;
                }
                object = PrivateKeyInfoFactory.createPrivateKeyInfo(((BCSphincs256PrivateKey)object).params, ((BCSphincs256PrivateKey)object).attributes);
                break block9;
            }
            ASN1Object aSN1Object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(((BCSphincs256PrivateKey)object).treeDigest)));
            PrivateKeyInfo privateKeyInfo2 = privateKeyInfo;
            AlgorithmIdentifier algorithmIdentifier2 = aSN1Object;
            Object object2 = object;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(((BCSphincs256PrivateKey)object).params.getKeyData());
            privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier2, aSN1Object, ((BCSphincs256PrivateKey)object2).attributes);
            object = privateKeyInfo2;
        }
        return ((ASN1Object)object).getEncoded();
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public ASN1ObjectIdentifier getTreeDigest() {
        return this.treeDigest;
    }

    @Override
    public byte[] getKeyData() {
        return this.params.getKeyData();
    }

    public CipherParameters getKeyParams() {
        return this.params;
    }
}

