/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.sphincs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA3Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512tDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCS256Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi {
    private final ASN1ObjectIdentifier treeDigest;
    private Digest digest;
    private SPHINCS256Signer signer;
    private SecureRandom random;

    public SignatureSpi(Digest digest, ASN1ObjectIdentifier aSN1ObjectIdentifier, SPHINCS256Signer sPHINCS256Signer) {
        this.digest = digest;
        this.treeDigest = aSN1ObjectIdentifier;
        this.signer = sPHINCS256Signer;
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        if (publicKey instanceof BCSphincs256PublicKey) {
            if (((SignatureSpi)((Object)cipherParameters)).treeDigest.equals(((BCSphincs256PublicKey)(publicKey = (BCSphincs256PublicKey)publicKey)).getTreeDigest())) {
                SignatureSpi signatureSpi = cipherParameters;
                CipherParameters cipherParameters = ((BCSphincs256PublicKey)publicKey).getKeyParams();
                signatureSpi.digest.reset();
                signatureSpi.signer.init(false, cipherParameters);
                return;
            }
            throw new InvalidKeyException(b.a("SPHINCS-256 signature for tree digest: ").append(((BCSphincs256PublicKey)publicKey).getTreeDigest()).toString());
        }
        throw new InvalidKeyException("unknown public key passed to SPHINCS-256");
    }

    @Override
    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    public void engineInitSign(PrivateKey privateKey) {
        if (privateKey instanceof BCSphincs256PrivateKey) {
            if (((SignatureSpi)((Object)cipherParameters)).treeDigest.equals(((BCSphincs256PrivateKey)(privateKey = (BCSphincs256PrivateKey)privateKey)).getTreeDigest())) {
                SignatureSpi signatureSpi = cipherParameters;
                CipherParameters cipherParameters = ((BCSphincs256PrivateKey)privateKey).getKeyParams();
                signatureSpi.digest.reset();
                signatureSpi.signer.init(true, cipherParameters);
                return;
            }
            throw new InvalidKeyException(b.a("SPHINCS-256 signature for tree digest: ").append(((BCSphincs256PrivateKey)privateKey).getTreeDigest()).toString());
        }
        throw new InvalidKeyException("unknown private key passed to SPHINCS-256");
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    @Override
    public byte[] engineSign() {
        SignatureSpi signatureSpi = object;
        Object object = new byte[signatureSpi.digest.getDigestSize()];
        signatureSpi.digest.doFinal((byte[])object, 0);
        try {
            return signatureSpi.signer.generateSignature((byte[])object);
        }
        catch (Exception exception) {
            throw new SignatureException(((Object)exception).toString());
        }
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        SignatureSpi signatureSpi = object;
        Object object = new byte[signatureSpi.digest.getDigestSize()];
        signatureSpi.digest.doFinal((byte[])object, 0);
        return signatureSpi.signer.verifySignature((byte[])object, byArray);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string2, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string2) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class withSha3_512
    extends SignatureSpi {
        public withSha3_512() {
            SHA3Digest sHA3Digest;
            SHA3Digest sHA3Digest2;
            SPHINCS256Signer sPHINCS256Signer;
            SHA3Digest sHA3Digest3;
            withSha3_512 withSha3_5122 = sHA3Digest4;
            SHA3Digest sHA3Digest4 = sHA3Digest3;
            sHA3Digest3 = new SHA3Digest(512);
            SPHINCS256Signer sPHINCS256Signer2 = sPHINCS256Signer;
            SHA3Digest sHA3Digest5 = sHA3Digest2;
            sHA3Digest2 = new SHA3Digest(256);
            SHA3Digest sHA3Digest6 = sHA3Digest;
            sHA3Digest = new SHA3Digest(512);
            sPHINCS256Signer = new SPHINCS256Signer(sHA3Digest5, sHA3Digest6);
            super(sHA3Digest4, NISTObjectIdentifiers.id_sha3_256, sPHINCS256Signer2);
        }
    }

    public static class withSha512
    extends SignatureSpi {
        public withSha512() {
            SHA512Digest sHA512Digest;
            SHA512tDigest sHA512tDigest;
            SPHINCS256Signer sPHINCS256Signer;
            SHA512Digest sHA512Digest2;
            withSha512 withSha5122 = sHA512Digest3;
            SHA512Digest sHA512Digest3 = sHA512Digest2;
            sHA512Digest2 = new SHA512Digest();
            SPHINCS256Signer sPHINCS256Signer2 = sPHINCS256Signer;
            SHA512tDigest sHA512tDigest2 = sHA512tDigest;
            sHA512tDigest = new SHA512tDigest(256);
            SHA512Digest sHA512Digest4 = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            sPHINCS256Signer = new SPHINCS256Signer(sHA512tDigest2, sHA512Digest4);
            super(sHA512Digest3, NISTObjectIdentifiers.id_sha512_256, sPHINCS256Signer2);
        }
    }
}

