/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.sphincs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA3Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512tDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCS256KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCS256KeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.spec.SPHINCS256KeyGenParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class Sphincs256KeyPairGeneratorSpi
extends KeyPairGenerator {
    public ASN1ObjectIdentifier treeDigest = NISTObjectIdentifiers.id_sha512_256;
    public SPHINCS256KeyGenerationParameters param;
    public SPHINCS256KeyPairGenerator engine = new SPHINCS256KeyPairGenerator();
    public SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    public boolean initialised = false;

    public Sphincs256KeyPairGeneratorSpi() {
        super("SPHINCS256");
    }

    @Override
    public void initialize(int n3, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec object, SecureRandom secureRandom) {
        if (object instanceof SPHINCS256KeyGenParameterSpec) {
            if (((SPHINCS256KeyGenParameterSpec)(object = (SPHINCS256KeyGenParameterSpec)object)).getTreeDigest().equals("SHA512-256")) {
                SHA512tDigest sHA512tDigest;
                Sphincs256KeyPairGeneratorSpi sphincs256KeyPairGeneratorSpi = this;
                sphincs256KeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_sha512_256;
                object = sHA512tDigest;
                sHA512tDigest = new SHA512tDigest(256);
                sphincs256KeyPairGeneratorSpi.param = new SPHINCS256KeyGenerationParameters(secureRandom, (Digest)object);
            } else if (((SPHINCS256KeyGenParameterSpec)object).getTreeDigest().equals("SHA3-256")) {
                SHA3Digest sHA3Digest;
                Sphincs256KeyPairGeneratorSpi sphincs256KeyPairGeneratorSpi = this;
                sphincs256KeyPairGeneratorSpi.treeDigest = NISTObjectIdentifiers.id_sha3_256;
                object = sHA3Digest;
                sHA3Digest = new SHA3Digest(256);
                sphincs256KeyPairGeneratorSpi.param = new SPHINCS256KeyGenerationParameters(secureRandom, (Digest)object);
            }
            this.engine.init(this.param);
            this.initialised = true;
            return;
        }
        throw new InvalidAlgorithmParameterException("parameter object not a SPHINCS256KeyGenParameterSpec");
    }

    @Override
    public KeyPair generateKeyPair() {
        BCSphincs256PrivateKey bCSphincs256PrivateKey;
        Object object;
        if (!this.initialised) {
            SPHINCS256KeyGenerationParameters sPHINCS256KeyGenerationParameters;
            object = sPHINCS256KeyGenerationParameters;
            this.param = new SPHINCS256KeyGenerationParameters(this.random, new SHA512tDigest(256));
            this.engine.init((KeyGenerationParameters)object);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        object = (SPHINCSPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        SPHINCSPrivateKeyParameters sPHINCSPrivateKeyParameters = (SPHINCSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BCSphincs256PublicKey bCSphincs256PublicKey = new BCSphincs256PublicKey(this.treeDigest, (SPHINCSPublicKeyParameters)object);
        object = bCSphincs256PrivateKey;
        bCSphincs256PrivateKey = new BCSphincs256PrivateKey(this.treeDigest, sPHINCSPrivateKeyParameters);
        return new KeyPair(bCSphincs256PublicKey, (PrivateKey)object);
    }
}

