/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.XMSSKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

public class BCXMSSPublicKey
implements PublicKey,
XMSSKey {
    private static final long serialVersionUID = -5617456225328969766L;
    private transient XMSSPublicKeyParameters keyParams;
    private transient ASN1ObjectIdentifier treeDigest;

    public BCXMSSPublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSPublicKeyParameters xMSSPublicKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.keyParams = xMSSPublicKeyParameters;
    }

    public BCXMSSPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        BCXMSSPublicKey bCXMSSPublicKey = this;
        bCXMSSPublicKey.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        BCXMSSPublicKey bCXMSSPublicKey = xMSSPublicKeyParameters;
        XMSSPublicKeyParameters xMSSPublicKeyParameters = (XMSSPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
        bCXMSSPublicKey.keyParams = xMSSPublicKeyParameters;
        bCXMSSPublicKey.treeDigest = DigestUtil.getDigestOID(xMSSPublicKeyParameters.getTreeDigest());
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.init(SubjectPublicKeyInfo.getInstance((byte[])objectInputStream2.readObject()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "XMSS";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSPublicKey) {
            boolean bl;
            block5: {
                object = (BCXMSSPublicKey)object;
                try {
                    if (!this.treeDigest.equals(((BCXMSSPublicKey)object).treeDigest)) break block5;
                }
                catch (IOException iOException) {
                    return false;
                }
                if (!Arrays.areEqual(this.keyParams.getEncoded(), ((BCXMSSPublicKey)object).keyParams.getEncoded())) break block5;
                bl = true;
            }
            bl = false;
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n3;
        int n4;
        BCXMSSPublicKey bCXMSSPublicKey;
        try {
            BCXMSSPublicKey bCXMSSPublicKey2 = this;
            bCXMSSPublicKey = bCXMSSPublicKey2;
            n4 = bCXMSSPublicKey2.treeDigest.hashCode();
            n3 = 37;
        }
        catch (IOException iOException) {
            return this.treeDigest.hashCode();
        }
        return Arrays.hashCode(bCXMSSPublicKey.keyParams.getEncoded()) * n3 + n4;
    }

    @Override
    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    @Override
    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName(this.treeDigest);
    }
}

