/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.NullDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSMTSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.interfaces.StateAwareSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSMTPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSMTSignatureSpi
extends Signature
implements StateAwareSignature {
    private Digest digest;
    private XMSSMTSigner signer;
    private ASN1ObjectIdentifier treeDigest;
    private SecureRandom random;

    public XMSSMTSignatureSpi(String string2) {
        super(string2);
    }

    public XMSSMTSignatureSpi(String string2, Digest digest, XMSSMTSigner xMSSMTSigner) {
        super(string2);
        this.digest = digest;
        this.signer = xMSSMTSigner;
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        if (publicKey instanceof BCXMSSMTPublicKey) {
            XMSSMTSignatureSpi xMSSMTSignatureSpi = cipherParameters;
            CipherParameters cipherParameters = ((BCXMSSMTPublicKey)publicKey).getKeyParams();
            xMSSMTSignatureSpi.treeDigest = null;
            xMSSMTSignatureSpi.digest.reset();
            xMSSMTSignatureSpi.signer.init(false, cipherParameters);
            return;
        }
        throw new InvalidKeyException("unknown public key passed to XMSSMT");
    }

    @Override
    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        if (object instanceof BCXMSSMTPrivateKey) {
            BCXMSSMTPrivateKey bCXMSSMTPrivateKey = (BCXMSSMTPrivateKey)object;
            object = bCXMSSMTPrivateKey.getKeyParams();
            this.treeDigest = bCXMSSMTPrivateKey.getTreeDigestOID();
            SecureRandom secureRandom = this.random;
            if (secureRandom != null) {
                ParametersWithRandom parametersWithRandom;
                ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
                parametersWithRandom = new ParametersWithRandom((CipherParameters)object, secureRandom);
                object = parametersWithRandom2;
            }
            XMSSMTSignatureSpi xMSSMTSignatureSpi = this;
            xMSSMTSignatureSpi.digest.reset();
            xMSSMTSignatureSpi.signer.init(true, (CipherParameters)object);
            return;
        }
        throw new InvalidKeyException("unknown private key passed to XMSSMT");
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    @Override
    public byte[] engineSign() {
        XMSSMTSignatureSpi xMSSMTSignatureSpi = object;
        Object object = DigestUtil.getDigestResult(xMSSMTSignatureSpi.digest);
        try {
            return xMSSMTSignatureSpi.signer.generateSignature((byte[])object);
        }
        catch (Exception exception) {
            if (exception instanceof IllegalStateException) {
                throw new SignatureException(exception.getMessage(), exception);
            }
            throw new SignatureException(((Object)exception).toString());
        }
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        XMSSMTSignatureSpi xMSSMTSignatureSpi = object;
        Object object = DigestUtil.getDigestResult(xMSSMTSignatureSpi.digest);
        return xMSSMTSignatureSpi.signer.verifySignature((byte[])object, byArray);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string2, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string2) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public boolean isSigningCapable() {
        return this.treeDigest != null && this.signer.getUsagesRemaining() != 0L;
    }

    @Override
    public PrivateKey getUpdatedPrivateKey() {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.treeDigest;
        if (aSN1ObjectIdentifier != null) {
            this.treeDigest = null;
            return new BCXMSSMTPrivateKey(aSN1ObjectIdentifier, (XMSSMTPrivateKeyParameters)this.signer.getUpdatedPrivateKey());
        }
        throw new IllegalStateException("signature object not in a signing state");
    }

    public static class withShake256andPrehash
    extends XMSSMTSignatureSpi {
        public withShake256andPrehash() {
            XMSSMTSigner xMSSMTSigner;
            SHAKEDigest sHAKEDigest;
            withShake256andPrehash withShake256andPrehash2 = sHAKEDigest2;
            SHAKEDigest sHAKEDigest2 = sHAKEDigest;
            sHAKEDigest = new SHAKEDigest(256);
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner = new XMSSMTSigner();
            super("SHAKE256withXMSSMT-SHAKE256", sHAKEDigest2, xMSSMTSigner2);
        }
    }

    public static class withSha512andPrehash
    extends XMSSMTSignatureSpi {
        public withSha512andPrehash() {
            XMSSMTSigner xMSSMTSigner;
            SHA512Digest sHA512Digest;
            withSha512andPrehash withSha512andPrehash2 = sHA512Digest2;
            SHA512Digest sHA512Digest2 = sHA512Digest;
            sHA512Digest = new SHA512Digest();
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner = new XMSSMTSigner();
            super("SHA512withXMSSMT-SHA512", sHA512Digest2, xMSSMTSigner2);
        }
    }

    public static class withShake128andPrehash
    extends XMSSMTSignatureSpi {
        public withShake128andPrehash() {
            XMSSMTSigner xMSSMTSigner;
            SHAKEDigest sHAKEDigest;
            withShake128andPrehash withShake128andPrehash2 = sHAKEDigest2;
            SHAKEDigest sHAKEDigest2 = sHAKEDigest;
            sHAKEDigest = new SHAKEDigest(128);
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner = new XMSSMTSigner();
            super("SHAKE128withXMSSMT-SHAKE128", sHAKEDigest2, xMSSMTSigner2);
        }
    }

    public static class withSha256andPrehash
    extends XMSSMTSignatureSpi {
        public withSha256andPrehash() {
            XMSSMTSigner xMSSMTSigner;
            SHA256Digest sHA256Digest;
            withSha256andPrehash withSha256andPrehash2 = sHA256Digest2;
            SHA256Digest sHA256Digest2 = sHA256Digest;
            sHA256Digest = new SHA256Digest();
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner = new XMSSMTSigner();
            super("SHA256withXMSSMT-SHA256", sHA256Digest2, xMSSMTSigner2);
        }
    }

    public static class withShake256
    extends XMSSMTSignatureSpi {
        public withShake256() {
            XMSSMTSigner xMSSMTSigner;
            NullDigest nullDigest;
            withShake256 withShake2562 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner = new XMSSMTSigner();
            super("XMSSMT-SHAKE256", nullDigest2, xMSSMTSigner2);
        }
    }

    public static class withSha512
    extends XMSSMTSignatureSpi {
        public withSha512() {
            XMSSMTSigner xMSSMTSigner;
            NullDigest nullDigest;
            withSha512 withSha5122 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner = new XMSSMTSigner();
            super("XMSSMT-SHA512", nullDigest2, xMSSMTSigner2);
        }
    }

    public static class withShake128
    extends XMSSMTSignatureSpi {
        public withShake128() {
            XMSSMTSigner xMSSMTSigner;
            NullDigest nullDigest;
            withShake128 withShake1282 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner = new XMSSMTSigner();
            super("XMSSMT-SHAKE128", nullDigest2, xMSSMTSigner2);
        }
    }

    public static class withSha256
    extends XMSSMTSignatureSpi {
        public withSha256() {
            XMSSMTSigner xMSSMTSigner;
            NullDigest nullDigest;
            withSha256 withSha2562 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner = new XMSSMTSigner();
            super("XMSSMT-SHA256", nullDigest2, xMSSMTSigner2);
        }
    }

    public static class generic
    extends XMSSMTSignatureSpi {
        public generic() {
            XMSSMTSigner xMSSMTSigner;
            NullDigest nullDigest;
            generic generic2 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            XMSSMTSigner xMSSMTSigner2 = xMSSMTSigner;
            xMSSMTSigner = new XMSSMTSigner();
            super("XMSSMT", nullDigest2, xMSSMTSigner2);
        }
    }
}

